/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui;

import de.katzenpapst.amunra.helper.GuiHelper;
import de.katzenpapst.amunra.inventory.ContainerShuttleDock;
import de.katzenpapst.amunra.item.ItemShuttle;
import de.katzenpapst.amunra.tile.TileEntityShuttleDock;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiShuttleDock
extends GuiContainerGC {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("amunra", "textures/gui/dock-gui.png");
    private final TileEntityShuttleDock tile;
    private GuiButton buttonGetShuttle;
    private GuiButton buttonPutShuttle;
    private GuiButton buttonEnterShuttle;
    private boolean isObstructed = true;
    private GuiElementInfoRegion shuttleInfoRegion;

    public GuiShuttleDock(InventoryPlayer player, TileEntityShuttleDock tile) {
        super((Container)new ContainerShuttleDock(player, tile));
        this.tile = tile;
        this.field_147000_g = 210;
        this.field_146999_f = 176;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.tile.performDockOperationClient(TileEntityShuttleDock.DockOperation.GET_SHUTTLE);
            }
            case 1: {
                this.tile.performDockOperationClient(TileEntityShuttleDock.DockOperation.MOUNT_SHUTTLE);
            }
            case 2: {
                this.tile.performDockOperationClient(TileEntityShuttleDock.DockOperation.DEPLOY_SHUTTLE);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.isObstructed = this.tile.isObstructed();
        this.shuttleInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 23, (this.field_146295_m - this.field_147000_g) / 2 + 57, 18, 27, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        ArrayList<String> descrStrings = new ArrayList<String>();
        descrStrings.add("foobar");
        this.shuttleInfoRegion.tooltipStrings = descrStrings;
        this.shuttleInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 23;
        this.shuttleInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 57;
        this.shuttleInfoRegion.parentWidth = this.field_146294_l;
        this.shuttleInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.shuttleInfoRegion);
        this.buttonGetShuttle = new GuiButton(0, (this.field_146294_l - this.field_146999_f) / 2 + 52, (this.field_146295_m - this.field_147000_g) / 2 + 20, 72, 20, GCCoreUtil.translate((String)"gui.message.dock.action.get"));
        this.buttonEnterShuttle = new GuiButton(1, (this.field_146294_l - this.field_146999_f) / 2 + 52, (this.field_146295_m - this.field_147000_g) / 2 + 56, 72, 20, GCCoreUtil.translate((String)"gui.message.dock.action.enter"));
        this.buttonPutShuttle = new GuiButton(2, (this.field_146294_l - this.field_146999_f) / 2 + 52, (this.field_146295_m - this.field_147000_g) / 2 + 93, 72, 20, GCCoreUtil.translate((String)"gui.message.dock.action.deploy"));
        this.field_146292_n.add(this.buttonGetShuttle);
        this.field_146292_n.add(this.buttonEnterShuttle);
        this.field_146292_n.add(this.buttonPutShuttle);
    }

    protected void func_146979_b(int par1, int par2) {
        String displayString = this.tile.func_145825_b();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 7, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
        this.shuttleInfoRegion.tooltipStrings.clear();
        this.shuttleInfoRegion.tooltipStrings.addAll(this.getStatus());
        ItemStack stack = this.tile.func_70301_a(0);
        boolean hasShuttle = this.tile.hasShuttle();
        boolean hasItem = false;
        if (stack != null) {
            hasItem = stack.field_77994_a > 0 && stack.func_77973_b() instanceof ItemShuttle;
        }
        this.buttonGetShuttle.field_146124_l = !hasItem && hasShuttle;
        this.buttonPutShuttle.field_146124_l = hasItem && !hasShuttle && !this.isObstructed;
        this.buttonEnterShuttle.field_146124_l = hasShuttle;
    }

    protected List<String> getStatus() {
        if (this.tile.hasShuttle()) {
            return GCCoreUtil.translateWithSplit((String)"gui.message.dock.status.occupied");
        }
        if (this.isObstructed) {
            return GuiHelper.translateWithSplitColor("gui.message.dock.status.obstructed", EnumColor.DARK_RED);
        }
        return GCCoreUtil.translateWithSplit((String)"gui.message.dock.status.free");
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(GUI_TEXTURE);
        int xOffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yOffset = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xOffset, yOffset, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.isObstructed) {
            this.func_73729_b(xPos + 24, yPos + 59, 176, 28, 16, 16);
        }
        if (this.tile.hasShuttle()) {
            this.func_73729_b(xPos + 23, yPos + 53, 176, 1, 18, 27);
        }
    }
}

