/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.Forestry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.apiculture.ArmorApiaristHelper;
import forestry.apiculture.EventHandlerApiculture;
import forestry.apiculture.SaveEventHandlerApiculture;
import forestry.apiculture.VillageHandlerApiculture;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockApicultureType;
import forestry.apiculture.blocks.BlockCandle;
import forestry.apiculture.blocks.BlockRegistryApiculture;
import forestry.apiculture.commands.CommandBee;
import forestry.apiculture.entities.EntityMinecartApiary;
import forestry.apiculture.entities.EntityMinecartBeehouse;
import forestry.apiculture.flowers.FlowerRegistry;
import forestry.apiculture.genetics.BeeBranchDefinition;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeFactory;
import forestry.apiculture.genetics.BeeHelper;
import forestry.apiculture.genetics.BeeMutationFactory;
import forestry.apiculture.genetics.BeekeepingMode;
import forestry.apiculture.genetics.HiveDrop;
import forestry.apiculture.genetics.JubilanceFactory;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.EnumPropolis;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.apiculture.multiblock.TileAlvearyFan;
import forestry.apiculture.multiblock.TileAlvearyHeater;
import forestry.apiculture.multiblock.TileAlvearyHygroregulator;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearyStabiliser;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.network.PacketRegistryApiculture;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.tiles.TileApiaristChest;
import forestry.apiculture.tiles.TileCandle;
import forestry.apiculture.tiles.TileSwarm;
import forestry.apiculture.trigger.ApicultureTriggers;
import forestry.apiculture.worldgen.HiveDecorator;
import forestry.apiculture.worldgen.HiveDescription;
import forestry.apiculture.worldgen.HiveGenHelper;
import forestry.apiculture.worldgen.HiveRegistry;
import forestry.core.ISaveEventHandler;
import forestry.core.blocks.BlockCoreType;
import forestry.core.config.Config;
import forestry.core.config.Constants;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.entities.EntityFXSnow;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.network.IPacketRegistry;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.MachineDefinition;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Stack;
import forestry.core.utils.StringUtil;
import forestry.food.items.ItemRegistryFood;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginFluids;
import forestry.plugins.PluginFood;
import forestry.plugins.PluginManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.FluidStack;

@Plugin(pluginID="Apiculture", name="Apiculture", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.apiculture.description")
public class PluginApiculture
extends ForestryPlugin {
    @SidedProxy(clientSide="forestry.apiculture.proxy.ProxyApicultureClient", serverSide="forestry.apiculture.proxy.ProxyApiculture")
    public static ProxyApiculture proxy;
    private static final String CONFIG_CATEGORY = "apiculture";
    public static String beekeepingMode;
    private static float secondPrincessChance;
    public static final int ticksPerBeeWorkCycle = 550;
    public static boolean fancyRenderedBees;
    public static ItemRegistryApiculture items;
    public static BlockRegistryApiculture blocks;
    public static HiveRegistry hiveRegistry;
    private final Map<String, String[]> defaultAcceptedFlowers = new HashMap<String, String[]>();
    private final Map<String, String[]> defaultPlantableFlowers = new HashMap<String, String[]>();

    @Override
    protected void setupAPI() {
        super.setupAPI();
        hiveRegistry = new HiveRegistry();
        HiveManager.hiveRegistry = hiveRegistry;
        HiveManager.genHelper = new HiveGenHelper();
        FlowerManager.flowerRegistry = new FlowerRegistry();
        BeeManager.villageBees = new ArrayList[]{new ArrayList(), new ArrayList()};
        BeeManager.beeFactory = new BeeFactory();
        BeeManager.beeMutationFactory = new BeeMutationFactory();
        BeeManager.jubilanceFactory = new JubilanceFactory();
        BeeManager.armorApiaristHelper = new ArmorApiaristHelper();
        BeeManager.beeRoot = new BeeHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(BeeManager.beeRoot);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.easy);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.normal);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.hard);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.hardcore);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.insane);
    }

    @Override
    protected void registerItemsAndBlocks() {
        items = new ItemRegistryApiculture();
        blocks = new BlockRegistryApiculture();
    }

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerApiculture());
        PluginApiculture.blocks.apiculture.addDefinitions(new MachineDefinition(BlockApicultureType.APIARY).setFaces(0, 1, 2, 2, 4, 4, 0, 7), new MachineDefinition(BlockApicultureType.APIARIST_CHEST_LEGACY).setLegacy(), new MachineDefinition(BlockApicultureType.BEEHOUSE).setFaces(0, 1, 2, 2, 4, 4, 0, 7));
        MachineDefinition definitionChest = new MachineDefinition(0, "forestry.ApiaristChestNew", TileApiaristChest.class, Proxies.render.getRenderChest("apiaristchest")).setBoundingBox(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        PluginApiculture.blocks.apicultureChest.addDefinition(definitionChest);
        if (PluginManager.Module.BUILDCRAFT_STATEMENTS.isEnabled()) {
            ApicultureTriggers.initialize();
        }
        if (Config.enableVillagers) {
            VillageHandlerApiculture.registerVillageComponents();
        }
        PluginCore.rootCommand.addChildCommand(new CommandBee());
    }

    @Override
    public void doInit() {
        boolean deleted;
        LocalizedConfiguration config;
        File configFile = new File(Forestry.instance.getConfigFolder(), "apiculture.cfg");
        if (!configFile.exists()) {
            this.setDefaultsForConfig();
        }
        if (!Objects.equals((config = new LocalizedConfiguration(configFile, "2.0.0")).getLoadedConfigVersion(), config.getDefinedConfigVersion()) && (deleted = configFile.delete())) {
            config = new LocalizedConfiguration(configFile, "2.0.0");
            this.setDefaultsForConfig();
        }
        ArrayList<IBeekeepingMode> beekeepingModes = BeeManager.beeRoot.getBeekeepingModes();
        String[] validBeekeepingModeNames = new String[beekeepingModes.size()];
        for (int i = 0; i < beekeepingModes.size(); ++i) {
            validBeekeepingModeNames[i] = ((IBeekeepingMode)beekeepingModes.get(i)).getName();
        }
        beekeepingMode = config.getStringLocalized("beekeeping", "mode", "NORMAL", validBeekeepingModeNames);
        Log.finer("Beekeeping mode read from config: " + beekeepingMode);
        secondPrincessChance = config.getFloatLocalized("beekeeping", "second.princess", secondPrincessChance, 0.0f, 100.0f);
        String acceptedFlowerMessage = StringUtil.localize("config.beekeeping.flowers.accepted.comment");
        String plantableFlowerMessage = StringUtil.localize("config.beekeeping.flowers.plantable.comment");
        for (String flowerType : FlowerManager.flowerRegistry.getFlowerTypes()) {
            String[] defaultAccepted = this.defaultAcceptedFlowers.get(flowerType);
            if (defaultAccepted == null) {
                defaultAccepted = Constants.EMPTY_STRINGS;
            }
            Property property = config.get("beekeeping.flowers." + flowerType, "accepted", defaultAccepted);
            property.comment = acceptedFlowerMessage;
            PluginApiculture.parseAcceptedFlowers(property.getStringList(), flowerType);
            String[] defaultPlantable = this.defaultPlantableFlowers.get(flowerType);
            if (defaultPlantable == null) {
                defaultPlantable = Constants.EMPTY_STRINGS;
            }
            property = config.get("beekeeping.flowers." + flowerType, "plantable", defaultPlantable);
            property.comment = plantableFlowerMessage;
            PluginApiculture.parsePlantableFlowers(property, flowerType);
            Set<IFlower> acceptableFlowers = FlowerManager.flowerRegistry.getAcceptableFlowers(flowerType);
            if (acceptableFlowers != null && acceptableFlowers.size() != 0) continue;
            Log.severe("Flower type '" + flowerType + "' has no valid flowers set in apiculture.cfg. Add valid flowers or delete the config to set it to default.");
        }
        String[] blacklist = config.getStringListLocalized("species", "blacklist", Constants.EMPTY_STRINGS);
        PluginApiculture.parseBeeBlacklist(blacklist);
        config.save();
        PluginApiculture.createAlleles();
        BeeDefinition.initBees();
        AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.speciesArgrarian", BeeDefinition.AGRARIAN.getGenome().getPrimary());
        PluginApiculture.createHives();
        PluginApiculture.registerBeehiveDrops();
        BeeManager.inducers.put(PluginApiculture.items.royalJelly.getItemStack(), 10);
        GameRegistry.registerTileEntity(TileAlvearyPlain.class, (String)"forestry.Alveary");
        GameRegistry.registerTileEntity(TileSwarm.class, (String)"forestry.Swarm");
        GameRegistry.registerTileEntity(TileAlvearySwarmer.class, (String)"forestry.AlvearySwarmer");
        GameRegistry.registerTileEntity(TileAlvearyHeater.class, (String)"forestry.AlvearyHeater");
        GameRegistry.registerTileEntity(TileAlvearyFan.class, (String)"forestry.AlvearyFan");
        GameRegistry.registerTileEntity(TileAlvearyHygroregulator.class, (String)"forestry.AlvearyHygro");
        GameRegistry.registerTileEntity(TileAlvearyStabiliser.class, (String)"forestry.AlvearyStabiliser");
        GameRegistry.registerTileEntity(TileAlvearySieve.class, (String)"forestry.AlvearySieve");
        GameRegistry.registerTileEntity(TileCandle.class, (String)"forestry.Candle");
        EntityUtil.registerEntity(EntityMinecartBeehouse.class, "cart.beehouse", 1, 0, 0xFFFFFF, 256, 3, true);
        EntityUtil.registerEntity(EntityMinecartApiary.class, "cart.apiary", 2, 0, 0xFFFFFF, 256, 3, true);
        BeeManager.villageBees[0].add(BeeDefinition.FOREST.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.MEADOWS.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.MODEST.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.MARSHY.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.WINTRY.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.TROPICAL.getGenome());
        BeeManager.villageBees[1].add(BeeDefinition.FOREST.getRainResist().getGenome());
        BeeManager.villageBees[1].add(BeeDefinition.COMMON.getGenome());
        BeeManager.villageBees[1].add(BeeDefinition.VALIANT.getGenome());
        if (Config.enableVillagers) {
            VillageHandlerApiculture villageHandler = new VillageHandlerApiculture();
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageHandler);
            VillagerRegistry.instance().registerVillagerId(80);
            Proxies.render.registerVillagerSkin(80, "textures/entity/beekeeper.png");
            VillagerRegistry.instance().registerVillageTradeHandler(80, (VillagerRegistry.IVillageTradeHandler)villageHandler);
        }
        proxy.initializeRendering();
        PluginApiculture.blocks.apiculture.init();
        PluginApiculture.blocks.apicultureChest.init();
    }

    @Override
    public void postInit() {
        super.postInit();
        PluginApiculture.registerDungeonLoot();
    }

    private void setDefaultsForConfig() {
        IFlowerRegistry flowerRegistry = FlowerManager.flowerRegistry;
        flowerRegistry.registerAcceptableFlower(Blocks.field_150380_bt, "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150395_bd, "flowersJungle");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.field_150329_H, "flowersJungle");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150464_aj, "flowersWheat");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150393_bb, "flowersGourd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150394_bc, "flowersGourd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150388_bm, "flowersNether");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150434_aF, "flowersCacti");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.field_150398_cm, 0, "flowersVanilla", "flowersSnow");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.field_150398_cm, 1, "flowersVanilla", "flowersSnow");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.field_150398_cm, 4, "flowersVanilla", "flowersSnow");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.field_150398_cm, 5, "flowersVanilla", "flowersSnow");
        for (int meta = 0; meta <= 8; ++meta) {
            flowerRegistry.registerPlantableFlower((Block)Blocks.field_150328_O, meta, 1.0, "flowersVanilla", "flowersSnow");
        }
        flowerRegistry.registerPlantableFlower((Block)Blocks.field_150327_N, 0, 1.0, "flowersVanilla", "flowersSnow");
        flowerRegistry.registerPlantableFlower((Block)Blocks.field_150338_P, 0, 1.0, "flowersMushrooms");
        flowerRegistry.registerPlantableFlower((Block)Blocks.field_150337_Q, 0, 1.0, "flowersMushrooms");
        flowerRegistry.registerPlantableFlower(Blocks.field_150434_aF, 0, 1.0, "flowersCacti");
        for (String flowerType : FlowerManager.flowerRegistry.getFlowerTypes()) {
            Set<IFlower> flowers = FlowerManager.flowerRegistry.getAcceptableFlowers(flowerType);
            ArrayList<String> acceptedFlowerNames = new ArrayList<String>();
            ArrayList<String> plantableFlowerNames = new ArrayList<String>();
            if (flowers != null) {
                for (IFlower flower : flowers) {
                    String name = GameData.getBlockRegistry().func_148750_c((Object)flower.getBlock());
                    if (name == null) {
                        Log.severe("Could not find name for flower: " + flower + " with type: " + flowerType);
                        continue;
                    }
                    int meta = flower.getMeta();
                    if (flower.getMeta() != Short.MAX_VALUE) {
                        name = name + ':' + meta;
                    }
                    if (flower.isPlantable()) {
                        plantableFlowerNames.add(name);
                        continue;
                    }
                    acceptedFlowerNames.add(name);
                }
            }
            String[] acceptedFlowerNamesArray = acceptedFlowerNames.toArray(new String[acceptedFlowerNames.size()]);
            this.defaultAcceptedFlowers.put(flowerType, acceptedFlowerNamesArray);
            String[] plantableFlowerNamesArray = plantableFlowerNames.toArray(new String[plantableFlowerNames.size()]);
            this.defaultPlantableFlowers.put(flowerType, plantableFlowerNamesArray);
        }
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryApiculture();
    }

    @Override
    protected void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(PluginCore.items.beeswax.getItemStack(), "cratedBeeswax");
        crateRegistry.registerCrate(PluginApiculture.items.pollenCluster.get(EnumPollenCluster.NORMAL, 1), "cratedPollen");
        crateRegistry.registerCrate(PluginApiculture.items.pollenCluster.get(EnumPollenCluster.CRYSTALLINE, 1), "cratedCrystallinePollen");
        crateRegistry.registerCrate(PluginApiculture.items.propolis.getItemStack(), "cratedPropolis");
        crateRegistry.registerCrate(PluginApiculture.items.honeydew.getItemStack(), "cratedHoneydew");
        crateRegistry.registerCrate(PluginApiculture.items.royalJelly.getItemStack(), "cratedRoyalJelly");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.HONEY, 1), "cratedHoneycombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.COCOA, 1), "cratedCocoaComb");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), "cratedSimmeringCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.STRINGY, 1), "cratedStringyCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.FROZEN, 1), "cratedFrozenCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.DRIPPING, 1), "cratedDrippingCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.SILKY, 1), "cratedSilkyCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.PARCHED, 1), "cratedParchedCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.MYSTERIOUS, 1), "cratedMysteriousCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.POWDERY, 1), "cratedPowderyCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.WHEATEN, 1), "cratedWheatenCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.MOSSY, 1), "cratedMossyCombs");
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.MELLOW, 1), "cratedMellowCombs");
        crateRegistry.registerCrate(PluginCore.items.refractoryWax.getItemStack(), "cratedRefractoryWax");
    }

    @Override
    protected void registerRecipes() {
        ItemStack wovenSilk = PluginCore.items.craftingMaterial.getWovenSilk();
        RecipeUtil.addRecipe((Item)PluginApiculture.items.apiaristHat, "###", "# #", Character.valueOf('#'), wovenSilk);
        RecipeUtil.addRecipe((Item)PluginApiculture.items.apiaristChest, "# #", "###", "###", Character.valueOf('#'), wovenSilk);
        RecipeUtil.addRecipe((Item)PluginApiculture.items.apiaristLegs, "###", "# #", "# #", Character.valueOf('#'), wovenSilk);
        RecipeUtil.addRecipe((Item)PluginApiculture.items.apiaristBoots, "# #", "# #", Character.valueOf('#'), wovenSilk);
        RecipeUtil.addRecipe(PluginApiculture.items.habitatLocator, " X ", "X#X", " X ", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotBronze");
        RecipeUtil.addRecipe(PluginApiculture.items.scoop, "#X#", "###", " # ", Character.valueOf('#'), "stickWood", Character.valueOf('X'), Blocks.field_150325_L);
        RecipeUtil.addRecipe(new ItemStack(Items.field_151123_aH), new Object[]{"#X#", "#X#", "#X#", Character.valueOf('#'), PluginApiculture.items.propolis, Character.valueOf('X'), PluginApiculture.items.pollenCluster.get(EnumPollenCluster.NORMAL, 1)});
        RecipeUtil.addRecipe(new ItemStack(Items.field_151060_bw), new Object[]{"#X#", "#Y#", "#X#", Character.valueOf('#'), PluginApiculture.items.honeyDrop, Character.valueOf('X'), PluginApiculture.items.honeydew, Character.valueOf('Y'), Items.field_151127_ba});
        RecipeUtil.addRecipe(PluginApiculture.items.frameUntreated, "###", "#S#", "###", Character.valueOf('#'), "stickWood", Character.valueOf('S'), Items.field_151007_F);
        RecipeUtil.addRecipe(PluginApiculture.items.frameImpregnated, new Object[]{"###", "#S#", "###", Character.valueOf('#'), PluginCore.items.stickImpregnated, Character.valueOf('S'), Items.field_151007_F});
        RecipeUtil.addRecipe(PluginApiculture.items.minecartBeehouse.getBeeHouseMinecart(), "B", "C", Character.valueOf('B'), PluginApiculture.blocks.apiculture.get(BlockApicultureType.BEEHOUSE), Character.valueOf('C'), Items.field_151143_au);
        RecipeUtil.addRecipe(PluginApiculture.items.minecartBeehouse.getApiaryMinecart(), "B", "C", Character.valueOf('B'), PluginApiculture.blocks.apiculture.get(BlockApicultureType.APIARY), Character.valueOf('C'), Items.field_151143_au);
        ItemRegistryFood foodItems = PluginFood.items;
        if (foodItems != null) {
            RecipeUtil.addRecipe(new ItemStack((Item)foodItems.honeyedSlice, 4), new Object[]{"###", "#X#", "###", Character.valueOf('#'), PluginApiculture.items.honeyDrop, Character.valueOf('X'), Items.field_151025_P});
            RecipeUtil.addRecipe((Item)foodItems.honeyPot, new Object[]{"# #", " X ", "# #", Character.valueOf('#'), PluginApiculture.items.honeyDrop, Character.valueOf('X'), PluginFluids.items.waxCapsuleEmpty});
            RecipeUtil.addRecipe((Item)foodItems.ambrosia, new Object[]{"#Y#", "XXX", "###", Character.valueOf('#'), PluginApiculture.items.honeydew, Character.valueOf('X'), PluginApiculture.items.royalJelly, Character.valueOf('Y'), PluginFluids.items.waxCapsuleEmpty});
        }
        RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.capsule"), new Object[]{"###", Character.valueOf('#'), PluginCore.items.beeswax});
        RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.refractory"), new Object[]{"###", Character.valueOf('#'), PluginCore.items.refractoryWax});
        RecipeUtil.addRecipe(PluginCore.items.bituminousPeat.getItemStack(), new Object[]{" # ", "XYX", " # ", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), PluginCore.items.peat, Character.valueOf('Y'), PluginApiculture.items.propolis});
        RecipeUtil.addRecipe(new ItemStack(Blocks.field_150478_aa, 3), new Object[]{" # ", " # ", " Y ", Character.valueOf('#'), PluginCore.items.beeswax, Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe(PluginCore.items.craftingMaterial.getPulsatingMesh(), "# #", " # ", "# #", Character.valueOf('#'), PluginApiculture.items.propolis.get(EnumPropolis.PULSATING, 1));
        RecipeUtil.addRecipe(PluginApiculture.items.waxCast, new Object[]{"###", "# #", "###", Character.valueOf('#'), PluginCore.items.beeswax});
        RecipeUtil.addRecipe(PluginApiculture.blocks.alveary.get(BlockAlveary.Type.PLAIN), new Object[]{"###", "#X#", "###", Character.valueOf('X'), PluginCore.items.impregnatedCasing, Character.valueOf('#'), PluginCore.items.craftingMaterial.getScentedPaneling()});
        RecipeUtil.addRecipe(PluginApiculture.blocks.alveary.get(BlockAlveary.Type.SWARMER), new Object[]{"#G#", " X ", "#G#", Character.valueOf('#'), PluginCore.items.tubes.get(EnumElectronTube.DIAMOND, 1), Character.valueOf('X'), PluginApiculture.blocks.alveary, Character.valueOf('G'), "ingotGold"});
        RecipeUtil.addRecipe(PluginApiculture.blocks.alveary.get(BlockAlveary.Type.FAN), new Object[]{"I I", " X ", "I#I", Character.valueOf('#'), PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Character.valueOf('X'), PluginApiculture.blocks.alveary, Character.valueOf('I'), "ingotIron"});
        RecipeUtil.addRecipe(PluginApiculture.blocks.alveary.get(BlockAlveary.Type.HEATER), new Object[]{"#I#", " X ", "YYY", Character.valueOf('#'), PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Character.valueOf('X'), PluginApiculture.blocks.alveary, Character.valueOf('I'), "ingotIron", Character.valueOf('Y'), "stone"});
        RecipeUtil.addRecipe(PluginApiculture.blocks.alveary.get(BlockAlveary.Type.HYGRO), new Object[]{"GIG", "GXG", "GIG", Character.valueOf('X'), PluginApiculture.blocks.alveary, Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "blockGlass"});
        RecipeUtil.addRecipe(PluginApiculture.blocks.alveary.get(BlockAlveary.Type.STABILIZER), new Object[]{"G G", "GXG", "G G", Character.valueOf('X'), PluginApiculture.blocks.alveary, Character.valueOf('G'), "gemQuartz"});
        RecipeUtil.addRecipe(PluginApiculture.blocks.alveary.get(BlockAlveary.Type.SIEVE), new Object[]{"III", " X ", "WWW", Character.valueOf('X'), PluginApiculture.blocks.alveary, Character.valueOf('I'), "ingotIron", Character.valueOf('W'), PluginCore.items.craftingMaterial.getWovenSilk()});
        if (PluginManager.Module.FACTORY.isEnabled()) {
            FluidStack honeyDropFluid = Fluids.HONEY.getFluid(100);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{PluginApiculture.items.honeyDrop.getItemStack()}, honeyDropFluid, PluginApiculture.items.propolis.getItemStack(), 5);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{PluginApiculture.items.honeydew.getItemStack()}, honeyDropFluid);
            ItemStack phosphor = PluginCore.items.phosphor.getItemStack(2);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{phosphor, new ItemStack((Block)Blocks.field_150354_m)}, Fluids.LAVA.getFluid(2000));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{phosphor, new ItemStack((Block)Blocks.field_150354_m, 1, 1)}, Fluids.LAVA.getFluid(2000));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{phosphor, new ItemStack(Blocks.field_150346_d)}, Fluids.LAVA.getFluid(1600));
            RecipeManagers.carpenterManager.addRecipe(100, Fluids.WATER.getFluid(2000), null, PluginApiculture.items.beealyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
            RecipeManagers.carpenterManager.addRecipe(50, Fluids.HONEY.getFluid(500), null, PluginCore.items.craftingMaterial.getScentedPaneling(), new Object[]{" J ", "###", "WPW", Character.valueOf('#'), "plankWood", Character.valueOf('J'), PluginApiculture.items.royalJelly, Character.valueOf('W'), PluginCore.items.beeswax, Character.valueOf('P'), PluginApiculture.items.pollenCluster.get(EnumPollenCluster.NORMAL, 1)});
            RecipeManagers.carpenterManager.addRecipe(30, Fluids.WATER.getFluid(600), null, PluginApiculture.blocks.candle.getUnlitCandle(24), new Object[]{" X ", "###", "###", Character.valueOf('#'), PluginCore.items.beeswax, Character.valueOf('X'), Items.field_151007_F});
            RecipeManagers.carpenterManager.addRecipe(10, Fluids.WATER.getFluid(200), null, PluginApiculture.blocks.candle.getUnlitCandle(6), new Object[]{"#X#", Character.valueOf('#'), PluginCore.items.beeswax, Character.valueOf('X'), PluginCore.items.craftingMaterial.getSilkWisp()});
            RecipeUtil.addShapelessRecipe(PluginApiculture.blocks.candle.getUnlitCandle(1), PluginApiculture.blocks.candle.getUnlitCandle(1));
            RecipeUtil.addShapelessRecipe(PluginApiculture.blocks.candle.getLitCandle(1), PluginApiculture.blocks.candle.getLitCandle(1));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.HONEY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.COCOA, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)new ItemStack(Items.field_151100_aR, 1, 3), (Object)Float.valueOf(0.5f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.refractoryWax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginCore.items.phosphor.getItemStack(2), (Object)Float.valueOf(0.7f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.STRINGY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.propolis.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.4f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.DRIPPING, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeydew.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.4f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.FROZEN, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(0.8f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.7f), (Object)new ItemStack(Items.field_151126_ay), (Object)Float.valueOf(0.4f), (Object)PluginApiculture.items.pollenCluster.get(EnumPollenCluster.CRYSTALLINE, 1), (Object)Float.valueOf(0.2f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.SILKY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.propolis.get(EnumPropolis.SILKY, 1), (Object)Float.valueOf(0.8f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.PARCHED, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.MYSTERIOUS, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.propolis.get(EnumPropolis.PULSATING, 1), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.4f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.IRRADIATED, 1), (Map<ItemStack, Float>)ImmutableMap.of());
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.POWDERY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.2f), (Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(0.2f), (Object)new ItemStack(Items.field_151016_H), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.WHEATEN, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.2f), (Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(0.2f), (Object)new ItemStack(Items.field_151015_O), (Object)Float.valueOf(0.8f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.MOSSY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.MELLOW, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeydew.getItemStack(), (Object)Float.valueOf(0.6f), (Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(0.2f), (Object)new ItemStack(Items.field_151128_bU), (Object)Float.valueOf(0.3f)));
            RecipeManagers.centrifugeManager.addRecipe(5, PluginApiculture.items.propolis.get(EnumPropolis.SILKY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.craftingMaterial.getSilkWisp(), (Object)Float.valueOf(0.6f), (Object)PluginApiculture.items.propolis.getItemStack(), (Object)Float.valueOf(0.1f)));
            RecipeManagers.fermenterManager.addRecipe(PluginApiculture.items.honeydew.getItemStack(), 500, 1.0f, Fluids.SHORT_MEAD.getFluid(1), Fluids.HONEY.getFluid(1));
            RecipeManagers.stillManager.addRecipe(100, Fluids.SHORT_MEAD.getFluid(10), Fluids.MEAD.getFluid(5));
        }
        RecipeUtil.addRecipe(PluginCore.blocks.core.get(BlockCoreType.ANALYZER), new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), PluginCore.items.sturdyCasing, Character.valueOf('T'), PluginApiculture.items.beealyzer, Character.valueOf('X'), "ingotBronze"});
        RecipeUtil.addRecipe(PluginApiculture.blocks.apiculture.get(BlockApicultureType.APIARY), new Object[]{"XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), PluginCore.items.impregnatedCasing});
        RecipeUtil.addRecipe(new ItemStack(PluginApiculture.blocks.apicultureChest), " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "beeComb", Character.valueOf('Y'), "chestWood");
        RecipeUtil.addRecipe(PluginApiculture.blocks.apiculture.get(BlockApicultureType.BEEHOUSE), "XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), "beeComb");
    }

    private static void registerBeehiveDrops() {
        ItemStack honeyComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.HONEY, 1);
        hiveRegistry.addDrops("Forestry:forest", new HiveDrop(80, BeeDefinition.FOREST, honeyComb).setIgnobleShare(0.7f), new HiveDrop(8, BeeDefinition.FOREST.getRainResist(), honeyComb), new HiveDrop(3, BeeDefinition.VALIANT, honeyComb));
        hiveRegistry.addDrops("Forestry:meadows", new HiveDrop(80, BeeDefinition.MEADOWS, honeyComb).setIgnobleShare(0.7f), new HiveDrop(3, BeeDefinition.VALIANT, honeyComb));
        ItemStack parchedComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.PARCHED, 1);
        hiveRegistry.addDrops("Forestry:desert", new HiveDrop(80, BeeDefinition.MODEST, parchedComb).setIgnobleShare(0.7f), new HiveDrop(3, BeeDefinition.VALIANT, parchedComb));
        ItemStack silkyComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.SILKY, 1);
        hiveRegistry.addDrops("Forestry:jungle", new HiveDrop(80, BeeDefinition.TROPICAL, silkyComb).setIgnobleShare(0.7f), new HiveDrop(3, BeeDefinition.VALIANT, silkyComb));
        ItemStack mysteriousComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.MYSTERIOUS, 1);
        hiveRegistry.addDrops("Forestry:end", new HiveDrop(90, BeeDefinition.ENDED, mysteriousComb));
        ItemStack frozenComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.FROZEN, 1);
        hiveRegistry.addDrops("Forestry:snow", new HiveDrop(80, BeeDefinition.WINTRY, frozenComb).setIgnobleShare(0.5f), new HiveDrop(3, BeeDefinition.VALIANT, frozenComb));
        ItemStack mossyComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.MOSSY, 1);
        hiveRegistry.addDrops("Forestry:swamp", new HiveDrop(80, BeeDefinition.MARSHY, mossyComb).setIgnobleShare(0.4f), new HiveDrop(3, BeeDefinition.VALIANT, mossyComb));
    }

    private static void registerDungeonLoot() {
        int rarity = Config.dungeonLootRare ? 5 : 10;
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(BeeDefinition.STEADFAST.getMemberStack(EnumBeeType.DRONE), 1, 1, rarity));
        ItemStack stack = PluginApiculture.blocks.candle.getUnlitCandle(1);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("colour", 0xFFFFFF);
        stack.func_77982_d(tag);
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, 7, 12, 12));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginApiculture.items.scoop.getItemStack(), 1, 1, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginApiculture.items.propolis.get(EnumPropolis.NORMAL, 1), 2, 4, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginApiculture.items.beeComb.get(EnumHoneyComb.HONEY, 1), 4, 12, 7));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginApiculture.items.beeComb.get(EnumHoneyComb.FROZEN, 1), 2, 10, 7));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginApiculture.items.beeComb.get(EnumHoneyComb.SILKY, 1), 1, 6, 7));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(BeeDefinition.FOREST.getRainResist().getMemberStack(EnumBeeType.PRINCESS), 1, 1, 5));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(BeeDefinition.COMMON.getMemberStack(EnumBeeType.DRONE), 1, 2, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(BeeDefinition.MEADOWS.getMemberStack(EnumBeeType.PRINCESS), 1, 1, 5));
    }

    private static void createHives() {
        hiveRegistry.registerHive("Forestry:forest", HiveDescription.FOREST);
        hiveRegistry.registerHive("Forestry:meadows", HiveDescription.MEADOWS);
        hiveRegistry.registerHive("Forestry:desert", HiveDescription.DESERT);
        hiveRegistry.registerHive("Forestry:jungle", HiveDescription.JUNGLE);
        hiveRegistry.registerHive("Forestry:end", HiveDescription.END);
        hiveRegistry.registerHive("Forestry:snow", HiveDescription.SNOW);
        hiveRegistry.registerHive("Forestry:swamp", HiveDescription.SWAMP);
    }

    private static void createAlleles() {
        IClassification hymnoptera = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "hymnoptera", "Hymnoptera");
        AlleleManager.alleleRegistry.getClassification("class.insecta").addMemberGroup(hymnoptera);
        IClassification apidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "apidae", "Apidae");
        hymnoptera.addMemberGroup(apidae);
        for (BeeBranchDefinition beeBranch : BeeBranchDefinition.values()) {
            apidae.addMemberGroup(beeBranch.getBranch());
        }
        AlleleEffect.createAlleles();
    }

    public static double getSecondPrincessChance() {
        return secondPrincessChance;
    }

    private static void parseBeeBlacklist(String[] items) {
        for (String item : items) {
            if (item.isEmpty()) continue;
            FMLCommonHandler.instance().getFMLLogger().debug("Blacklisting bee species identified by " + item);
            AlleleManager.alleleRegistry.blacklistAllele(item);
        }
    }

    private static void parseAcceptedFlowers(String[] acceptedFlowers, String flowerType) {
        List<Stack> acceptedFlowerItemStacks = Stack.parseStackStrings(acceptedFlowers, Short.MAX_VALUE);
        for (Stack acceptedFlower : acceptedFlowerItemStacks) {
            Block acceptedFlowerBlock = acceptedFlower.getBlock();
            int meta = acceptedFlower.getMeta();
            if (acceptedFlowerBlock != null) {
                FlowerManager.flowerRegistry.registerAcceptableFlower(acceptedFlowerBlock, meta, flowerType);
                continue;
            }
            Log.warning("No block found for '" + acceptedFlower + "' in apiculture config for '" + flowerType + "'.");
        }
    }

    private static void parsePlantableFlowers(Property property, String flowerType) {
        for (String string : property.getStringList()) {
            Stack plantableFlower = Stack.parseStackString(string, Short.MAX_VALUE);
            if (plantableFlower == null) continue;
            Block plantableFlowerBlock = plantableFlower.getBlock();
            int meta = plantableFlower.getMeta();
            if (plantableFlowerBlock != null) {
                FlowerManager.flowerRegistry.registerPlantableFlower(plantableFlowerBlock, meta, 1.0, flowerType);
                continue;
            }
            Log.warning("No block found for '" + string + "' in config '" + property.getName() + "'.");
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerApiculture();
    }

    @Override
    public void populateChunk(IChunkProvider chunkProvider, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        if (Config.getBeehivesAmount() > 0.0) {
            HiveDecorator.decorateHives(chunkProvider, world, rand, chunkX, chunkZ, hasVillageGenerated);
        }
    }

    @Override
    public void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
        if (Config.getBeehivesAmount() > 0.0) {
            HiveDecorator.decorateHives(world, rand, chunkX, chunkZ);
        }
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-candle-lighting-id")) {
            ItemStack value = message.getItemStackValue();
            if (value != null) {
                BlockCandle.addItemToLightingList(value.func_77973_b());
            } else {
                PluginApiculture.logInvalidIMCMessage(message);
            }
            return true;
        }
        if (message.key.equals("add-alveary-slab") && message.isStringMessage()) {
            String messageString = String.format("Received a '%s' request from mod '%s'. This IMC message has been replaced with the oreDictionary for 'slabWood'. Please contact the author and report this issue.", message.key, message.getSender());
            Log.warning(messageString);
            return true;
        }
        return super.processIMCMessage(message);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            EntityFXSnow.icons = new IIcon[3];
            for (int i = 0; i < EntityFXSnow.icons.length; ++i) {
                EntityFXSnow.icons[i] = event.map.func_94245_a("forestry:particles/snow." + (i + 1));
            }
        }
    }

    static {
        beekeepingMode = "NORMAL";
        secondPrincessChance = 0.0f;
        fancyRenderedBees = false;
    }
}

