/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import thaumicenergistics.common.utils.ThELog;

public abstract class TheContainerBase
extends Container {
    private final HashMap<Integer, Slot> slotMap = new HashMap();
    private final EntityPlayerMP playerMP;
    protected final EntityPlayer player;

    public TheContainerBase(EntityPlayer player) {
        this.player = player;
        this.playerMP = player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null;
    }

    protected Slot func_75146_a(@Nonnull Slot slot) {
        super.func_75146_a(slot);
        if (this.slotMap.put(slot.field_75222_d, slot) != null) {
            ThELog.warning("Duplicate Slot Number Detected: %d", slot.field_75222_d);
        }
        return slot;
    }

    protected boolean detectAndSendChangesMP(@Nonnull EntityPlayerMP playerMP) {
        return false;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.playerMP != null && this.detectAndSendChangesMP(this.playerMP)) {
            this.playerMP.field_71137_h = false;
            super.func_75142_b();
        }
    }

    @Deprecated
    public Slot func_75139_a(int slotNumber) {
        return super.func_75139_a(slotNumber);
    }

    @Nullable
    public Slot getSlotOrNull(int slotNumber) {
        return this.slotMap.getOrDefault(slotNumber, null);
    }

    public void func_75134_a(@Nonnull EntityPlayer player) {
        super.func_75134_a(player);
        this.slotMap.clear();
    }
}

