/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.computers.objects;

import logisticspipes.interfaces.IQueueCCEvent;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;

@CCType(name="CCItemSinkRequest")
public class CCSinkResponder
implements ILPCCTypeHolder {
    private Object ccType;
    private final ItemIdentifierStack stack;
    private final int routerId;
    private boolean done = false;
    private final IQueueCCEvent queuer;
    private int canSink;
    private int priority;

    public CCSinkResponder(ItemIdentifierStack stack, int id, IQueueCCEvent queuer) {
        this.stack = stack;
        this.routerId = id;
        this.queuer = queuer;
    }

    @CCCommand(description="Returns the ItemIdentifier for the item that should be sinked")
    public ItemIdentifier getItemIdentifier() {
        return this.stack.getItem();
    }

    @CCCommand(description="Returns the amount of items that should be sinked")
    public int getAmount() {
        return this.stack.getStackSize();
    }

    @CCCommand(description="Sends the response to the CC QuickSort module to deny the sink")
    public void denySink() {
        this.done = true;
        this.canSink = -1;
    }

    @CCCommand(description="Sends the response to the CC QuickSort module to accept the sink for the givven amount with the givven priority")
    public void acceptSink(Double amount, Double priority) {
        this.canSink = Double.valueOf(amount > 0.0 ? amount : 0.0).intValue();
        this.priority = priority.intValue();
        this.done = true;
    }

    @Override
    public void setCCType(Object type) {
        this.ccType = type;
    }

    @Override
    public Object getCCType() {
        return this.ccType;
    }

    public ItemIdentifierStack getStack() {
        return this.stack;
    }

    public int getRouterId() {
        return this.routerId;
    }

    public boolean isDone() {
        return this.done;
    }

    public IQueueCCEvent getQueuer() {
        return this.queuer;
    }

    public int getCanSink() {
        return this.canSink;
    }

    public int getPriority() {
        return this.priority;
    }
}

