/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.gui;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.gui.GuiScrollableList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreenConfigureChannels
extends GuiScreen
implements GuiScrollableList.IGuiScreen {
    private static final int KEY_MAX_WIDTH = 50;
    private final ItemStack trigger;
    private final GuiChannelsList list;
    private GuiTextField key;
    private GuiTextField value;
    protected int guiTop;
    protected int guiLeft;

    public GuiScreenConfigureChannels(ItemStack trigger) {
        this.trigger = trigger;
        this.list = new GuiChannelsList(152, 100, 12, 12, 14);
        this.list.addSelectionListener((list, selectedIndex) -> {
            Map.Entry e = (Map.Entry)list.getElementAt(selectedIndex);
            this.key.func_146180_a((String)e.getKey());
            this.value.func_146180_a(((Integer)e.getValue()).toString());
            this.updateButtons();
        });
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.guiLeft = (this.field_146294_l - this.getXSize()) / 2;
        this.guiTop = (this.field_146295_m - this.getYSize()) / 2;
        this.key = new GuiTextField(this.field_146289_q, this.guiLeft + 45, this.guiTop + 119, 118, 12){

            public void func_146191_b(String text) {
                super.func_146191_b(text.toLowerCase(Locale.ROOT));
                GuiScreenConfigureChannels.this.updateButtons();
            }

            public void func_146192_a(int p_146192_1_, int p_146192_2_, int p_146192_3_) {
                boolean flag;
                super.func_146192_a(p_146192_1_, p_146192_2_, p_146192_3_);
                boolean bl = flag = p_146192_1_ >= this.field_146209_f && p_146192_1_ < this.field_146209_f + this.field_146218_h && p_146192_2_ >= this.field_146210_g && p_146192_2_ < this.field_146210_g + this.field_146219_i;
                if (flag && p_146192_3_ == 1) {
                    GuiScreenConfigureChannels.this.key.func_146180_a("");
                    GuiScreenConfigureChannels.this.value.func_146180_a("");
                }
            }

            public void func_146180_a(String p_146180_1_) {
                super.func_146180_a(p_146180_1_);
                GuiScreenConfigureChannels.this.updateButtons();
            }
        };
        this.value = new GuiTextField(this.field_146289_q, this.guiLeft + 45, this.guiTop + 139, 118, 12){

            public void func_146191_b(String text) {
                if (text != null && text.codePoints().allMatch(Character::isDigit)) {
                    super.func_146191_b(text);
                    GuiScreenConfigureChannels.this.updateButtons();
                }
            }

            public void func_146195_b(boolean p_146195_1_) {
                if (!p_146195_1_ && this.func_146206_l() && !StringUtils.isBlank((CharSequence)this.func_146179_b())) {
                    int result;
                    try {
                        result = Math.max(Integer.parseInt(this.func_146179_b()), 1);
                    }
                    catch (NumberFormatException e) {
                        result = 1;
                    }
                    this.func_146180_a(String.valueOf(result));
                }
                super.func_146195_b(p_146195_1_);
            }

            public void func_146192_a(int p_146192_1_, int p_146192_2_, int p_146192_3_) {
                boolean flag;
                super.func_146192_a(p_146192_1_, p_146192_2_, p_146192_3_);
                boolean bl = flag = p_146192_1_ >= this.field_146209_f && p_146192_1_ < this.field_146209_f + this.field_146218_h && p_146192_2_ >= this.field_146210_g && p_146192_2_ < this.field_146210_g + this.field_146219_i;
                if (flag && p_146192_3_ == 1) {
                    this.func_146180_a("");
                }
            }

            public void func_146180_a(String p_146180_1_) {
                super.func_146180_a(p_146180_1_);
                GuiScreenConfigureChannels.this.updateButtons();
            }
        };
        this.list.onGuiInit(this);
        this.addButton(new GuiButton(0, this.guiLeft + 12, this.guiTop + 157, 47, 20, I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.add", (Object[])new Object[0])));
        this.addButton(new GuiButton(1, this.guiLeft + 65, this.guiTop + 157, 47, 20, I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.unset", (Object[])new Object[0])));
        this.addButton(new GuiButton(2, this.guiLeft + 118, this.guiTop + 157, 47, 20, I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.wipe", (Object[])new Object[0])));
        this.updateButtons();
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getXSize() {
        return 176;
    }

    @Override
    public int getYSize() {
        return 188;
    }

    @Override
    public void addButton(GuiButton button) {
        this.getButtonList().add(button);
    }

    @Override
    public void removeButton(GuiButton button) {
        this.getButtonList().remove(button);
    }

    @Override
    public int getOverlayOffsetX() {
        return 0;
    }

    @Override
    public void doActionPerformed(GuiButton but) {
        this.func_146284_a(but);
    }

    private List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    public void func_146274_d() {
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            this.list.handleDWheel(delta);
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mX, int mY, int button) {
        this.key.func_146192_a(mX, mY, button);
        this.value.func_146192_a(mX, mY, button);
        super.func_73864_a(mX, mY, button);
    }

    protected void func_73869_a(char aChar, int aKey) {
        switch (aKey) {
            case 15: {
                if (this.key.func_146206_l()) {
                    this.key.func_146195_b(false);
                    this.value.func_146195_b(true);
                } else {
                    this.key.func_146195_b(true);
                    this.value.func_146195_b(false);
                }
                return;
            }
            case 28: 
            case 156: {
                GuiButton add = this.getButtonList().get(0);
                if (add.field_146124_l) {
                    this.doActionPerformed(add);
                }
                return;
            }
            case 200: {
                if (this.list.selectedIndex > 0) {
                    this.list.setSelection(this.list.selectedIndex - 1);
                }
                return;
            }
            case 208: {
                if (this.list.selectedIndex < this.list.getNumElements() - 1) {
                    this.list.setSelection(this.list.selectedIndex + 1);
                }
                return;
            }
        }
        if (this.key.func_146201_a(aChar, aKey)) {
            this.updateButtons();
            return;
        }
        if (this.value.func_146201_a(aChar, aKey)) {
            return;
        }
        super.func_73869_a(aChar, aKey);
    }

    private void updateButtons() {
        String keyText = this.key.func_146179_b();
        boolean existing = !StringUtils.isEmpty((CharSequence)keyText) && ChannelDataAccessor.hasSubChannel(this.trigger, keyText);
        this.getButtonList().get((int)0).field_146126_j = existing ? I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.set", (Object[])new Object[0]) : I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.add", (Object[])new Object[0]);
        this.getButtonList().get((int)0).field_146124_l = !StringUtils.isBlank((CharSequence)this.value.func_146179_b());
        this.getButtonList().get((int)1).field_146124_l = existing && !StringUtils.isBlank((CharSequence)this.value.func_146179_b());
    }

    private int getValue() {
        try {
            return Integer.parseInt(this.value.func_146179_b());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn == null) {
            return;
        }
        switch (btn.field_146127_k) {
            case 0: {
                int value = this.getValue();
                if (value <= 0) {
                    return;
                }
                ChannelDataAccessor.setChannelData(this.trigger, this.key.func_146179_b(), value);
                break;
            }
            case 1: {
                ChannelDataAccessor.unsetChannelData(this.trigger, this.key.func_146179_b());
                break;
            }
            case 2: {
                ChannelDataAccessor.wipeChannelData(this.trigger);
            }
        }
        super.func_146284_a(btn);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
        StructureLib.instance().proxy().uploadChannels(this.trigger);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.key.func_146178_a();
        this.value.func_146178_a();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mX, int mY, float partialTick) {
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("structurelib", "textures/gui/channels.png"));
        int topLeftX = (this.field_146294_l - this.getXSize()) / 2;
        int topLeftY = (this.field_146295_m - this.getYSize()) / 2;
        this.func_73729_b(topLeftX, topLeftY, 0, 0, this.getXSize(), this.getYSize());
        super.func_73863_a(mX, mY, partialTick);
        this.list.drawScreen(mX, mY, partialTick);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.key", (Object[])new Object[0]), this.guiLeft + 12, this.guiTop + 122, 0);
        this.key.func_146194_f();
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.value", (Object[])new Object[0]), this.guiLeft + 12, this.guiTop + 142, 0);
        this.value.func_146194_f();
    }

    private class GuiChannelsList
    extends GuiScrollableList<Map.Entry<String, Integer>> {
        private List<Map.Entry<String, Integer>> cache;

        public GuiChannelsList(int width, int height, int originX, int originY, int slotHeight) {
            super(width, height, originX, originY, slotHeight);
        }

        @Override
        public Map.Entry<String, Integer> getElementAt(int index) {
            return ChannelDataAccessor.iterateChannelData(GuiScreenConfigureChannels.this.trigger).sorted().skip(index).findFirst().orElse(null);
        }

        @Override
        public int getNumElements() {
            return ChannelDataAccessor.countChannelData(GuiScreenConfigureChannels.this.trigger);
        }

        @Override
        protected boolean elementClicked(int elementIndex, boolean doubleClick, int mXRelative, int mYRelative) {
            Object e;
            if (mXRelative >= this.margin + 1 && mXRelative <= this.margin + 5 && mYRelative >= this.margin / 2 + 1 && mYRelative <= this.margin / 2 + 5 && (e = this.getElementAt(elementIndex)) != null) {
                ChannelDataAccessor.unsetChannelData(GuiScreenConfigureChannels.this.trigger, (String)e.getKey());
                return false;
            }
            return super.elementClicked(elementIndex, doubleClick, mXRelative, mYRelative);
        }

        @Override
        protected void prepareDrawElements() {
            this.cache = ChannelDataAccessor.iterateChannelData(GuiScreenConfigureChannels.this.trigger).sorted().collect(Collectors.toList());
        }

        @Override
        protected void drawElement(int elementIndex, int x, int y, int height, Tessellator tessellator, boolean isHovering) {
            if (elementIndex < 0 || elementIndex >= this.cache.size()) {
                return;
            }
            Map.Entry<String, Integer> e = this.cache.get(elementIndex);
            if (e == null) {
                return;
            }
            if (elementIndex > 0) {
                GuiScreenConfigureChannels.this.func_73730_a(this.minX + 1, this.maxX - 1, y - 2, -5592406);
            }
            int keyMaxWidth = 100;
            if (isHovering) {
                GuiScreenConfigureChannels.this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("structurelib", "textures/gui/channels.png"));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiScreenConfigureChannels.this.func_73729_b(x + this.margin + 1, y + this.margin / 2 + 1, 251, 251, 5, 5);
            }
            GuiScreenConfigureChannels.this.field_146289_q.func_78276_b(this.trim(e.getKey(), keyMaxWidth - 9), x + this.margin + 8, y + this.margin / 2, 0xFFFFFF);
            int valueX = x + this.margin + keyMaxWidth + this.margin;
            GuiScreenConfigureChannels.this.field_146289_q.func_78276_b(this.trim(e.getValue().toString(), this.maxX - valueX), valueX, y + this.margin / 2, 0xFFFFFF);
        }

        @Override
        public void drawScreen(int mX, int mY, float partialTick) {
            super.drawScreen(mX, mY, partialTick);
            GuiScreenConfigureChannels.this.func_73728_b(this.minX + this.margin + this.margin / 2 + 100, this.minY + 1, this.maxY - 1, -5592406);
        }

        public String trim(String e, int keyMaxWidth) {
            String s = GuiScreenConfigureChannels.this.field_146289_q.func_78269_a(e, keyMaxWidth);
            if (s.length() != e.length()) {
                StringBuilder buffer = new StringBuilder(s).deleteCharAt(s.length() - 1).append("...");
                while ((s = GuiScreenConfigureChannels.this.field_146289_q.func_78269_a(buffer.toString(), keyMaxWidth)).length() != buffer.length()) {
                    buffer.deleteCharAt(s.length() - 4);
                }
                do {
                    buffer.append('.');
                } while (GuiScreenConfigureChannels.this.field_146289_q.func_78256_a(buffer.toString()) <= keyMaxWidth);
                s = buffer.deleteCharAt(s.length() - 1).insert(s.length() - 3, EnumChatFormatting.GRAY).toString();
            }
            return s;
        }
    }
}

