/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.internal.wrapper;

import javax.annotation.Nullable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class FluidTankHandler
implements IFluidHandler {
    private final IFluidTank fluidTank;

    public static IFluidHandler getTankFluidHandler(IFluidTank tank) {
        if (tank instanceof IFluidHandler) {
            return (IFluidHandler)tank;
        }
        return new FluidTankHandler(tank);
    }

    public FluidTankHandler(IFluidTank tank) {
        this.fluidTank = tank;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (currentFluid == null || currentFluid.amount <= 0 || !currentFluid.isFluidEqual(resource)) {
            return null;
        }
        return this.fluidTank.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }
}

