/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.draw;

import com.github.dcysteine.neicustomdiagram.api.draw.AutoValue_Point;
import com.github.dcysteine.neicustomdiagram.api.draw.Vector;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class Point {
    public static Point create(int x, int y) {
        return new AutoValue_Point(x, y);
    }

    public abstract int x();

    public abstract int y();

    public static Point projectX(Point a, Point b) {
        return Point.create(a.x(), b.y());
    }

    public static Point projectY(Point a, Point b) {
        return Point.create(b.x(), a.y());
    }

    public Point translate(int dx, int dy) {
        return Point.create(this.x() + dx, this.y() + dy);
    }

    public Point translate(Vector other) {
        return Point.create(this.x() + other.x(), this.y() + other.y());
    }

    public Vector difference(Point other) {
        return Vector.create(this.x() - other.x(), this.y() - other.y());
    }

    public boolean isOrthogonal(Point pos) {
        return this.x() == pos.x() || this.y() == pos.y();
    }
}

