/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.eventbus;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.eventbus.MethodInfo;
import com.gtnewhorizon.gtnhlib.eventbus.Phase;
import com.gtnewhorizon.gtnhlib.mixins.early.fml.EnumHolderAccessor;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class EventBusUtil {
    public static final Boolean DEBUG_EVENT_BUS = Boolean.getBoolean("gtnhlib.debug.eventbus");
    private static final String CURRENT_SIDE = FMLLaunchHandler.side().name();
    private static final ObjectSet<String> classesToVisit = new ObjectOpenHashSet<String>();
    private static final Object2ObjectMap<String, ObjectSet<MethodInfo>> methodsToSubscribe = new Object2ObjectOpenHashMap<String, ObjectSet<MethodInfo>>();
    private static final Object2ObjectMap<String, String> conditionsToCheck = new Object2ObjectOpenHashMap<String, String>();
    private static final ObjectList<String> invalidMethods = new ObjectArrayList<String>();

    static String getParameterClassInternal(String desc) {
        return desc.substring(desc.indexOf("(") + 2, desc.indexOf(";"));
    }

    static String getParameterClassName(String desc) {
        return EventBusUtil.getParameterClassInternal(desc).replace("/", ".");
    }

    static String getSimpleClassName(String desc) {
        return desc.substring(desc.lastIndexOf(".") + 1);
    }

    public static void harvestData(ASMDataTable table) {
        Set asmData = table.getAll(EventBusSubscriber.class.getName());
        ObjectSet<String> excludedClasses = EventBusUtil.getExcludedClasses(table);
        for (ASMDataTable.ASMData data : asmData) {
            Map info = data.getAnnotationInfo();
            String className = data.getClassName();
            Phase phase = Phase.INIT;
            if (info != null) {
                String side;
                if (info.containsKey("phase")) {
                    phase = Phase.valueOf(((EnumHolderAccessor)info.get("phase")).getValue());
                }
                if (info.containsKey(null) && !EventBusUtil.isValidSide(side = ((EnumHolderAccessor)info.get(null)).getValue(), className)) continue;
            }
            ModContainer mod = (ModContainer)data.getCandidate().getContainedMods().get(0);
            if (excludedClasses.contains(className)) continue;
            phase.getModClassesForPhase().computeIfAbsent(mod, k -> new ObjectOpenHashSet()).add(className);
            classesToVisit.add(className);
        }
    }

    private static ObjectSet<String> getExcludedClasses(ASMDataTable dataTable) {
        Set dat = dataTable.getAll(SideOnly.class.getName());
        ObjectOpenHashSet<String> excludedClasses = new ObjectOpenHashSet<String>();
        for (ASMDataTable.ASMData data : dat) {
            Map sideInfo;
            String side;
            String className = data.getClassName();
            if (!data.getObjectName().equals(className) || CURRENT_SIDE.equals(side = ((EnumHolderAccessor)(sideInfo = data.getAnnotationInfo()).get("value")).getValue())) continue;
            excludedClasses.add(className);
        }
        return excludedClasses;
    }

    private static boolean isValidSide(String side, String className) {
        if (CURRENT_SIDE.equals("CLIENT")) {
            return side.equals(CURRENT_SIDE);
        }
        return !StringUtils.containsIgnoreCase((CharSequence)className, (CharSequence)"client") && !side.equals("CLIENT");
    }

    public static ObjectSet<String> getClassesToVisit() {
        return classesToVisit;
    }

    public static Object2ObjectMap<String, ObjectSet<MethodInfo>> getMethodsToSubscribe() {
        return methodsToSubscribe;
    }

    public static Object2ObjectMap<String, String> getConditionsToCheck() {
        return conditionsToCheck;
    }

    public static ObjectList<String> getInvalidMethods() {
        return invalidMethods;
    }
}

