/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.mantle;

import com.dreammaster.mantle.BookDataReader;
import com.dreammaster.mantle.BookDataStoreProxy;
import com.dreammaster.mantle.BookLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import gregtech.GTMod;
import gregtech.api.interfaces.internal.IGTMod;
import java.util.Objects;
import java.util.stream.Stream;
import mantle.books.BookData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

final class MantleBookLoader
implements BookLoader {
    private static final BookDataReader BOOK_DATA_READER = new BookDataReader();
    private static final BookDataStoreProxy BOOK_DATA_STORE_PROXY = BookDataStoreProxy.getInstance();
    private final BookDataStoreProxy bookDataStoreProxy;
    private final BookData data;
    private final IGTMod sideChecker;
    private final BookDataReader bookDataReader;

    static BookLoader readBook(String unlocalizedName, String modId, String xmlDocumentPath) {
        return new MantleBookLoader(BOOK_DATA_STORE_PROXY, BOOK_DATA_READER, (IGTMod)GTMod.gregtechproxy).setRequiredData(unlocalizedName, modId, xmlDocumentPath);
    }

    @VisibleForTesting
    MantleBookLoader(BookDataStoreProxy bookDataStoreProxy, BookDataReader bookDataReader, IGTMod sideChecker) {
        Stream.of(bookDataStoreProxy, bookDataReader, sideChecker).forEach(Objects::requireNonNull);
        this.bookDataStoreProxy = bookDataStoreProxy;
        this.bookDataReader = bookDataReader;
        this.sideChecker = sideChecker;
        this.data = new BookData();
    }

    @VisibleForTesting
    BookLoader setRequiredData(String unlocalizedName, String modId, String xmlDocumentPath) {
        Objects.requireNonNull(unlocalizedName);
        Objects.requireNonNull(modId);
        Objects.requireNonNull(xmlDocumentPath);
        this.data.unlocalizedName = unlocalizedName;
        this.data.modID = modId;
        if (this.sideChecker.isClientSide()) {
            this.data.doc = this.bookDataReader.readBook(xmlDocumentPath);
        }
        return this;
    }

    @Override
    public BookLoader setTooltip(String tooltip) {
        Objects.requireNonNull(tooltip);
        this.data.toolTip = "\u00a7o" + StatCollector.func_74838_a((String)tooltip);
        return this;
    }

    @Override
    public BookLoader setItemImage(String itemImage) {
        Objects.requireNonNull(itemImage);
        this.data.itemImage = new ResourceLocation(this.data.modID, itemImage);
        return this;
    }

    @Override
    public BookLoader makeTranslatable() {
        this.data.isTranslatable = true;
        return this;
    }

    @Override
    public void addToBookDataStore() {
        if (Strings.isNullOrEmpty((String)this.data.unlocalizedName)) {
            throw new IllegalStateException("You must call setRequiredData before addToBookDataStore.");
        }
        this.bookDataStoreProxy.addBook(this.data);
    }
}

