/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class RayTracing {
    private static RayTracing _instance;
    private MovingObjectPosition target = null;
    private final Minecraft mc = Minecraft.func_71410_x();

    private RayTracing() {
    }

    public static RayTracing instance() {
        if (_instance == null) {
            _instance = new RayTracing();
        }
        return _instance;
    }

    public void fire() {
        if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && !RayTracing.shouldHidePlayer(this.mc.field_71476_x.field_72308_g)) {
            this.target = this.mc.field_71476_x;
            return;
        }
        EntityLivingBase viewpoint = this.mc.field_71451_h;
        if (viewpoint == null) {
            return;
        }
        this.target = this.rayTrace(viewpoint, this.mc.field_71442_b.func_78757_d(), 0.0f);
    }

    private static boolean shouldHidePlayer(Entity targetEnt) {
        if (targetEnt instanceof EntityPlayer) {
            EntityPlayer thePlayer = (EntityPlayer)targetEnt;
            boolean shouldHidePlayerSetting = !ConfigHandler.instance().getConfig("vanilla.show_invisible_players");
            return shouldHidePlayerSetting && thePlayer.func_82150_aj();
        }
        return false;
    }

    public MovingObjectPosition getTarget() {
        return this.target;
    }

    public ItemStack getTargetStack() {
        return this.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK ? this.getIdentifierStack() : null;
    }

    public Entity getTargetEntity() {
        return this.target.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY ? this.getIdentifierEntity() : null;
    }

    public MovingObjectPosition rayTrace(EntityLivingBase entity, double par1, float par3) {
        Vec3 vec3 = entity.func_70666_h(par3);
        Vec3 vec31 = entity.func_70676_i(par3);
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * par1, vec31.field_72448_b * par1, vec31.field_72449_c * par1);
        if (ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_LIQUID, true)) {
            return entity.field_70170_p.func_72901_a(vec3, vec32, true);
        }
        return entity.field_70170_p.func_72901_a(vec3, vec32, false);
    }

    public ItemStack getIdentifierStack() {
        ArrayList<ItemStack> items = this.getIdentifierItems();
        if (items.isEmpty()) {
            return null;
        }
        items.sort((stack0, stack1) -> stack1.func_77960_j() - stack0.func_77960_j());
        return items.get(0);
    }

    public Entity getIdentifierEntity() {
        ArrayList<Entity> ents = new ArrayList<Entity>();
        if (this.target == null) {
            return null;
        }
        if (ModuleRegistrar.instance().hasOverrideEntityProviders(this.target.field_72308_g)) {
            for (List<IWailaEntityProvider> listProviders : ModuleRegistrar.instance().getOverrideEntityProviders(this.target.field_72308_g).values()) {
                for (IWailaEntityProvider provider : listProviders) {
                    ents.add(provider.getWailaOverride(DataAccessorCommon.instance, ConfigHandler.instance()));
                }
            }
        }
        if (!ents.isEmpty()) {
            return (Entity)ents.get(0);
        }
        return this.target.field_72308_g;
    }

    public ArrayList<ItemStack> getIdentifierItems() {
        IShearable shearable;
        ItemStack providerStack;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.target == null) {
            return items;
        }
        WorldClient world = this.mc.field_71441_e;
        int x = this.target.field_72311_b;
        int y = this.target.field_72312_c;
        int z = this.target.field_72309_d;
        Block mouseoverBlock = world.func_147439_a(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (mouseoverBlock == null) {
            return items;
        }
        if (ModuleRegistrar.instance().hasStackProviders(mouseoverBlock)) {
            for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getStackProviders(mouseoverBlock).values()) {
                for (IWailaDataProvider provider : providersList) {
                    providerStack = provider.getWailaStack(DataAccessorCommon.instance, ConfigHandler.instance());
                    if (providerStack == null) continue;
                    if (providerStack.func_77973_b() == null) {
                        return new ArrayList<ItemStack>();
                    }
                    items.add(providerStack);
                }
            }
        }
        if (tileEntity != null && ModuleRegistrar.instance().hasStackProviders(tileEntity)) {
            for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getStackProviders(tileEntity).values()) {
                for (IWailaDataProvider provider : providersList) {
                    providerStack = provider.getWailaStack(DataAccessorCommon.instance, ConfigHandler.instance());
                    if (providerStack == null) continue;
                    if (providerStack.func_77973_b() == null) {
                        return new ArrayList<ItemStack>();
                    }
                    items.add(providerStack);
                }
            }
        }
        if (!items.isEmpty()) {
            return items;
        }
        if (world.func_147438_o(x, y, z) == null) {
            try {
                ItemStack block = new ItemStack(mouseoverBlock, 1, world.func_72805_g(x, y, z));
                if (block.func_77973_b() != null) {
                    items.add(block);
                }
            }
            catch (Exception block) {
                // empty catch block
            }
        }
        if (!items.isEmpty()) {
            return items;
        }
        try {
            ItemStack pick = mouseoverBlock.getPickBlock(this.target, (World)world, x, y, z);
            if (pick != null) {
                items.add(pick);
            }
        }
        catch (Exception pick) {
            // empty catch block
        }
        if (!items.isEmpty()) {
            return items;
        }
        if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, x, y, z)) {
            items.addAll(shearable.onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, x, y, z, 0));
        }
        if (items.isEmpty()) {
            items.add(0, new ItemStack(mouseoverBlock, 1, world.func_72805_g(x, y, z)));
        }
        return items;
    }
}

