/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S1BPacketEntityAttach;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CartUtils {
    public static Map<Item, ICartType> vanillaCartItemMap = new HashMap<Item, ICartType>();
    public static Map<Class<? extends EntityMinecart>, ICartType> classReplacements = new HashMap<Class<? extends EntityMinecart>, ICartType>();

    public static EntityMinecart placeCart(GameProfile owner, ItemStack cart, WorldServer world, int x, int y, int z) {
        if (cart == null) {
            return null;
        }
        ICartType vanillaType = vanillaCartItemMap.get((cart = cart.func_77946_l()).func_77973_b());
        if (vanillaType != null) {
            return CartUtils.placeCart(vanillaType, owner, cart, (World)world, x, y, z);
        }
        return CartTools.placeCart(owner, cart, world, x, y, z);
    }

    public static EntityMinecart placeCart(ICartType cartType, GameProfile owner, ItemStack cartStack, World world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j, k);
        if (TrackTools.isRailBlock(block) && !CartTools.isMinecartAt(world, i, j, k, 0.0f)) {
            EntityMinecart cart = cartType.makeCart(cartStack, world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
            if (cartStack.func_82837_s()) {
                cart.func_96094_a(cartStack.func_82833_r());
            }
            CartTools.setCartOwner(cart, owner);
            if (world.func_72838_d((Entity)cart)) {
                return cart;
            }
        }
        return null;
    }

    public static boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        if (stack == null) {
            return false;
        }
        if (cart instanceof IMinecart) {
            if (stack.func_82837_s()) {
                return ((IMinecart)cart).doesCartMatchFilter(stack, cart) && stack.func_82833_r().equals(cart.getCartItem().func_82833_r());
            }
            return ((IMinecart)cart).doesCartMatchFilter(stack, cart);
        }
        ItemStack cartItem = cart.getCartItem();
        return cartItem != null && InvTools.isCartItemEqual(stack, cartItem, true);
    }

    public static void explodeCart(EntityMinecart cart) {
        if (cart.field_70128_L) {
            return;
        }
        cart.getEntityData().func_74757_a("HighSpeed", false);
        cart.field_70159_w = 0.0;
        cart.field_70179_y = 0.0;
        if (Game.isNotHost(cart.field_70170_p)) {
            return;
        }
        if (cart.field_70153_n != null) {
            cart.field_70153_n.func_70078_a((Entity)cart);
        }
        cart.field_70170_p.func_72885_a((Entity)cart, cart.field_70165_t, cart.field_70163_u, cart.field_70161_v, 3.0f, true, true);
        if (MiscTools.getRand().nextInt(2) == 0) {
            cart.func_70106_y();
        }
    }

    public static boolean cartVelocityIsLessThan(EntityMinecart cart, float vel) {
        return Math.abs(cart.field_70159_w) < (double)vel && Math.abs(cart.field_70179_y) < (double)vel;
    }

    public static List<EntityMinecart> getMinecartsIn(World world, AxisAlignedBB searchBox) {
        List entities = world.func_72872_a(EntityMinecart.class, searchBox);
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (Object o : entities) {
            EntityMinecart cart = (EntityMinecart)o;
            if (cart.field_70128_L) continue;
            carts.add((EntityMinecart)o);
        }
        return carts;
    }

    public static List<UUID> getMinecartUUIDsAt(World world, int i, int j, int k, float sensitivity) {
        sensitivity = Math.min(sensitivity, 0.49f);
        List entities = world.func_72872_a(EntityMinecart.class, AxisAlignedBB.func_72330_a((double)((float)i + sensitivity), (double)((float)j + sensitivity), (double)((float)k + sensitivity), (double)((float)(i + 1) - sensitivity), (double)((float)(j + 1) - sensitivity), (double)((float)(k + 1) - sensitivity)));
        ArrayList<UUID> carts = new ArrayList<UUID>();
        for (Object o : entities) {
            EntityMinecart cart = (EntityMinecart)o;
            if (cart.field_70128_L) continue;
            carts.add(((EntityMinecart)o).getPersistentID());
        }
        return carts;
    }

    public static void dismount(EntityMinecart cart, double x, double y, double z) {
        if (cart.field_70153_n == null) {
            return;
        }
        Entity rider = cart.field_70153_n;
        rider.field_70154_o = null;
        cart.field_70153_n = null;
        if (rider instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)rider;
            player.field_71135_a.func_147359_a((Packet)new S1BPacketEntityAttach(0, rider, null));
            player.func_70634_a(x, y, z);
        } else {
            rider.func_70012_b(x, y, z, rider.field_70177_z, rider.field_70125_A);
        }
    }
}

