/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.widget.IGuiAction;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.value.sync.InteractionSyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.SingleChildWidget;
import org.jetbrains.annotations.NotNull;

public class ButtonWidget<W extends ButtonWidget<W>>
extends SingleChildWidget<W>
implements Interactable {
    private boolean playClickSound = true;
    private IGuiAction.MousePressed mousePressed;
    private IGuiAction.MouseReleased mouseReleased;
    private IGuiAction.MousePressed mouseTapped;
    private IGuiAction.MouseScroll mouseScroll;
    private IGuiAction.KeyPressed keyPressed;
    private IGuiAction.KeyReleased keyReleased;
    private IGuiAction.KeyPressed keyTapped;
    private InteractionSyncHandler syncHandler;

    public static ButtonWidget<?> panelCloseButton() {
        ButtonWidget buttonWidget = new ButtonWidget();
        return ((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)buttonWidget.overlay(GuiTextures.CROSS_TINY)).size(10)).top(4)).right(4)).onMousePressed(mouseButton -> {
            if (mouseButton == 0 || mouseButton == 1) {
                buttonWidget.getPanel().closeIfOpen(true);
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        this.syncHandler = this.castIfTypeElseNull(syncHandler, InteractionSyncHandler.class);
        return this.syncHandler != null;
    }

    @Override
    public WidgetTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getButtonTheme();
    }

    public void playClickSound() {
        if (this.playClickSound) {
            Interactable.playButtonClickSound();
        }
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (this.mousePressed != null && this.mousePressed.press(mouseButton)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        if (this.syncHandler != null && this.syncHandler.onMousePressed(mouseButton)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onMouseRelease(int mouseButton) {
        return this.mouseReleased != null && this.mouseReleased.release(mouseButton) || this.syncHandler != null && this.syncHandler.onMouseReleased(mouseButton);
    }

    @Override
    @NotNull
    public Interactable.Result onMouseTapped(int mouseButton) {
        if (this.mouseTapped != null && this.mouseTapped.press(mouseButton)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        if (this.syncHandler != null && this.syncHandler.onMouseTapped(mouseButton)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(char typedChar, int keyCode) {
        if (this.keyPressed != null && this.keyPressed.press(typedChar, keyCode)) {
            return Interactable.Result.SUCCESS;
        }
        if (this.syncHandler != null && this.syncHandler.onKeyPressed(typedChar, keyCode)) {
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onKeyRelease(char typedChar, int keyCode) {
        return this.keyReleased != null && this.keyReleased.release(typedChar, keyCode) || this.syncHandler != null && this.syncHandler.onKeyReleased(typedChar, keyCode);
    }

    @Override
    @NotNull
    public Interactable.Result onKeyTapped(char typedChar, int keyCode) {
        if (this.keyTapped != null && this.keyTapped.press(typedChar, keyCode)) {
            return Interactable.Result.SUCCESS;
        }
        if (this.syncHandler != null && this.syncHandler.onKeyTapped(typedChar, keyCode)) {
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        return this.mouseScroll != null && this.mouseScroll.scroll(scrollDirection, amount) || this.syncHandler != null && this.syncHandler.onMouseScroll((int)Math.copySign(amount, scrollDirection.modifier));
    }

    public W onMousePressed(IGuiAction.MousePressed mousePressed) {
        this.mousePressed = mousePressed;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onMouseReleased(IGuiAction.MouseReleased mouseReleased) {
        this.mouseReleased = mouseReleased;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onMouseTapped(IGuiAction.MousePressed mouseTapped) {
        this.mouseTapped = mouseTapped;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onMouseScrolled(IGuiAction.MouseScroll mouseScroll) {
        this.mouseScroll = mouseScroll;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onKeyPressed(IGuiAction.KeyPressed keyPressed) {
        this.keyPressed = keyPressed;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onKeyReleased(IGuiAction.KeyReleased keyReleased) {
        this.keyReleased = keyReleased;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onKeyTapped(IGuiAction.KeyPressed keyTapped) {
        this.keyTapped = keyTapped;
        return (W)((ButtonWidget)this.getThis());
    }

    public W syncHandler(InteractionSyncHandler interactionSyncHandler) {
        this.syncHandler = interactionSyncHandler;
        this.setSyncHandler(interactionSyncHandler);
        return (W)((ButtonWidget)this.getThis());
    }

    public W playClickSound(boolean play) {
        this.playClickSound = play;
        return (W)((ButtonWidget)this.getThis());
    }
}

