/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.text;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.FontRenderHelper;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public abstract class BaseKey
implements IKey {
    private EnumChatFormatting[] formatting;

    @Override
    public String getFormatted() {
        if (this.formatting == null) {
            return this.get();
        }
        if (FontRenderHelper.isReset(this.formatting)) {
            return EnumChatFormatting.RESET + this.get();
        }
        return FontRenderHelper.getFormatting(this.formatting, new StringBuilder()).append(this.get()).append(EnumChatFormatting.RESET).toString();
    }

    @Override
    public BaseKey format(EnumChatFormatting formatting) {
        if (this.formatting == null) {
            this.formatting = FontRenderHelper.createFormattingState();
        }
        FontRenderHelper.addAfter(this.formatting, formatting);
        return this;
    }

    @Nullable
    public EnumChatFormatting[] getFormatting() {
        return this.formatting;
    }

    public String toString() {
        return this.getFormatted();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IKey)) {
            return false;
        }
        IKey key = (IKey)obj;
        return this.getFormatted().equals(key.getFormatted());
    }

    public int hashCode() {
        throw new NotImplementedException("Implement hashCode() in subclasses");
    }
}

