/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.drawable.BufferBuilder;
import com.cleanroommc.modularui.mixins.early.minecraft.GuiScreenAccessor;
import com.cleanroommc.modularui.utils.Color;
import com.mitchej123.hodgepodge.textures.IPatchedTextureAtlasSprite;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiDraw {
    public static final double PI2 = Math.PI * 2;
    public static final double PI_2 = 1.5707963267948966;

    public static void drawRect(float x0, float y0, float w, float h, int color) {
        GuiDraw.drawRect(x0, y0, w, h, color, color, color, color);
    }

    public static void drawHorizontalGradientRect(float x0, float y0, float w, float h, int colorLeft, int colorRight) {
        GuiDraw.drawRect(x0, y0, w, h, colorLeft, colorRight, colorLeft, colorRight);
    }

    public static void drawVerticalGradientRect(float x0, float y0, float w, float h, int colorTop, int colorBottom) {
        GuiDraw.drawRect(x0, y0, w, h, colorTop, colorTop, colorBottom, colorBottom);
    }

    public static void drawRect(float x0, float y0, float w, float h, int colorTL, int colorTR, int colorBL, int colorBR) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        float x1 = x0 + w;
        float y1 = y0 + h;
        Tessellator.field_78398_a.func_78382_b();
        BufferBuilder.bufferbuilder.pos(x0, y0, 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
        BufferBuilder.bufferbuilder.pos(x0, y1, 0.0).color(Color.getRed(colorBL), Color.getGreen(colorBL), Color.getBlue(colorBL), Color.getAlpha(colorBL)).endVertex();
        BufferBuilder.bufferbuilder.pos(x1, y1, 0.0).color(Color.getRed(colorBR), Color.getGreen(colorBR), Color.getBlue(colorBR), Color.getAlpha(colorBR)).endVertex();
        BufferBuilder.bufferbuilder.pos(x1, y0, 0.0).color(Color.getRed(colorTR), Color.getGreen(colorTR), Color.getBlue(colorTR), Color.getAlpha(colorTR)).endVertex();
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawCircle(float x0, float y0, float diameter, int color, int segments) {
        GuiDraw.drawEllipse(x0, y0, diameter, diameter, color, color, segments);
    }

    public static void drawCircle(float x0, float y0, float diameter, int centerColor, int outerColor, int segments) {
        GuiDraw.drawEllipse(x0, y0, diameter, diameter, centerColor, outerColor, segments);
    }

    public static void drawEllipse(float x0, float y0, float w, float h, int color, int segments) {
        GuiDraw.drawEllipse(x0, y0, w, h, color, color, segments);
    }

    public static void drawEllipse(float x0, float y0, float w, float h, int centerColor, int outerColor, int segments) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        float x_2 = x0 + w / 2.0f;
        float y_2 = y0 + h / 2.0f;
        Tessellator.field_78398_a.func_78382_b();
        BufferBuilder.bufferbuilder.pos(x_2, y_2, 0.0).color(Color.getRed(centerColor), Color.getGreen(centerColor), Color.getBlue(centerColor), Color.getAlpha(centerColor)).endVertex();
        int a = Color.getAlpha(outerColor);
        int r = Color.getRed(outerColor);
        int g = Color.getGreen(outerColor);
        int b = Color.getBlue(outerColor);
        float incr = (float)(Math.PI * 2 / (double)segments);
        for (int i = 0; i <= segments; ++i) {
            float angle = incr * (float)i;
            float x = (float)(Math.sin(angle) * (double)(w / 2.0f) + (double)x_2);
            float y = (float)(Math.cos(angle) * (double)(h / 2.0f) + (double)y_2);
            BufferBuilder.bufferbuilder.pos(x, y, 0.0).color(r, g, b, a).endVertex();
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawRoundedRect(float x0, float y0, float w, float h, int color, int cornerRadius, int segments) {
        GuiDraw.drawRoundedRect(x0, y0, w, h, color, color, color, color, cornerRadius, segments);
    }

    public static void drawVerticalGradientRoundedRect(float x0, float y0, float w, float h, int colorTop, int colorBottom, int cornerRadius, int segments) {
        GuiDraw.drawRoundedRect(x0, y0, w, h, colorTop, colorTop, colorBottom, colorBottom, cornerRadius, segments);
    }

    public static void drawHorizontalGradientRoundedRect(float x0, float y0, float w, float h, int colorLeft, int colorRight, int cornerRadius, int segments) {
        GuiDraw.drawRoundedRect(x0, y0, w, h, colorLeft, colorRight, colorLeft, colorRight, cornerRadius, segments);
    }

    public static void drawRoundedRect(float x0, float y0, float w, float h, int colorTL, int colorTR, int colorBL, int colorBR, int cornerRadius, int segments) {
        float y;
        float x;
        int i;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        float x1 = x0 + w;
        float y1 = y0 + h;
        Tessellator.field_78398_a.func_78382_b();
        int color = Color.average(colorBL, colorBR, colorTR, colorTL);
        BufferBuilder.bufferbuilder.pos(x0 + w / 2.0f, y0 + h / 2.0f, 0.0).color(Color.getRed(color), Color.getGreen(color), Color.getBlue(color), Color.getAlpha(color)).endVertex();
        BufferBuilder.bufferbuilder.pos(x0, y0 + (float)cornerRadius, 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
        BufferBuilder.bufferbuilder.pos(x0, y1 - (float)cornerRadius, 0.0).color(Color.getRed(colorBL), Color.getGreen(colorBL), Color.getBlue(colorBL), Color.getAlpha(colorBL)).endVertex();
        for (i = 1; i <= segments; ++i) {
            x = (float)((double)(x0 + (float)cornerRadius) - Math.cos(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
            y = (float)((double)(y1 - (float)cornerRadius) + Math.sin(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
            BufferBuilder.bufferbuilder.pos(x, y, 0.0).color(Color.getRed(colorBL), Color.getGreen(colorBL), Color.getBlue(colorBL), Color.getAlpha(colorBL)).endVertex();
        }
        BufferBuilder.bufferbuilder.pos(x1 - (float)cornerRadius, y1, 0.0).color(Color.getRed(colorBR), Color.getGreen(colorBR), Color.getBlue(colorBR), Color.getAlpha(colorBR)).endVertex();
        for (i = 1; i <= segments; ++i) {
            x = (float)((double)(x1 - (float)cornerRadius) + Math.sin(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
            y = (float)((double)(y1 - (float)cornerRadius) + Math.cos(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
            BufferBuilder.bufferbuilder.pos(x, y, 0.0).color(Color.getRed(colorBR), Color.getGreen(colorBR), Color.getBlue(colorBR), Color.getAlpha(colorBR)).endVertex();
        }
        BufferBuilder.bufferbuilder.pos(x1, y0 + (float)cornerRadius, 0.0).color(Color.getRed(colorTR), Color.getGreen(colorTR), Color.getBlue(colorTR), Color.getAlpha(colorTR)).endVertex();
        for (i = 1; i <= segments; ++i) {
            x = (float)((double)(x1 - (float)cornerRadius) + Math.cos(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
            y = (float)((double)(y0 + (float)cornerRadius) - Math.sin(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
            BufferBuilder.bufferbuilder.pos(x, y, 0.0).color(Color.getRed(colorTR), Color.getGreen(colorTR), Color.getBlue(colorTR), Color.getAlpha(colorTR)).endVertex();
        }
        BufferBuilder.bufferbuilder.pos(x0 + (float)cornerRadius, y0, 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
        for (i = 1; i <= segments; ++i) {
            x = (float)((double)(x0 + (float)cornerRadius) - Math.sin(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
            y = (float)((double)(y0 + (float)cornerRadius) - Math.cos(1.5707963267948966 / (double)segments * (double)i) * (double)cornerRadius);
            BufferBuilder.bufferbuilder.pos(x, y, 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
        }
        BufferBuilder.bufferbuilder.pos(x0, y0 + (float)cornerRadius, 0.0).color(Color.getRed(colorTL), Color.getGreen(colorTL), Color.getBlue(colorTL), Color.getAlpha(colorTL)).endVertex();
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawTexture(ResourceLocation location, float x, float y, float w, float h, int u, int v, int textureWidth, int textureHeight) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
        GuiDraw.drawTexture(x, y, u, v, w, h, textureWidth, textureHeight);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    public static void drawTexture(float x, float y, int u, int v, float w, float h, int textureW, int textureH) {
        GuiDraw.drawTexture(x, y, u, v, w, h, textureW, textureH, 0.0f);
    }

    public static void drawTexture(float x, float y, int u, int v, float w, float h, int textureW, int textureH, float z) {
        Tessellator.field_78398_a.func_78382_b();
        GuiDraw.drawTexture(BufferBuilder.buffer, x, y, u, v, w, h, textureW, textureH, z);
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void drawTexture(BufferBuilder buffer, float x, float y, int u, int v, float w, float h, int textureW, int textureH, float z) {
        float tw = 1.0f / (float)textureW;
        float th = 1.0f / (float)textureH;
        buffer.pos(x, y + h, z).tex((float)u * tw, ((float)v + h) * th).endVertex();
        buffer.pos(x + w, y + h, z).tex(((float)u + w) * tw, ((float)v + h) * th).endVertex();
        buffer.pos(x + w, y, z).tex(((float)u + w) * tw, (float)v * th).endVertex();
        buffer.pos(x, y, z).tex((float)u * tw, (float)v * th).endVertex();
    }

    public static void drawTexture(float x, float y, int u, int v, float w, float h, int textureW, int textureH, int tu, int tv) {
        GuiDraw.drawTexture(x, y, u, v, w, h, textureW, textureH, tu, tv, 0.0f);
    }

    public static void drawTexture(float x, float y, int u, int v, float w, float h, int textureW, int textureH, int tu, int tv, float z) {
        Tessellator.field_78398_a.func_78382_b();
        GuiDraw.drawTexture(BufferBuilder.buffer, x, y, u, v, w, h, textureW, textureH, tu, tv, z);
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void drawTexture(BufferBuilder buffer, float x, float y, int u, int v, float w, float h, int textureW, int textureH, int tu, int tv, float z) {
        float tw = 1.0f / (float)textureW;
        float th = 1.0f / (float)textureH;
        buffer.pos(x, y + h, z).tex((float)u * tw, (float)tv * th).endVertex();
        buffer.pos(x + w, y + h, z).tex((float)tu * tw, (float)tv * th).endVertex();
        buffer.pos(x + w, y, z).tex((float)tu * tw, (float)v * th).endVertex();
        buffer.pos(x, y, z).tex((float)u * tw, (float)v * th).endVertex();
    }

    public static void drawTexture(ResourceLocation location, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
        GuiDraw.drawTexture(x0, y0, x1, y1, u0, v0, u1, v1, 0.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    public static void drawTexture(float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        GuiDraw.drawTexture(x0, y0, x1, y1, u0, v0, u1, v1, 0.0f);
    }

    public static void drawTexture(float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, float z) {
        Tessellator.field_78398_a.func_78382_b();
        GuiDraw.drawTexture(BufferBuilder.buffer, x0, y0, x1, y1, u0, v0, u1, v1, z);
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void drawTexture(BufferBuilder buffer, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, float z) {
        buffer.pos(x0, y1, z).tex(u0, v1).endVertex();
        buffer.pos(x1, y1, z).tex(u1, v1).endVertex();
        buffer.pos(x1, y0, z).tex(u1, v0).endVertex();
        buffer.pos(x0, y0, z).tex(u0, v0).endVertex();
    }

    public static void drawTiledTexture(ResourceLocation location, float x, float y, float w, float h, int u, int v, int tileW, int tileH, int tw, int th, float z) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
        GuiDraw.drawTiledTexture(x, y, w, h, u, v, tileW, tileH, tw, th, z);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    public static void drawTiledTexture(float x, float y, float w, float h, int u, int v, int tileW, int tileH, int tw, int th, float z) {
        int countX = ((int)w - 1) / tileW + 1;
        int countY = ((int)h - 1) / tileH + 1;
        float fillerX = w - (float)((countX - 1) * tileW);
        float fillerY = h - (float)((countY - 1) * tileH);
        Tessellator.field_78398_a.func_78382_b();
        int c = countX * countY;
        for (int i = 0; i < c; ++i) {
            int ix = i % countX;
            int iy = i / countX;
            float xx = x + (float)(ix * tileW);
            float yy = y + (float)(iy * tileH);
            float xw = ix == countX - 1 ? fillerX : (float)tileW;
            float yh = iy == countY - 1 ? fillerY : (float)tileH;
            GuiDraw.drawTexture(BufferBuilder.buffer, xx, yy, u, v, xw, yh, tw, th, z);
        }
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void drawTiledTexture(ResourceLocation location, float x, float y, float w, float h, float u0, float v0, float u1, float v1, int textureWidth, int textureHeight, float z) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
        GuiDraw.drawTiledTexture(x, y, w, h, u0, v0, u1, v1, textureWidth, textureHeight, z);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    public static void drawTiledTexture(float x, float y, float w, float h, float u0, float v0, float u1, float v1, int tileWidth, int tileHeight, float z) {
        int countX = ((int)w - 1) / tileWidth + 1;
        int countY = ((int)h - 1) / tileHeight + 1;
        float fillerX = w - (float)((countX - 1) * tileWidth);
        float fillerY = h - (float)((countY - 1) * tileHeight);
        float fillerU = u0 + (u1 - u0) * fillerX / (float)tileWidth;
        float fillerV = v0 + (v1 - v0) * fillerY / (float)tileHeight;
        Tessellator.field_78398_a.func_78382_b();
        int c = countX * countY;
        for (int i = 0; i < c; ++i) {
            int ix = i % countX;
            int iy = i / countX;
            float xx = x + (float)(ix * tileWidth);
            float yy = y + (float)(iy * tileHeight);
            float xw = tileWidth;
            float yh = tileHeight;
            float uEnd = u1;
            float vEnd = v1;
            if (ix == countX - 1) {
                xw = fillerX;
                uEnd = fillerU;
            }
            if (iy == countY - 1) {
                yh = fillerY;
                vEnd = fillerV;
            }
            GuiDraw.drawTexture(BufferBuilder.buffer, xx, yy, xx + xw, yy + yh, u0, v0, uEnd, vEnd, z);
        }
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void drawItem(ItemStack item, int x, int y, float width, float height) {
        if (item == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)2929);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)(width / 16.0f), (float)(height / 16.0f), (float)1.0f);
        RenderItem renderItem = GuiScreenAccessor.getItemRender();
        renderItem.field_77023_b = 200.0f;
        renderItem.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), item, 0, 0);
        GuiDraw.afterRenderItemAndEffectIntoGUI(item);
        GL11.glDisable((int)32826);
        renderItem.field_77023_b = 0.0f;
        GL11.glDisable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    public static void drawFluidTexture(FluidStack content, float x0, float y0, float width, float height, float z) {
        if (content == null) {
            return;
        }
        Fluid fluid = content.getFluid();
        IIcon fluidStill = fluid.getIcon(content);
        if (ModularUI.isHodgepodgeLoaded && fluidStill instanceof IPatchedTextureAtlasSprite) {
            ((IPatchedTextureAtlasSprite)fluidStill).markNeedsAnimationUpdate();
        }
        int fluidColor = fluid.getColor(content);
        float r = Color.getRedF(fluidColor);
        float g = Color.getGreenF(fluidColor);
        float b = Color.getBlueF(fluidColor);
        float a = Color.getAlphaF(fluidColor);
        a = a == 0.0f ? 1.0f : a;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GuiDraw.drawTiledTexture(TextureMap.field_110575_b, x0, y0, width, height, fluidStill.func_94209_e(), fluidStill.func_94206_g(), fluidStill.func_94212_f(), fluidStill.func_94210_h(), fluidStill.func_94211_a(), fluidStill.func_94216_b(), z);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawOutlineCenter(int x, int y, int offset, int color) {
        GuiDraw.drawOutlineCenter(x, y, offset, color, 1);
    }

    public static void drawOutlineCenter(int x, int y, int offset, int color, int border) {
        GuiDraw.drawOutline(x - offset, y - offset, x + offset, y + offset, color, border);
    }

    public static void drawOutline(int left, int top, int right, int bottom, int color) {
        GuiDraw.drawOutline(left, top, right, bottom, color, 1);
    }

    public static void drawOutline(int left, int top, int right, int bottom, int color, int border) {
        Gui.func_73734_a((int)left, (int)top, (int)(left + border), (int)bottom, (int)color);
        Gui.func_73734_a((int)(right - border), (int)top, (int)right, (int)bottom, (int)color);
        Gui.func_73734_a((int)(left + border), (int)top, (int)(right - border), (int)(top + border), (int)color);
        Gui.func_73734_a((int)(left + border), (int)(bottom - border), (int)(right - border), (int)bottom, (int)color);
    }

    public static void drawDropShadow(int x, int y, int w, int h, int oX, int oY, int opaque, int shadow) {
        float a1 = Color.getAlphaF(opaque);
        float r1 = Color.getRedF(opaque);
        float g1 = Color.getGreenF(opaque);
        float b1 = Color.getBlueF(opaque);
        float a2 = Color.getAlphaF(shadow);
        float r2 = Color.getRedF(shadow);
        float g2 = Color.getGreenF(shadow);
        float b2 = Color.getBlueF(shadow);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator.field_78398_a.func_78382_b();
        float x1 = x + w;
        float y1 = y + h;
        BufferBuilder.buffer.pos(x1, y, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x, y, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x, y1, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x1, y1, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x1 + (float)oX, y - oY, 0.0).color(r2, g2, b2, a2).endVertex();
        BufferBuilder.buffer.pos(x - oX, y - oY, 0.0).color(r2, g2, b2, a2).endVertex();
        BufferBuilder.buffer.pos(x, y, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x1, y, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x1, y1, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x, y1, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x - oX, y1 + (float)oY, 0.0).color(r2, g2, b2, a2).endVertex();
        BufferBuilder.buffer.pos(x1 + (float)oX, y1 + (float)oY, 0.0).color(r2, g2, b2, a2).endVertex();
        BufferBuilder.buffer.pos(x, y, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x - oX, y - oY, 0.0).color(r2, g2, b2, a2).endVertex();
        BufferBuilder.buffer.pos(x - oX, y1 + (float)oY, 0.0).color(r2, g2, b2, a2).endVertex();
        BufferBuilder.buffer.pos(x, y1, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x1 + (float)oX, y - oY, 0.0).color(r2, g2, b2, a2).endVertex();
        BufferBuilder.buffer.pos(x1, y, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x1, y1, 0.0).color(r1, g1, b1, a1).endVertex();
        BufferBuilder.buffer.pos(x1 + (float)oX, y1 + (float)oY, 0.0).color(r2, g2, b2, a2).endVertex();
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawDropCircleShadow(int x, int y, int radius, int segments, int opaque, int shadow) {
        float a1 = Color.getAlphaF(opaque);
        float r1 = Color.getRedF(opaque);
        float g1 = Color.getGreenF(opaque);
        float b1 = Color.getBlueF(opaque);
        float a2 = Color.getAlphaF(shadow);
        float r2 = Color.getRedF(shadow);
        float g2 = Color.getGreenF(shadow);
        float b2 = Color.getBlueF(shadow);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator.field_78398_a.func_78382_b();
        BufferBuilder.buffer.pos(x, y, 0.0).color(r1, g1, b1, a1).endVertex();
        for (int i = 0; i <= segments; ++i) {
            double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            BufferBuilder.buffer.pos((double)x - Math.cos(a) * (double)radius, (double)y + Math.sin(a) * (double)radius, 0.0).color(r2, g2, b2, a2).endVertex();
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawDropCircleShadow(int x, int y, int radius, int offset, int segments, int opaque, int shadow) {
        int i;
        if (offset >= radius) {
            GuiDraw.drawDropCircleShadow(x, y, radius, segments, opaque, shadow);
            return;
        }
        float a1 = Color.getAlphaF(opaque);
        float r1 = Color.getRedF(opaque);
        float g1 = Color.getGreenF(opaque);
        float b1 = Color.getBlueF(opaque);
        float a2 = Color.getAlphaF(shadow);
        float r2 = Color.getRedF(shadow);
        float g2 = Color.getGreenF(shadow);
        float b2 = Color.getBlueF(shadow);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator.field_78398_a.func_78382_b();
        BufferBuilder.buffer.pos(x, y, 0.0).color(r1, g1, b1, a1).endVertex();
        for (i = 0; i <= segments; ++i) {
            double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            BufferBuilder.buffer.pos((double)x - Math.cos(a) * (double)offset, (double)y + Math.sin(a) * (double)offset, 0.0).color(r1, g1, b1, a1).endVertex();
        }
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        for (i = 0; i < segments; ++i) {
            double alpha1 = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            double alpha2 = (double)(i + 1) / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            BufferBuilder.buffer.pos((double)x - Math.cos(alpha2) * (double)offset, (double)y + Math.sin(alpha2) * (double)offset, 0.0).color(r1, g1, b1, a1).endVertex();
            BufferBuilder.buffer.pos((double)x - Math.cos(alpha1) * (double)offset, (double)y + Math.sin(alpha1) * (double)offset, 0.0).color(r1, g1, b1, a1).endVertex();
            BufferBuilder.buffer.pos((double)x - Math.cos(alpha1) * (double)radius, (double)y + Math.sin(alpha1) * (double)radius, 0.0).color(r2, g2, b2, a2).endVertex();
            BufferBuilder.buffer.pos((double)x - Math.cos(alpha2) * (double)radius, (double)y + Math.sin(alpha2) * (double)radius, 0.0).color(r2, g2, b2, a2).endVertex();
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBorder(float x, float y, float width, float height, int color, float border) {
        GuiDraw.drawRect(x - border, y - border, width + 2.0f * border, border, color);
        GuiDraw.drawRect(x - border, y + height, width + 2.0f * border, border, color);
        GuiDraw.drawRect(x - border, y, border, height, color);
        GuiDraw.drawRect(x + width, y, border, height, color);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawText(String text, float x, float y, float scale, int color, boolean shadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)0.0f);
        float sf = 1.0f / scale;
        fontRenderer.func_85187_a(text, (int)(x * sf), (int)(y * sf), color, shadow);
        GL11.glPopMatrix();
        GL11.glEnable((int)3042);
    }

    public static void drawTooltipBackground(ItemStack stack, List<String> lines, int x, int y, int textWidth, int height) {
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        GuiDraw.drawVerticalGradientRect(x - 3, y - 4, textWidth + 6, 1.0f, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x - 3, y + height + 3, textWidth + 6, 1.0f, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x - 3, y - 3, textWidth + 6, height + 6, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x - 4, y - 3, 1.0f, height + 6, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x + textWidth + 3, y - 3, 1.0f, height + 6, backgroundColor, backgroundColor);
        GuiDraw.drawVerticalGradientRect(x - 3, y - 2, 1.0f, height + 4, borderColorStart, borderColorEnd);
        GuiDraw.drawVerticalGradientRect(x + textWidth + 2, y - 2, 1.0f, height + 4, borderColorStart, borderColorEnd);
        GuiDraw.drawVerticalGradientRect(x - 3, y - 3, textWidth + 6, 1.0f, borderColorStart, borderColorStart);
        GuiDraw.drawVerticalGradientRect(x - 3, y + height + 2, textWidth + 6, 1.0f, borderColorEnd, borderColorEnd);
    }

    public static void afterRenderItemAndEffectIntoGUI(ItemStack stack) {
        if (stack.hasEffect(0)) {
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

