/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemicalPotionCreationHandler;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipe;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipeRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.IBindingAgent;
import WayofTime.alchemicalWizardry.common.ICatalyst;
import WayofTime.alchemicalWizardry.common.IFillingAgent;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.alchemy.CombinedPotionRegistry;
import WayofTime.alchemicalWizardry.common.alchemy.ICombinationalCatalyst;
import WayofTime.alchemicalWizardry.common.items.potion.AlchemyFlask;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEInventory;
import WayofTime.alchemicalWizardry.compat.IBloodMagicWailaProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TEWritingTable
extends TEInventory
implements ISidedInventory,
IBloodMagicWailaProvider {
    public static final int sizeInv = 7;
    private int progress;
    private int amountUsed;
    private int accelerationTime;

    public TEWritingTable() {
        super(7);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.progress = tagCompound.func_74762_e("progress");
        this.amountUsed = tagCompound.func_74762_e("amountUsed");
        this.accelerationTime = tagCompound.func_74762_e("accelerationTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("progress", this.progress);
        tagCompound.func_74768_a("amountUsed", this.amountUsed);
        tagCompound.func_74768_a("accelerationTime", this.accelerationTime);
    }

    @Override
    public String func_145825_b() {
        return "aw.TEWritingTable";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        switch (i) {
            case 0: {
                if (itemstack == null) break;
                return itemstack.func_77973_b() instanceof IBloodOrb;
            }
        }
        return i != 6;
    }

    public Packet func_145844_m() {
        return NewPacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData) {
        if (intData == null) {
            return;
        }
        if (intData.length == 21) {
            for (int i = 0; i < 7; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.func_150899_d((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[21];
        int pos = 0;
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[pos++] = Item.func_150891_b((Item)is.func_77973_b());
                sortList[pos++] = is.func_77960_j();
                sortList[pos++] = is.field_77994_a;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    public ItemStack getResultingItemStack() {
        ItemStack[] composedRecipe = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            composedRecipe[i] = this.inv[i + 1];
        }
        return AlchemyRecipeRegistry.getResult(composedRecipe, this.inv[0]);
    }

    public boolean isRecipeValid() {
        return this.getResultingItemStack() != null;
    }

    public int getAmountNeeded(ItemStack bloodOrb) {
        ItemStack[] composedRecipe = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            composedRecipe[i] = this.inv[i + 1];
        }
        return AlchemyRecipeRegistry.getAmountNeeded(composedRecipe, bloodOrb);
    }

    public boolean containsPotionFlask() {
        return this.getPotionFlaskPosition() != -1;
    }

    public int getPotionFlaskPosition() {
        for (int i = 1; i <= 5; ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() instanceof ItemBlock || this.inv[i].func_77973_b() != ModItems.alchemyFlask) continue;
            return i;
        }
        return -1;
    }

    public boolean containsCombinationCatalyst() {
        return this.getCombinationCatalystPosition() != -1;
    }

    public int getCombinationCatalystPosition() {
        for (int i = 1; i <= 5; ++i) {
            if (this.inv[i] == null || !(this.inv[i].func_77973_b() instanceof ICombinationalCatalyst)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsRegisteredPotionIngredient() {
        return this.getRegisteredPotionIngredientPosition() != -1;
    }

    public int getRegisteredPotionIngredientPosition() {
        ItemStack[] composedRecipe = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            composedRecipe[i] = this.inv[i + 1];
        }
        int location = AlchemicalPotionCreationHandler.getRegisteredPotionIngredientPosition(composedRecipe);
        if (location != -1) {
            return location + 1;
        }
        return -1;
    }

    public boolean containsCatalyst() {
        return this.getCatalystPosition() != -1;
    }

    public int getCatalystPosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || !(this.inv[i + 1].func_77973_b() instanceof ICatalyst)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean containsBindingAgent() {
        return this.getBindingAgentPosition() != -1;
    }

    public int getBindingAgentPosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || !(this.inv[i + 1].func_77973_b() instanceof IBindingAgent)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean containsFillingAgent() {
        return this.getFillingAgentPosition() != -1;
    }

    public int getFillingAgentPosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || !(this.inv[i + 1].func_77973_b() instanceof IFillingAgent)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean containsBlankSlate() {
        return this.getBlankSlatePosition() != -1;
    }

    public int getBlankSlatePosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || this.inv[i + 1].func_77973_b() != ModItems.blankSlate) continue;
            return i + 1;
        }
        return -1;
    }

    public void func_145845_h() {
        int progressNeeded = 100;
        long worldTime = this.field_145850_b.func_72820_D();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.accelerationTime > 0) {
            --this.accelerationTime;
        }
        if (this.containsPotionFlask() && this.containsRegisteredPotionIngredient()) {
            if (this.containsCatalyst()) {
                if (this.func_70301_a(6) == null) {
                    ++this.progress;
                    if (worldTime % 4L == 0L) {
                        SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    if (this.progress >= progressNeeded) {
                        ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                        ItemStack ingredientStack = this.inv[this.getRegisteredPotionIngredientPosition()];
                        ItemStack catalystStack = this.inv[this.getCatalystPosition()];
                        if (flaskStack == null || ingredientStack == null || catalystStack == null) {
                            this.progress = 0;
                            if (this.field_145850_b != null) {
                                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            }
                            return;
                        }
                        int potionID = AlchemicalPotionCreationHandler.getPotionIDForStack(ingredientStack);
                        int catalystLevel = ((ICatalyst)catalystStack.func_77973_b()).getCatalystLevel();
                        boolean isConcentration = ((ICatalyst)catalystStack.func_77973_b()).isConcentration();
                        if (potionID == -1 || catalystLevel < 0) {
                            this.progress = 0;
                            if (this.field_145850_b != null) {
                                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            }
                            return;
                        }
                        if (isConcentration) {
                            ((AlchemyFlask)flaskStack.func_77973_b()).setConcentrationOfPotion(flaskStack, potionID, catalystLevel);
                        } else {
                            ((AlchemyFlask)flaskStack.func_77973_b()).setDurationFactorOfPotion(flaskStack, potionID, catalystLevel);
                        }
                        this.func_70299_a(6, flaskStack);
                        this.func_70298_a(this.getPotionFlaskPosition(), 1);
                        this.func_70298_a(this.getCatalystPosition(), 1);
                        this.func_70298_a(this.getRegisteredPotionIngredientPosition(), 1);
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                }
            } else if (this.containsBindingAgent() && this.func_70301_a(6) == null) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.progress >= progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack ingredientStack = this.inv[this.getRegisteredPotionIngredientPosition()];
                    ItemStack agentStack = this.inv[this.getBindingAgentPosition()];
                    if (flaskStack == null || ingredientStack == null || agentStack == null) {
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                    int potionEffectNumber = ((AlchemyFlask)flaskStack.func_77973_b()).getNumberOfPotionEffects(flaskStack);
                    int potionID = AlchemicalPotionCreationHandler.getPotionIDForStack(ingredientStack);
                    int tickDuration = AlchemicalPotionCreationHandler.getPotionTickDurationForStack(ingredientStack);
                    float successChance = ((IBindingAgent)agentStack.func_77973_b()).getSuccessRateForPotionNumber(potionEffectNumber);
                    if (potionID == -1) {
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                    ((AlchemyFlask)flaskStack.func_77973_b()).addPotionEffect(flaskStack, potionID, tickDuration);
                    if (successChance > this.field_145850_b.field_73012_v.nextFloat()) {
                        this.func_70299_a(6, flaskStack);
                    } else {
                        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 2.0f, false);
                    }
                    this.func_70298_a(this.getPotionFlaskPosition(), 1);
                    this.func_70298_a(this.getBindingAgentPosition(), 1);
                    this.func_70298_a(this.getRegisteredPotionIngredientPosition(), 1);
                    this.progress = 0;
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
        } else if (this.containsBlankSlate() && this.containsPotionFlask()) {
            if (this.func_70301_a(6) == null) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.progress >= progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack blankSlate = this.inv[this.getBlankSlatePosition()];
                    if (flaskStack == null || blankSlate == null) {
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                    ((AlchemyFlask)flaskStack.func_77973_b()).setIsPotionThrowable(true, flaskStack);
                    this.func_70299_a(6, flaskStack);
                    this.func_70298_a(this.getPotionFlaskPosition(), 1);
                    this.func_70298_a(this.getBlankSlatePosition(), 1);
                    this.progress = 0;
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
        } else if (this.containsFillingAgent() && this.containsPotionFlask()) {
            if (this.func_70301_a(6) == null) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.progress >= progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack fillingAgent = this.inv[this.getFillingAgentPosition()];
                    if (flaskStack == null || fillingAgent == null) {
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                    int potionEffects = ((AlchemyFlask)flaskStack.func_77973_b()).getNumberOfPotionEffects(flaskStack);
                    int potionFillAmount = ((IFillingAgent)fillingAgent.func_77973_b()).getFilledAmountForPotionNumber(potionEffects);
                    flaskStack.func_77964_b(Math.max(0, flaskStack.func_77960_j() - potionFillAmount));
                    this.func_70299_a(6, flaskStack);
                    this.func_70298_a(this.getPotionFlaskPosition(), 1);
                    this.func_70298_a(this.getFillingAgentPosition(), 1);
                    this.progress = 0;
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
        } else if (this.containsPotionFlask() && this.containsCombinationCatalyst()) {
            if (this.func_70301_a(6) == null && CombinedPotionRegistry.hasCombinablePotionEffect(this.inv[this.getPotionFlaskPosition()])) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.progress >= progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack combinationCatalyst = this.inv[this.getCombinationCatalystPosition()];
                    if (flaskStack == null || combinationCatalyst == null) {
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                    ItemStack newFlask = CombinedPotionRegistry.applyPotionEffect(flaskStack);
                    if (newFlask != null) {
                        this.func_70299_a(6, newFlask);
                        this.func_70298_a(this.getPotionFlaskPosition(), 1);
                        this.func_70298_a(this.getCombinationCatalystPosition(), 1);
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                }
            }
        } else {
            if (!this.isRecipeValid()) {
                this.progress = 0;
                return;
            }
            if (this.progress <= 0) {
                this.progress = 0;
                this.amountUsed = this.getAmountNeeded(this.func_70301_a(0));
                if (this.field_145850_b != null) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            int acceleration = this.getSpeedIncrease();
            if (this.func_70301_a(6) == null) {
                if (!SoulNetworkHandler.syphonFromNetworkWhileInContainer(this.func_70301_a(0), this.amountUsed * acceleration)) {
                    return;
                }
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                this.progress += acceleration;
                if (this.progress >= progressNeeded) {
                    this.progress = 0;
                    this.func_70299_a(6, this.getResultingItemStack());
                    ItemStack[] composedRecipe = new ItemStack[5];
                    for (int i = 0; i < 5; ++i) {
                        composedRecipe[i] = this.inv[i + 1];
                    }
                    this.decrementSlots(this.getRecipeForItems(composedRecipe, this.inv[0]));
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            } else if (this.func_70301_a(6).func_77973_b() == this.getResultingItemStack().func_77973_b() && this.getResultingItemStack().field_77994_a <= this.func_70301_a(6).func_77976_d() - this.func_70301_a((int)6).field_77994_a) {
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (!SoulNetworkHandler.syphonFromNetworkWhileInContainer(this.func_70301_a(0), this.amountUsed * acceleration)) {
                    return;
                }
                this.progress += acceleration;
                if (this.progress >= progressNeeded) {
                    this.progress = 0;
                    ItemStack result = this.getResultingItemStack().func_77946_l();
                    result.field_77994_a += this.func_70301_a((int)6).field_77994_a;
                    this.func_70299_a(6, result);
                    ItemStack[] composedRecipe = new ItemStack[5];
                    for (int i = 0; i < 5; ++i) {
                        composedRecipe[i] = this.inv[i + 1];
                    }
                    this.decrementSlots(this.getRecipeForItems(composedRecipe, this.inv[0]));
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
        }
    }

    public void decrementSlots(ItemStack[] recipe) {
        boolean[] decrementedList = new boolean[]{false, false, false, false, false};
        block0: for (int i = 0; i < Math.min(recipe.length, 5); ++i) {
            ItemStack decStack = recipe[i];
            if (decStack == null) continue;
            for (int j = 0; j < 5; ++j) {
                ItemStack testStack = this.func_70301_a(j + 1);
                if (testStack == null || !testStack.func_77969_a(decStack) && (testStack.func_77973_b() != decStack.func_77973_b() || decStack.func_77960_j() != Short.MAX_VALUE) || decrementedList[j]) continue;
                if (testStack.func_77973_b().hasContainerItem(testStack)) {
                    this.inv[j + 1] = testStack.func_77973_b().getContainerItem(testStack);
                } else {
                    this.func_70298_a(j + 1, 1);
                }
                decrementedList[j] = true;
                continue block0;
            }
        }
    }

    public ItemStack[] getRecipeForItems(ItemStack[] recipe, ItemStack bloodOrb) {
        if (bloodOrb == null) {
            return null;
        }
        if (!(bloodOrb.func_77973_b() instanceof IBloodOrb)) {
            return null;
        }
        int bloodOrbLevel = ((IBloodOrb)bloodOrb.func_77973_b()).getOrbLevel();
        for (AlchemyRecipe ar : AlchemyRecipeRegistry.recipes) {
            if (!ar.doesRecipeMatch(recipe, bloodOrbLevel)) continue;
            return ar.getRecipe();
        }
        return null;
    }

    public int getSpeedIncrease() {
        return this.accelerationTime > 0 ? 5 : 1;
    }

    public boolean isWorking() {
        return this.progress > 0;
    }

    public void setAccelerationTime(int accelerationTime) {
        this.accelerationTime = accelerationTime;
    }

    public int[] func_94128_d(int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        switch (dir) {
            case DOWN: {
                return new int[]{6};
            }
        }
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot != 6;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 6;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("bm.chemistrySet")) {
            return;
        }
        NBTTagCompound tag = accessor.getNBTData();
        int curProgress = tag.func_74762_e("progress");
        if (curProgress > 0) {
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.waila.altarProgress") + curProgress + "%");
        }
        if (tag.func_74764_b("crafting")) {
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.waila.crafting") + tag.func_74779_i("crafting"));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        tag.func_74768_a("progress", this.progress);
        ItemStack result = this.getResultingItemStack();
        if (result != null) {
            tag.func_74778_a("crafting", result.func_82833_r());
        }
    }
}

