/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.asm;

import com.gtnewhorizons.retrofuturabootstrap.Main;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.FastClassAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class SafeAsmClassWriter
extends ClassWriter {
    public static final ThreadLocal<Integer> forcedFlags = ThreadLocal.withInitial(() -> 0);
    public static final ThreadLocal<byte[]> forcedOriginalClass = new ThreadLocal();
    private final Map<String, InheritanceNode> inheritanceCache = new HashMap<String, InheritanceNode>();

    public SafeAsmClassWriter(int flags) {
        super(flags | forcedFlags.get());
        if (forcedOriginalClass.get() != null) {
            ClassHeaderMetadata chm = new ClassHeaderMetadata(forcedOriginalClass.get());
            super.visit(chm.majorVersion, chm.accessFlags, chm.binaryThisName, null, chm.binarySuperName, null);
        }
    }

    public SafeAsmClassWriter(ClassReader classReader, int flags) {
        super(classReader, flags | forcedFlags.get());
    }

    @Override
    protected ClassLoader getClassLoader() {
        ExtensibleClassLoader launchLoader = Main.launchLoader;
        return launchLoader != null ? launchLoader.asURLClassLoader() : Main.compatLoader;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        ClassLoader classLoader = this.getClassLoader();
        if (!(classLoader instanceof ExtensibleClassLoader)) {
            Main.logger.warn("SafeAsmClassWriter#getClassLoader() didn't return an ExtensibleClassLoader, falling back to default getCommonSuperClass implementation");
            return super.getCommonSuperClass(type1, type2);
        }
        ExtensibleClassLoader loader = (ExtensibleClassLoader)((Object)classLoader);
        InheritanceNode inheritance1 = this.getInheritanceInfo(loader, type1);
        if (inheritance1 == null) {
            throw new TypeNotPresentException(type1, null);
        }
        InheritanceNode inheritance2 = this.getInheritanceInfo(loader, type2);
        if (inheritance2 == null) {
            throw new TypeNotPresentException(type2, null);
        }
        if (inheritance1.isAssignableFrom(inheritance2)) {
            return type1;
        }
        if (inheritance2.isAssignableFrom(inheritance1)) {
            return type2;
        }
        if (inheritance1.accessor.isInterface() || inheritance2.accessor.isInterface()) {
            return "java/lang/Object";
        }
        do {
            if ((inheritance1 = inheritance1.superClass) != null) continue;
            return "java/lang/Object";
        } while (!inheritance1.isAssignableFrom(inheritance2));
        return inheritance1.accessor.binaryThisName();
    }

    @Nullable
    private InheritanceNode getInheritanceInfo(ExtensibleClassLoader loader, String type) {
        InheritanceNode superClass;
        InheritanceNode node = this.inheritanceCache.get(type);
        if (node != null) {
            return node;
        }
        FastClassAccessor typeAccessor = loader.findClassMetadata(type.replace('/', '.'));
        if (typeAccessor == null) {
            Main.logger.warn("Could not find type {} during inheritance search", new Object[]{type});
            this.inheritanceCache.put(type, null);
            return null;
        }
        HashSet<InheritanceNode> allSuperClasses = new HashSet<InheritanceNode>();
        String superType = typeAccessor.binarySuperName();
        if (superType != null) {
            superClass = this.getInheritanceInfo(loader, superType);
            if (superClass != null) {
                allSuperClasses.addAll(superClass.allSuperClasses);
            }
        } else {
            superClass = null;
        }
        ArrayList<InheritanceNode> interfaces = new ArrayList<InheritanceNode>();
        for (String interfaceType : typeAccessor.binaryInterfaceNames()) {
            InheritanceNode iface = this.getInheritanceInfo(loader, interfaceType);
            if (iface == null) continue;
            interfaces.add(iface);
            allSuperClasses.addAll(iface.allSuperClasses);
        }
        node = new InheritanceNode(typeAccessor, superClass, interfaces, allSuperClasses);
        this.inheritanceCache.put(type, node);
        return node;
    }

    private static final class InheritanceNode {
        @Nullable
        final InheritanceNode superClass;
        @NotNull
        final List<InheritanceNode> interfaces;
        @NotNull
        final FastClassAccessor accessor;
        @NotNull
        final Set<InheritanceNode> allSuperClasses;

        InheritanceNode(@NotNull FastClassAccessor accessor, @Nullable InheritanceNode superClass, @NotNull List<InheritanceNode> interfaces, @NotNull Set<InheritanceNode> allSuperClasses) {
            this.accessor = accessor;
            this.superClass = superClass;
            this.interfaces = interfaces;
            this.allSuperClasses = allSuperClasses;
            allSuperClasses.add(this);
        }

        boolean isAssignableFrom(InheritanceNode other) {
            return other.allSuperClasses.contains(this);
        }
    }
}

