/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.core.helper;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Method;
import net.minecraftforge.common.MinecraftForge;

public class EventHelper {
    public static void register(Object instance) {
        boolean fml = false;
        boolean forge = false;
        Class<?> clazz = instance.getClass();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(SubscribeEvent.class)) continue;
            if (method.getParameterTypes().length != 1) {
                return;
            }
            Class<?> event = method.getParameterTypes()[0];
            if (event.getName().contains("net.minecraftforge.event")) {
                forge = true;
                continue;
            }
            if (!event.getName().contains("cpw.mods.fml.common.gameevent")) continue;
            fml = true;
        }
        if (fml && forge) {
            EventHelper.register(instance, BusType.BOTH);
        } else if (fml) {
            EventHelper.register(instance, BusType.FML);
        } else if (forge) {
            EventHelper.register(instance, BusType.FORGE);
        }
    }

    public static void register(Object instance, BusType type) {
        if (type == BusType.FML || type == BusType.BOTH) {
            FMLCommonHandler.instance().bus().register(instance);
        }
        if (type == BusType.FORGE || type == BusType.BOTH) {
            MinecraftForge.EVENT_BUS.register(instance);
        }
    }

    public static enum BusType {
        FML,
        FORGE,
        BOTH;

    }
}

