/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.entity.boss;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.core.register.GSItems;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT7;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.IBoss;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class EntitySlimeBoss
extends EntityLiving
implements IMob,
IEntityBreathable,
IBossDisplayData,
IBoss {
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private int slimeJumpDelay;
    private Vector3 roomCoords;
    private Vector3 roomSize;
    public int deathTicks = 0;
    public int headsRemaining = 3;
    protected long ticks = 0L;
    public Entity targetEntity;
    public int entitiesWithin;
    public int entitiesWithinLast;
    private TileEntityDungeonSpawner spawnerpr;

    public EntitySlimeBoss(World world) {
        super(world);
        this.field_70146_Z.nextInt(3);
        this.field_70129_M = 0.0f;
        this.slimeJumpDelay = this.field_70146_Z.nextInt(30) + 20;
        this.setSlimeSize(8);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(900.0 * ConfigManagerCore.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.05f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void setSlimeSize(int size) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)size));
        this.func_70105_a(0.6f * (float)size, 0.6f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70728_aV = size;
    }

    public int getSlimeSize() {
        return ((Byte)this.field_70180_af.func_75691_i(16).func_75669_b()).byteValue();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Size", this.getSlimeSize() - 1);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSlimeSize(nbt.func_74762_e("Size") + 1);
    }

    protected String getJumpSound() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70015_d(5);
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        int i;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && this.getSlimeSize() > 0) {
            this.field_70128_L = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (this.field_70122_E && !flag) {
            i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f2 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f3 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f2;
                float f4 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f2;
                this.field_70170_p.func_72869_a("water", this.field_70165_t + (double)f3, this.field_70121_D.field_72338_b, this.field_70161_v + (double)f4, 0.0, 0.0, 0.0);
            }
            if (this.makesSoundOnLand()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && flag) {
            this.squishAmount = 1.0f;
        }
        this.alterSquishAmount();
        if (this.field_70170_p.field_72995_K) {
            i = this.getSlimeSize();
            this.func_70105_a(0.6f * (float)i, 0.6f * (float)i);
        }
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (entityplayer != null) {
            this.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
        }
        if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.field_70703_bu = true;
            if (this.makesSoundOnJump()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
            this.field_70701_bs = 1 * this.getSlimeSize();
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                float n = 0.0f;
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(30) + 20;
    }

    protected EntitySlimeBoss createInstance() {
        return new EntitySlimeBoss(this.field_70170_p);
    }

    public void func_70106_y() {
        if (this.spawnerpr != null) {
            this.spawnerpr.isBossDefeated = false;
            this.spawnerpr.boss = null;
            this.spawnerpr.spawned = false;
        }
        super.func_70106_y();
    }

    public void func_70100_b_(EntityPlayer entityPlayer) {
        if (this.canDamagePlayer()) {
            int i = this.getSlimeSize();
            if (this.func_70685_l((Entity)entityPlayer) && this.func_70068_e((Entity)entityPlayer) < 0.6 * (double)i * 0.6 * (double)i && entityPlayer.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
                entityPlayer.func_70015_d(5);
                this.func_85030_a("mob.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected boolean canDamagePlayer() {
        return this.getSlimeSize() > 1;
    }

    protected int getAttackStrength() {
        return this.getSlimeSize() + 5;
    }

    protected String func_70621_aR() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected String func_70673_aS() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var3 = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + par2);
        if (this.getSlimeSize() == 1) {
            for (int var4 = 0; var4 < var3; ++var4) {
                this.func_70099_a(new ItemStack(Items.field_151064_bs, 1), 0.0f);
            }
        }
    }

    public boolean func_70058_J() {
        return false;
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSlimeSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }

    public boolean canBreath() {
        return true;
    }

    public void setRoom(Vector3 roomCoords, Vector3 roomSize) {
        this.roomCoords = roomCoords;
        this.roomSize = roomSize;
    }

    public void onBossSpawned(TileEntityDungeonSpawner spawner) {
        this.spawnerpr = spawner;
    }

    public ItemStack getGuaranteedLoot(Random rand) {
        List stackList = GalacticraftRegistry.getDungeonLoot((int)7);
        return ((ItemStack)stackList.get(rand.nextInt(stackList.size()))).func_77946_l();
    }

    protected void func_70609_aI() {
        float n;
        ++this.deathTicks;
        this.headsRemaining = 0;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f;
            float f3 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f2, this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 180 && this.deathTicks % 5 == 0) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_EXPLODE, new Object[0]), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int j;
                for (int i = 30; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 1) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, new Object[0]), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
        }
        this.func_70091_d(0.0, 0.1f, 0.0);
        this.field_70177_z = n = this.field_70177_z + 20.0f;
        this.field_70761_aq = n;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 20; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            for (Object tile : this.field_70170_p.field_147482_g) {
                if (!(tile instanceof TileEntityTreasureChestT7)) continue;
                double d3 = (double)((TileEntityTreasureChestT7)((Object)tile)).field_145851_c + 0.5 - this.field_70165_t;
                double d4 = (double)((TileEntityTreasureChestT7)((Object)tile)).field_145848_d + 0.5 - this.field_70163_u;
                double d5 = (double)((TileEntityTreasureChestT7)((Object)tile)).field_145849_e + 0.5 - this.field_70161_v;
                double dSq = d3 * d3 + d4 * d4 + d5 * d5;
                TileEntityTreasureChestT7 chest = (TileEntityTreasureChestT7)((Object)tile);
                if (!(dSq < 10000.0)) continue;
                if (!chest.locked) {
                    chest.locked = true;
                }
                for (int k = 0; k < chest.func_70302_i_(); ++k) {
                    chest.func_70299_a(k, null);
                }
                ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)chest, (int)info.getCount(this.field_70146_Z));
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)chest, (int)info.getCount(this.field_70146_Z));
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)chest, (int)info.getCount(this.field_70146_Z));
                chest.func_70299_a(this.field_70146_Z.nextInt(chest.func_70302_i_()), this.getGuaranteedLoot(this.field_70146_Z));
                break;
            }
            this.func_70099_a(new ItemStack(GSItems.Tier7Key, 1), 0.5f);
            super.func_70106_y();
            if (this.spawnerpr != null) {
                this.spawnerpr.isBossDefeated = true;
                this.spawnerpr.boss = null;
                this.spawnerpr.spawned = false;
            }
        }
    }

    public void func_70636_d() {
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        if (this.func_110143_aJ() <= 0.0f) {
            this.headsRemaining = 0;
        } else if ((double)this.func_110143_aJ() <= (double)this.func_110138_aP() / 3.0) {
            this.headsRemaining = 1;
        } else if ((double)this.func_110143_aJ() <= 2.0 * ((double)this.func_110138_aP() / 3.0)) {
            this.headsRemaining = 2;
        }
        EntityPlayer player = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0);
        if (player != null && !player.equals((Object)this.targetEntity)) {
            if (this.func_70068_e((Entity)player) < 400.0) {
                this.func_70661_as().func_75494_a((Entity)player);
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        new Vector3((Entity)this);
        if (this.roomCoords != null && this.roomSize != null) {
            List entitiesWithin = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.roomCoords.intX() - 1), (double)(this.roomCoords.intY() - 1), (double)(this.roomCoords.intZ() - 1), (double)(this.roomCoords.intX() + this.roomSize.intX()), (double)(this.roomCoords.intY() + this.roomSize.intY()), (double)(this.roomCoords.intZ() + this.roomSize.intZ())));
            this.entitiesWithin = entitiesWithin.size();
            if (this.entitiesWithin == 0 && this.entitiesWithinLast != 0) {
                List entitiesWithin2 = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.roomCoords.intX() - 11), (double)(this.roomCoords.intY() - 11), (double)(this.roomCoords.intZ() - 11), (double)(this.roomCoords.intX() + this.roomSize.intX() + 10), (double)(this.roomCoords.intY() + this.roomSize.intY() + 10), (double)(this.roomCoords.intZ() + this.roomSize.intZ() + 10)));
                for (EntityPlayer p : entitiesWithin2) {
                    p.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate((String)"gui.skeletonBoss.message")));
                }
                this.func_70106_y();
                if (this.spawnerpr != null) {
                    this.spawnerpr.playerCheated = true;
                }
                return;
            }
            this.entitiesWithinLast = this.entitiesWithin;
        }
        super.func_70636_d();
    }
}

