/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.entities;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.util.MarsUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;

public class EntityCargoRocket
extends EntityAutoRocket
implements IRocketType,
IInventory,
IWorldTransferCallback {
    public IRocketType.EnumRocketType rocketType;
    public float rumble;

    public EntityCargoRocket(World par1World) {
        super(par1World);
        this.func_70105_a(0.98f, 2.0f);
    }

    public EntityCargoRocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        this.func_70105_a(0.98f, 2.0f);
    }

    @Override
    public int getFuelTankCapacity() {
        return 2000;
    }

    public float getCargoFilledAmount() {
        float weight = 1.0f;
        for (ItemStack stack : this.cargoItems) {
            if (stack == null) continue;
            weight = (float)((double)weight + 0.1);
        }
        return weight;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(MarsItems.spaceship, 1, this.rocketType.getIndex() + 10);
    }

    @Override
    public void func_70071_h_() {
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            double motionScalar = this.timeSinceLaunch / 250.0f;
            motionScalar = Math.min(motionScalar, 1.0);
            double modifier = this.getCargoFilledAmount();
            if (!this.landing && (motionScalar *= 5.0 / modifier) != 0.0) {
                this.field_70181_x = -motionScalar * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(3.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
        super.func_70071_h_();
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        }
        if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
    }

    @Override
    protected boolean shouldMoveClientSide() {
        return true;
    }

    protected void spawnParticles(boolean launched) {
        double x1 = 2.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double z1 = 2.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double y1 = 2.0 * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
        if (this.landing && this.targetVec != null) {
            double modifier = this.field_70163_u - (double)this.targetVec.y;
            modifier = Math.max(modifier, 1.0);
            x1 *= modifier / 60.0;
            y1 *= modifier / 60.0;
            z1 *= modifier / 60.0;
        }
        double y = this.field_70167_r + (this.field_70163_u - this.field_70167_r) - 0.4;
        if (!this.field_70128_L) {
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y, this.field_70161_v + z1), new Vector3(x1, y1, z1), new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.2 + x1, y, this.field_70161_v + z1), new Vector3(x1, y1, z1), new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.2 + x1, y, this.field_70161_v + z1), new Vector3(x1, y1, z1), new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y, this.field_70161_v + 0.2 + z1), new Vector3(x1, y1, z1), new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y, this.field_70161_v - 0.2 + z1), new Vector3(x1, y1, z1), new Object[]{this.field_70153_n});
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        this.rocketType = IRocketType.EnumRocketType.values()[buffer.readInt()];
        super.decodePacketdata(buffer);
        this.field_70165_t = buffer.readDouble() / 8000.0;
        this.field_70163_u = buffer.readDouble() / 8000.0;
        this.field_70161_v = buffer.readDouble() / 8000.0;
    }

    @Override
    public void getNetworkedData(ArrayList<Object> list) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        list.add(this.rocketType != null ? this.rocketType.getIndex() : 0);
        super.getNetworkedData(list);
        list.add(this.field_70165_t * 8000.0);
        list.add(this.field_70163_u * 8000.0);
        list.add(this.field_70161_v * 8000.0);
    }

    @Override
    public void onReachAtmosphere() {
        if (this.field_70170_p.field_72995_K) {
            this.stopRocketSound();
            return;
        }
        GCLog.debug("[Serverside] Cargo rocket reached space, heading to " + this.destinationFrequency);
        this.setTarget(true, this.destinationFrequency);
        if (this.targetVec != null) {
            GCLog.debug("Destination location = " + this.targetVec.toString());
            if (this.targetDimension != this.field_70170_p.field_73011_w.field_76574_g) {
                GCLog.debug("Destination is in different dimension: " + this.targetDimension);
                WorldProvider targetDim = WorldUtil.getProviderForDimensionServer(this.targetDimension);
                if (targetDim != null && targetDim.field_76579_a instanceof WorldServer) {
                    GCLog.debug("Loaded destination dimension " + this.targetDimension);
                    this.func_70107_b((float)this.targetVec.x + 0.5f, this.targetVec.y + 800, (float)this.targetVec.z + 0.5f);
                    Entity e = WorldUtil.transferEntityToDimension(this, this.targetDimension, (WorldServer)targetDim.field_76579_a, false, null);
                    if (e instanceof EntityCargoRocket) {
                        GCLog.debug("Cargo rocket arrived at destination dimension, going into landing mode.");
                        e.func_70107_b((double)((float)this.targetVec.x + 0.5f), (double)(this.targetVec.y + 800), (double)((float)this.targetVec.z + 0.5f));
                        ((EntityCargoRocket)e).landing = true;
                    } else {
                        GCLog.info("Error: failed to recreate the cargo rocket in landing mode on target planet.");
                        e.func_70106_y();
                        this.func_70106_y();
                    }
                    return;
                }
                GCLog.info("Error: the server failed to load the dimension the cargo rocket is supposed to land in. Destroying rocket!");
                this.func_70106_y();
            } else {
                GCLog.debug("Cargo rocket going into landing mode in same destination.");
                this.func_70107_b((float)this.targetVec.x + 0.5f, this.targetVec.y + 800, (float)this.targetVec.z + 0.5f);
                this.landing = true;
            }
            return;
        }
        GCLog.info("Error: the cargo rocket failed to find a valid landing spot when it reached space.");
        this.func_70106_y();
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K && par1EntityPlayer instanceof EntityPlayerMP) {
            MarsUtil.openCargoRocketInventory((EntityPlayerMP)par1EntityPlayer, this);
        }
        return false;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Type", this.rocketType.getIndex());
        super.func_70014_b(nbt);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        super.func_70037_a(nbt);
    }

    @Override
    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public int func_70302_i_() {
        if (this.rocketType == null) {
            return 0;
        }
        return this.rocketType.getInventorySpace();
    }

    @Override
    public void onWorldTransferred(World world) {
        if (this.targetVec != null) {
            this.func_70107_b((float)this.targetVec.x + 0.5f, this.targetVec.y + 2, (float)this.targetVec.z + 0.5f);
            this.landing = true;
        } else {
            this.func_70106_y();
        }
    }

    @Override
    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    @Override
    public int getRocketTier() {
        return 2;
    }

    @Override
    public int getPreLaunchWait() {
        return 20;
    }

    @Override
    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItemList) {
        super.getItemsDropped(droppedItemList);
        ItemStack rocket = new ItemStack(MarsItems.spaceship, 1, this.rocketType.getIndex() + 10);
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItemList.add(rocket);
        return droppedItemList;
    }

    @Override
    public boolean isPlayerRocket() {
        return false;
    }

    @Override
    public double getOnPadYOffset() {
        return 0.0;
    }
}

