/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary.machine.stimulator;

import binnie.core.Mods;
import binnie.core.circuits.BinnieCircuit;
import binnie.extrabees.apiary.machine.stimulator.CircuitType;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.circuits.ICircuitLayout;

public class StimulatorCircuit
extends BinnieCircuit
implements IBeeModifier {
    protected CircuitType type;

    public StimulatorCircuit(CircuitType type, ICircuitLayout layout) {
        super("stimulator." + type.toString().toLowerCase(), 4, layout, Mods.forestry.item("thermionicTubes"), type.recipe);
        this.type = type;
    }

    public int getPowerUsage() {
        return this.type.power;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.type.getTerritoryModifier(genome, currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.type.getMutationModifier(genome, mate, currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.type.getLifespanModifier(genome, mate, currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.type.getProductionModifier(genome, currentModifier);
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.type.getFloweringModifier(genome, currentModifier);
    }

    public boolean isSealed() {
        return this.type.isSealed();
    }

    public boolean isSelfLighted() {
        return this.type.isSelfLighted();
    }

    public boolean isSunlightSimulated() {
        return this.type.isSunlightSimulated();
    }

    public boolean isHellish() {
        return this.type.isHellish();
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return this.type.getGeneticDecay(genome, currentModifier);
    }
}

