/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.gui.hud.modules.HUDExtractor;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.modules.abstractmodules.LogisticsSneakyDirectionModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.ExtractorModuleInHand;
import logisticspipes.network.guis.module.inpipe.ExtractorModuleSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.modules.ExtractorModuleMode;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class ModuleExtractor
extends LogisticsSneakyDirectionModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    private int currentTick = 0;
    private ForgeDirection _sneakyDirection = ForgeDirection.UNKNOWN;
    private final IHUDModuleRenderer HUD = new HUDExtractor(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();

    protected int ticksToAction() {
        return 20;
    }

    protected int itemsToExtract() {
        return 5;
    }

    protected int neededEnergy() {
        return 5;
    }

    protected CoreRoutedPipe.ItemSendMode itemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public ForgeDirection getSneakyDirection() {
        return this._sneakyDirection;
    }

    @Override
    public void setSneakyDirection(ForgeDirection sneakyDirection) {
        this._sneakyDirection = sneakyDirection;
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ExtractorModuleMode.class).setDirection(this._sneakyDirection).setModulePos(this), this.localModeWatchers);
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        return null;
    }

    @Override
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ExtractorModuleSlot.class).setSneakyOrientation(this.getSneakyDirection());
    }

    @Override
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ExtractorModuleInHand.class);
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("sneakydirection")) {
            this._sneakyDirection = ForgeDirection.values()[nbttagcompound.func_74762_e("sneakydirection")];
        } else if (nbttagcompound.func_74764_b("sneakyorientation")) {
            int t = nbttagcompound.func_74762_e("sneakyorientation");
            switch (t) {
                default: {
                    this._sneakyDirection = ForgeDirection.UNKNOWN;
                    break;
                }
                case 1: {
                    this._sneakyDirection = ForgeDirection.UP;
                    break;
                }
                case 2: {
                    this._sneakyDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    this._sneakyDirection = ForgeDirection.DOWN;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("sneakydirection", this._sneakyDirection.ordinal());
    }

    @Override
    public void tick() {
        if (++this.currentTick < this.ticksToAction()) {
            return;
        }
        this.currentTick = 0;
        IInventory realInventory = this._service.getRealInventory();
        if (realInventory == null) {
            return;
        }
        ForgeDirection extractOrientation = this._sneakyDirection;
        if (extractOrientation == ForgeDirection.UNKNOWN) {
            extractOrientation = this._service.inventoryOrientation().getOpposite();
        }
        IInventoryUtil targetUtil = this._service.getSneakyInventory(extractOrientation, true);
        block0: for (int i = 0; i < targetUtil.getSizeInventory(); ++i) {
            LinkedList<Integer> jamList;
            ItemIdentifier slotitem;
            Pair<Integer, SinkReply> reply;
            ItemStack slot = targetUtil.getStackInSlot(i);
            if (slot == null || (reply = this._service.hasDestination(slotitem = ItemIdentifier.get(slot), true, jamList = new LinkedList<Integer>())) == null) continue;
            int itemsleft = this.itemsToExtract();
            while (reply != null) {
                ItemStack stackToSend;
                int count = Math.min(itemsleft, slot.field_77994_a);
                count = Math.min(count, slotitem.getMaxStackSize());
                if (reply.getValue2().maxNumberOfItems > 0) {
                    count = Math.min(count, reply.getValue2().maxNumberOfItems);
                }
                while (!this._service.useEnergy(this.neededEnergy() * count) && count > 0) {
                    this._service.spawnParticle(Particles.OrangeParticle, 2);
                    --count;
                }
                if (count <= 0 || (stackToSend = targetUtil.decrStackSize(i, count)) == null || stackToSend.field_77994_a == 0) break block0;
                count = stackToSend.field_77994_a;
                this._service.sendStack(stackToSend, reply, this.itemSendMode());
                if ((itemsleft -= count) <= 0 || (slot = targetUtil.getStackInSlot(i)) == null) break block0;
                jamList.add(reply.getValue1());
                reply = this._service.hasDestination(ItemIdentifier.get(slot), true, jamList);
            }
            break;
        }
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("Extraction: " + (this._sneakyDirection == ForgeDirection.UNKNOWN ? "DEFAULT" : this._sneakyDirection.name()));
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ExtractorModuleMode.class).setDirection(this._sneakyDirection).setModulePos(this), this.localModeWatchers);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleExtractor");
    }
}

