/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.tileentity.TileEntityPhantomLight;
import de.keridos.floodlights.util.MathUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class TileEntityMetaFloodlight
extends TileEntityFL
implements ISidedInventory {
    protected boolean active;
    protected boolean wasActive = false;
    protected boolean update = true;
    protected int timeout;
    protected ItemStack[] inventory = new ItemStack[1];

    public void setRedstone(boolean b) {
        this.active = b ^ this.inverted;
        this.setState((byte)(this.active ? 1 : 0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void toggleInverted() {
        this.inverted = !this.inverted;
        this.active = !this.active;
        this.setState((byte)(this.active ? 1 : 0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean getWasActive() {
        return this.wasActive;
    }

    public void setWasActive(boolean wasActive) {
        this.wasActive = wasActive;
    }

    public void toggleUpdateRun() {
        this.update = true;
    }

    public void setLight(int x, int y, int z) {
        if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.blockUVLightBlock) {
            return;
        }
        if (this.field_145850_b.func_147449_b(x, y, z, ModBlocks.blockPhantomLight)) {
            TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
            if (tile instanceof TileEntityPhantomLight) {
                TileEntityPhantomLight light = (TileEntityPhantomLight)tile;
                light.addSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147458_c(x, y, z, x, y, z);
            }
            return;
        }
        this.toggleUpdateRun();
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        NBTTagList list;
        NBTTagCompound item;
        byte slot;
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("teMode")) {
            boolean bl = this.active = nbtTagCompound.func_74762_e("teMode") != 0;
        }
        if (nbtTagCompound.func_74764_b("wasActive")) {
            this.wasActive = nbtTagCompound.func_74767_n("wasActive");
        }
        if (nbtTagCompound.func_74764_b("Items") && (slot = (item = (list = nbtTagCompound.func_150295_c("Items", 10)).func_150305_b(0)).func_74771_c("Items")) >= 0 && slot < this.func_70302_i_()) {
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("wasActive", this.wasActive);
        nbtTagCompound.func_74774_a("teMode", this.state);
        NBTTagList list = new NBTTagList();
        ItemStack itemstack = this.func_70301_a(0);
        if (itemstack != null) {
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Items", (byte)0);
            itemstack.func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)list);
    }

    public int[] func_94128_d(int par1) {
        return new int[]{0};
    }

    public boolean func_145818_k_() {
        return false;
    }

    public String func_145825_b() {
        return "metaFloodlight";
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack itemstack = this.func_70301_a(slot);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(slot, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
                this.func_70296_d();
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemstack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return itemstack;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void straightSource(boolean remove) {
        for (int i = 1; i <= ConfigHandler.rangeStraightFloodlight; ++i) {
            TileEntityPhantomLight light;
            int x = this.field_145851_c + this.orientation.offsetX * i;
            int y = this.field_145848_d + this.orientation.offsetY * i;
            int z = this.field_145849_e + this.orientation.offsetZ * i;
            if (remove) {
                if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.blockPhantomLight) continue;
                light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                light.removeSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                continue;
            }
            if (this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
                this.setLight(x, y, z);
                continue;
            }
            if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.blockPhantomLight) {
                light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                light.addSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                continue;
            }
            if (this.field_145850_b.func_147439_a(x, y, z).func_149662_c()) break;
        }
    }

    public void wideConeSource(boolean remove) {
        boolean[] failedBeams = new boolean[9];
        if (!remove && this.field_145850_b.func_147439_a(this.field_145851_c + this.orientation.offsetX, this.field_145848_d + this.orientation.offsetY, this.field_145849_e + this.orientation.offsetZ).func_149662_c()) {
            return;
        }
        block20: for (int j = 0; j <= 16; ++j) {
            TileEntityPhantomLight light;
            int z;
            int y;
            int x;
            int[] rotatedCoords;
            int c;
            int b;
            int i;
            if (j <= 8) {
                for (i = 1; i <= ConfigHandler.rangeConeFloodlight / 4; ++i) {
                    b = 0;
                    c = 0;
                    switch (j) {
                        case 0: {
                            b += i;
                            break;
                        }
                        case 1: {
                            b -= i;
                            break;
                        }
                        case 2: {
                            c += i;
                            break;
                        }
                        case 3: {
                            c -= i;
                            break;
                        }
                        case 4: {
                            b += i;
                            c += i;
                            break;
                        }
                        case 5: {
                            b += i;
                            c -= i;
                            break;
                        }
                        case 6: {
                            b -= i;
                            c += i;
                            break;
                        }
                        case 7: {
                            b -= i;
                            c -= i;
                        }
                    }
                    rotatedCoords = MathUtil.rotate(i, b, c, this.orientation);
                    x = this.field_145851_c + rotatedCoords[0];
                    y = this.field_145848_d + rotatedCoords[1];
                    z = this.field_145849_e + rotatedCoords[2];
                    if (remove) {
                        if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.blockPhantomLight) continue;
                        light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                        light.removeSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        continue;
                    }
                    if (this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
                        this.setLight(x, y, z);
                        continue;
                    }
                    if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.blockPhantomLight) {
                        light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                        light.addSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        continue;
                    }
                    if (!this.field_145850_b.func_147439_a(x, y, z).func_149662_c()) continue;
                    if (i >= 4) continue block20;
                    failedBeams[j] = true;
                    continue block20;
                }
                continue;
            }
            if (failedBeams[j - 9] && !remove) continue;
            for (i = 4; i <= ConfigHandler.rangeConeFloodlight / 4; ++i) {
                b = 0;
                c = 0;
                switch (j) {
                    case 9: {
                        b += i / 2;
                        break;
                    }
                    case 10: {
                        b -= i / 2;
                        break;
                    }
                    case 11: {
                        c += i / 2;
                        break;
                    }
                    case 12: {
                        c -= i / 2;
                        break;
                    }
                    case 13: {
                        b += i / 2;
                        c += i / 2;
                        break;
                    }
                    case 14: {
                        b += i / 2;
                        c -= i / 2;
                        break;
                    }
                    case 15: {
                        b -= i / 2;
                        c += i / 2;
                        break;
                    }
                    case 16: {
                        b -= i / 2;
                        c -= i / 2;
                    }
                }
                rotatedCoords = MathUtil.rotate(i, b, c, this.orientation);
                x = this.field_145851_c + rotatedCoords[0];
                y = this.field_145848_d + rotatedCoords[1];
                z = this.field_145849_e + rotatedCoords[2];
                if (remove) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.blockPhantomLight) continue;
                    light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                    light.removeSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    continue;
                }
                if (this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
                    this.setLight(x, y, z);
                    continue;
                }
                if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.blockPhantomLight) {
                    light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                    light.addSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    continue;
                }
                if (this.field_145850_b.func_147439_a(x, y, z).func_149662_c()) continue block20;
            }
        }
    }

    public void narrowConeSource(boolean remove) {
        boolean[] failedBeams = new boolean[9];
        block20: for (int j = 0; j <= 16; ++j) {
            TileEntityPhantomLight light;
            int z;
            int y;
            int x;
            int[] rotatedCoords;
            int c;
            int b;
            int a;
            int i;
            if (j <= 8) {
                for (i = 1; i <= ConfigHandler.rangeConeFloodlight; ++i) {
                    if (i == 1) {
                        TileEntityPhantomLight light2;
                        int x2 = this.field_145851_c + this.orientation.offsetX;
                        int y2 = this.field_145848_d + this.orientation.offsetY;
                        int z2 = this.field_145849_e + this.orientation.offsetZ;
                        if (remove) {
                            if (this.field_145850_b.func_147439_a(x2, y2, z2) == ModBlocks.blockPhantomLight) {
                                light2 = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x2, y2, z2);
                                light2.removeSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            }
                        } else if (this.field_145850_b.func_147439_a(x2, y2, z2).isAir((IBlockAccess)this.field_145850_b, x2, y2, z2)) {
                            this.setLight(x2, y2, z2);
                        } else if (this.field_145850_b.func_147439_a(x2, y2, z2) == ModBlocks.blockPhantomLight) {
                            light2 = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x2, y2, z2);
                            light2.addSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        } else if (this.field_145850_b.func_147439_a(x2, y2, z2).func_149662_c()) {
                            return;
                        }
                    }
                    a = i;
                    b = 0;
                    c = 0;
                    switch (j) {
                        case 0: {
                            b += i / 2;
                            break;
                        }
                        case 1: {
                            b -= i / 2;
                            break;
                        }
                        case 2: {
                            c += i / 2;
                            break;
                        }
                        case 3: {
                            c -= i / 2;
                            break;
                        }
                        case 4: {
                            b += i / 2;
                            c += i / 2;
                            break;
                        }
                        case 5: {
                            b += i / 2;
                            c -= i / 2;
                            break;
                        }
                        case 6: {
                            b -= i / 2;
                            c += i / 2;
                            break;
                        }
                        case 7: {
                            b -= i / 2;
                            c -= i / 2;
                        }
                    }
                    rotatedCoords = MathUtil.rotate(a, b, c, this.orientation);
                    x = this.field_145851_c + rotatedCoords[0];
                    y = this.field_145848_d + rotatedCoords[1];
                    z = this.field_145849_e + rotatedCoords[2];
                    if (remove) {
                        if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.blockPhantomLight) continue;
                        light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                        light.removeSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        continue;
                    }
                    if (this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
                        this.setLight(x, y, z);
                        continue;
                    }
                    if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.blockPhantomLight) {
                        light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                        light.addSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        continue;
                    }
                    if (!this.field_145850_b.func_147439_a(x, y, z).func_149662_c()) continue;
                    if (i >= 8) continue block20;
                    failedBeams[j] = true;
                    continue block20;
                }
                continue;
            }
            if (failedBeams[j - 9] && !remove) continue;
            for (i = 8; i <= ConfigHandler.rangeConeFloodlight; ++i) {
                a = i;
                b = 0;
                c = 0;
                switch (j) {
                    case 9: {
                        b += i / 4;
                        break;
                    }
                    case 10: {
                        b -= i / 4;
                        break;
                    }
                    case 11: {
                        c += i / 4;
                        break;
                    }
                    case 12: {
                        c -= i / 4;
                        break;
                    }
                    case 13: {
                        b += i / 4;
                        c += i / 4;
                        break;
                    }
                    case 14: {
                        b += i / 4;
                        c -= i / 4;
                        break;
                    }
                    case 15: {
                        b -= i / 4;
                        c += i / 4;
                        break;
                    }
                    case 16: {
                        b -= i / 4;
                        c -= i / 4;
                    }
                }
                rotatedCoords = MathUtil.rotate(a, b, c, this.orientation);
                x = this.field_145851_c + rotatedCoords[0];
                y = this.field_145848_d + rotatedCoords[1];
                z = this.field_145849_e + rotatedCoords[2];
                if (remove) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.blockPhantomLight) continue;
                    light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                    light.removeSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    continue;
                }
                if (this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
                    this.setLight(x, y, z);
                    continue;
                }
                if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.blockPhantomLight) {
                    light = (TileEntityPhantomLight)this.field_145850_b.func_147438_o(x, y, z);
                    light.addSource(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    continue;
                }
                if (this.field_145850_b.func_147439_a(x, y, z).func_149662_c()) continue block20;
            }
        }
    }
}

