/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class ItemWandCastingVisitor
extends ClassVisitor {
    public ItemWandCastingVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("getFocus".equals(name) && "(Lnet/minecraft/item/ItemStack;)Lthaumcraft/api/wands/ItemFocusBasic;".equals(desc) || "getFocusItem".equals(name) && "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;".equals(desc)) {
            TC4Transformer.log.debug("Visiting method {}", new Object[]{name});
            return new LoadItemStackNullCheckVisitor(this.api, mv);
        }
        return mv;
    }

    private static class LoadItemStackNullCheckVisitor
    extends MethodVisitor {
        private Label elseBranchStart = null;

        public LoadItemStackNullCheckVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (this.elseBranchStart == null) {
                this.elseBranchStart = label;
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (opcode == 184 && "net/minecraft/item/ItemStack".equals(owner) && ("func_77949_a".equals(name) || "loadItemStackFromNBT".equals(name)) && "(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/item/ItemStack;".equals(desc)) {
                TC4Transformer.log.trace("Adding null check");
                this.mv.visitInsn(89);
                Label branchNonnull = new Label();
                this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "isValidFocusItemStack", "(Lnet/minecraft/item/ItemStack;)Z", false);
                this.mv.visitJumpInsn(154, branchNonnull);
                this.mv.visitInsn(87);
                this.mv.visitJumpInsn(167, this.elseBranchStart);
                this.mv.visitLabel(branchNonnull);
            }
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(3, maxLocals);
        }
    }
}

