/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.veintypes;

import com.google.common.collect.ImmutableList;
import com.sinthoras.visualprospecting.database.veintypes.GregTechOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.IOreMaterialProvider;
import gregtech.api.enums.Materials;
import gregtech.common.OreMixBuilder;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class VeinType {
    public static final int veinHeight = 9;
    public final String name;
    public short veinId;
    public final IOreMaterialProvider oreMaterialProvider;
    public final int blockSize;
    public final short primaryOreMeta;
    public final short secondaryOreMeta;
    public final short inBetweenOreMeta;
    public final short sporadicOreMeta;
    public final int minBlockY;
    public final int maxBlockY;
    private final ShortSet oresAsSet = new ShortArraySet();
    private final List<String> allowedDims = new ArrayList<String>();
    private boolean isHighlighted = true;
    private final String localizedName;
    public static final VeinType NO_VEIN = new VeinType("ore.mix.none", new GregTechOreMaterialProvider(Materials._NULL), 0, -1, -1, -1, -1, 0, 0, "");

    public VeinType(String name, IOreMaterialProvider oreMaterialProvider, int blockSize, short primaryOreMeta, short secondaryOreMeta, short inBetweenOreMeta, short sporadicOreMeta, int minBlockY, int maxBlockY, String dimName) {
        this.name = name;
        this.oreMaterialProvider = oreMaterialProvider;
        this.blockSize = blockSize;
        this.minBlockY = Math.max(0, minBlockY);
        this.maxBlockY = Math.min(255, maxBlockY);
        this.primaryOreMeta = primaryOreMeta;
        this.oresAsSet.add(this.primaryOreMeta);
        this.secondaryOreMeta = secondaryOreMeta;
        this.oresAsSet.add(this.secondaryOreMeta);
        this.inBetweenOreMeta = inBetweenOreMeta;
        this.oresAsSet.add(this.inBetweenOreMeta);
        this.sporadicOreMeta = sporadicOreMeta;
        this.oresAsSet.add(this.sporadicOreMeta);
        this.localizedName = oreMaterialProvider.getLocalizedName();
        this.allowedDims.add(dimName);
    }

    public VeinType(OreMixBuilder oreMix) {
        this.name = oreMix.oreMixName;
        this.oreMaterialProvider = new GregTechOreMaterialProvider(oreMix.representative);
        this.localizedName = oreMix.localizedName;
        this.blockSize = oreMix.size;
        this.primaryOreMeta = (short)oreMix.primary.mMetaItemSubID;
        this.oresAsSet.add(this.primaryOreMeta);
        this.secondaryOreMeta = (short)oreMix.secondary.mMetaItemSubID;
        this.oresAsSet.add(this.secondaryOreMeta);
        this.inBetweenOreMeta = (short)oreMix.between.mMetaItemSubID;
        this.oresAsSet.add(this.inBetweenOreMeta);
        this.sporadicOreMeta = (short)oreMix.sporadic.mMetaItemSubID;
        this.oresAsSet.add(this.sporadicOreMeta);
        this.minBlockY = Math.max(0, oreMix.minY - 6);
        this.maxBlockY = Math.min(255, oreMix.maxY - 6);
        this.allowedDims.addAll(oreMix.dimsEnabled.keySet());
    }

    public boolean containsAllFoundOres(ShortCollection foundOres, String dimName, short specificMeta, int minY) {
        return !(minY < this.minBlockY || this.primaryOreMeta != specificMeta && this.secondaryOreMeta != specificMeta || !dimName.isEmpty() && !this.allowedDims.contains(dimName) || !this.oresAsSet.containsAll(foundOres));
    }

    public boolean matchesWithSpecificPrimaryOrSecondary(ShortCollection foundOres, String dimName, short specificMeta) {
        return !(this.primaryOreMeta != specificMeta && this.secondaryOreMeta != specificMeta || !dimName.isEmpty() && !this.allowedDims.contains(dimName) || !foundOres.containsAll((ShortCollection)this.oresAsSet));
    }

    public boolean canOverlapIntoNeighborOreChunk() {
        return this.blockSize > 24;
    }

    public boolean canOverlapIntoNeighborOreChunkAtCoordinateAxis() {
        return this.blockSize > 16;
    }

    public boolean containsOre(short oreMetaData) {
        return this.primaryOreMeta == oreMetaData || this.secondaryOreMeta == oreMetaData || this.inBetweenOreMeta == oreMetaData || this.sporadicOreMeta == oreMetaData;
    }

    public ImmutableList<String> getOreMaterialNames() {
        return this.oreMaterialProvider.getContainedOres((ShortCollection)this.oresAsSet);
    }

    public String getVeinName() {
        return this.localizedName;
    }

    public ShortSet getOresAtLayer(int layerBlockY) {
        ShortOpenHashSet result = new ShortOpenHashSet();
        switch (layerBlockY) {
            case 0: 
            case 1: 
            case 2: {
                result.add(this.secondaryOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
            case 3: {
                result.add(this.secondaryOreMeta);
                result.add(this.inBetweenOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
            case 4: {
                result.add(this.inBetweenOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
            case 5: 
            case 6: {
                result.add(this.primaryOreMeta);
                result.add(this.inBetweenOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
            case 7: 
            case 8: {
                result.add(this.primaryOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
        }
        return result;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void setNEISearchHighlight(boolean isHighlighted) {
        this.isHighlighted = isHighlighted;
    }
}

