/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockGrass;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LittleTileBlock
extends LittleTile {
    public Block block;
    public int meta;

    public LittleTileBlock(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public LittleTileBlock(Block block) {
        this(block, 0);
    }

    public LittleTileBlock() {
    }

    @Override
    public void saveTileExtra(NBTTagCompound nbt) {
        nbt.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.block));
        nbt.func_74768_a("meta", this.meta);
    }

    @Override
    public void loadTileExtra(NBTTagCompound nbt) {
        this.block = Block.func_149684_b((String)nbt.func_74779_i("block"));
        this.meta = nbt.func_74762_e("meta");
        if (this.block == null || this.block instanceof BlockAir) {
            throw new IllegalArgumentException("Invalid block name! name=" + nbt.func_74779_i("block"));
        }
    }

    @Override
    public ForgeDirection[] getValidRotation() {
        return null;
    }

    @Override
    public void copyExtra(LittleTile tile) {
        if (tile instanceof LittleTileBlock) {
            LittleTileBlock thisTile = (LittleTileBlock)tile;
            thisTile.block = this.block;
            thisTile.meta = this.meta;
        }
    }

    @Override
    public ItemStack getDrop() {
        ItemStack stack = new ItemStack((Block)LittleTiles.blockTile);
        stack.field_77990_d = new NBTTagCompound();
        this.saveTile(stack.field_77990_d);
        ((LittleTileBox)this.boundingBoxes.get(0)).getSize().writeToNBT("size", stack.field_77990_d);
        return stack;
    }

    @Override
    public ArrayList<CubeObject> getRenderingCubes() {
        ArrayList<CubeObject> cubes = new ArrayList<CubeObject>();
        for (LittleTileBox boundingBox : this.boundingBoxes) {
            CubeObject cube = boundingBox.getCube();
            cube.block = this.block;
            cube.meta = this.meta;
            cubes.add(cube);
        }
        return cubes;
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack) {
        super.onPlaced(player, stack);
        try {
            this.block.func_149689_a(this.te.func_145831_w(), this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e, (EntityLivingBase)player, stack);
            this.block.func_149714_e(this.te.func_145831_w(), this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e, this.meta);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Block.SoundType getSound() {
        return this.block.field_149762_H;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.block.func_149691_a(side, this.meta);
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        this.block.func_149734_b(world, x, y, z, random);
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float moveX, float moveY, float moveZ) {
        if (super.onBlockActivated(world, x, y, z, player, side, moveX, moveY, moveZ)) {
            return true;
        }
        return this.block.func_149727_a(world, x, y, z, player, side, moveX, moveY, moveZ);
    }

    @Override
    public void place() {
        super.place();
        this.block.func_149726_b(this.te.func_145831_w(), this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e);
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.block.func_149750_m();
    }

    @Override
    public double getEnchantPowerBonus(World world, int x, int y, int z) {
        return this.block.getEnchantPowerBonus(world, x, y, z);
    }

    @Override
    public boolean canBeCombined(LittleTile tile) {
        if (super.canBeCombined(tile) && tile instanceof LittleTileBlock) {
            return this.block == ((LittleTileBlock)tile).block && this.meta == ((LittleTileBlock)tile).meta;
        }
        return false;
    }

    @Override
    public boolean canBlockBeThreaded() {
        if (LittleTiles.isAngelicaLoaded) {
            return false;
        }
        return this.block.func_149645_b() == 0 && !(this.block instanceof BlockGrass);
    }

    @Override
    protected boolean canSawResize(ForgeDirection direction, EntityPlayer player) {
        return true;
    }
}

