/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mariculture.handlers;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mariculture.MaricultureHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mariculture.Crucible")
public class Crucible {
    public static final String nameSmelting = "Mariculture Crucible (Smelting)";
    public static final String nameFuel = "Mariculture Crucible (Fuel)";

    @ZenMethod
    public static void addRecipe(int temp, IItemStack input, ILiquidStack fluid, @Optional IItemStack output, @Optional int chance) {
        ItemStack out = output != null ? InputHelper.toStack(output) : null;
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(new RecipeSmelter(InputHelper.toStack(input), null, temp, InputHelper.toFluid(fluid), out, chance)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<RecipeSmelter> recipes = new LinkedList<RecipeSmelter>();
        for (RecipeSmelter r : MaricultureHandlers.crucible.getRecipes()) {
            if (r == null || r.input == null || !StackHelper.matches(input, InputHelper.toIItemStack(r.input))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored", nameSmelting, input.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(IItemStack input, int max, int per, int time) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(InputHelper.toStack(input), new FuelInfo(max, per, time)));
    }

    @ZenMethod
    public static void addFuel(ILiquidStack input, int max, int per, int time) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(InputHelper.toFluid(input), new FuelInfo(max, per, time)));
    }

    @ZenMethod
    public static void addFuel(String input, int max, int per, int time) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuel((Object)input, new FuelInfo(max, per, time)));
    }

    @ZenMethod
    public static void removeFuel(IItemStack fuel) {
        Crucible.removeFuelEntry(fuel);
    }

    @ZenMethod
    public static void removeFuel(ILiquidStack fuel) {
        Crucible.removeFuelEntry(fuel);
    }

    @ZenMethod
    public static void removeFuel(String fuel) {
        Crucible.removeFuelEntry(fuel);
    }

    public static void removeFuelEntry(Object o) {
        String key = MaricultureHelper.getKey(o);
        HashMap<Object, FuelInfo> recipes = new HashMap<Object, FuelInfo>();
        for (Map.Entry<Object, FuelInfo> entry : MaricultureHelper.fuels.entrySet()) {
            if (!key.matches((String)entry.getKey())) continue;
            recipes.put(key, entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(recipes));
        }
    }

    private static class RemoveFuel
    extends BaseMapRemoval<Object, FuelInfo> {
        public RemoveFuel(Map<Object, FuelInfo> recipes) {
            super(Crucible.nameFuel, MaricultureHelper.fuels, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<Object, FuelInfo> recipe) {
            return (String)recipe.getKey();
        }
    }

    private static class AddFuel
    extends BaseMapAddition<Object, FuelInfo> {
        public AddFuel(Object o, FuelInfo info) {
            super(Crucible.nameFuel, MaricultureHelper.fuels);
            this.recipes.put(MaricultureHelper.getKey(o), info);
        }

        @Override
        public String getRecipeInfo(Map.Entry<Object, FuelInfo> recipe) {
            return (String)recipe.getKey();
        }
    }

    private static class RemoveRecipe
    extends BaseListRemoval<RecipeSmelter> {
        public RemoveRecipe(List<RecipeSmelter> recipes) {
            super(Crucible.nameSmelting, MaricultureHandlers.crucible.getRecipes(), recipes);
        }

        @Override
        public String getRecipeInfo(RecipeSmelter recipe) {
            return LogHelper.getStackDescription(recipe.input);
        }
    }

    private static class AddRecipe
    extends BaseListAddition<RecipeSmelter> {
        public AddRecipe(RecipeSmelter recipe) {
            super(Crucible.nameSmelting, MaricultureHandlers.crucible.getRecipes());
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(RecipeSmelter recipe) {
            return LogHelper.getStackDescription(recipe.input);
        }
    }
}

