/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;

public class LokiCursor {
    private static final String TAG_X_OFFSET = "xOffset";
    private static final String TAG_Y_OFFSET = "yOffset";
    private static final String TAG_Z_OFFSET = "zOffset";
    private static final String TAG_MIRROR_MODE = "mirror";
    private static final byte xAxisBitmask = 4;
    private static final byte yAxisBitmask = 2;
    private static final byte zAxisBitmask = 1;
    private byte mirrorMode;
    private ChunkCoordinates coordinates;

    public LokiCursor(int x, int y, int z, byte mode) {
        this.coordinates = new ChunkCoordinates(x, y, z);
        this.mirrorMode = mode;
    }

    public static LokiCursor fromNBT(NBTTagCompound cmp) {
        int x = cmp.func_74762_e(TAG_X_OFFSET);
        int y = cmp.func_74762_e(TAG_Y_OFFSET);
        int z = cmp.func_74762_e(TAG_Z_OFFSET);
        byte mirror = cmp.func_74771_c(TAG_MIRROR_MODE);
        return new LokiCursor(x, y, z, mirror);
    }

    public static boolean isMirrorX(byte mirrorMode) {
        return (mirrorMode & 4) > 0;
    }

    public static boolean isMirrorY(byte mirrorMode) {
        return (mirrorMode & 2) > 0;
    }

    public static boolean isMirrorZ(byte mirrorMode) {
        return (mirrorMode & 1) > 0;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.func_74768_a(TAG_X_OFFSET, this.coordinates.field_71574_a);
        cmp.func_74768_a(TAG_Y_OFFSET, this.coordinates.field_71572_b);
        cmp.func_74768_a(TAG_Z_OFFSET, this.coordinates.field_71573_c);
        cmp.func_74768_a(TAG_MIRROR_MODE, (int)this.mirrorMode);
        return cmp;
    }

    public int getX() {
        return this.coordinates.field_71574_a;
    }

    public int getY() {
        return this.coordinates.field_71572_b;
    }

    public int getZ() {
        return this.coordinates.field_71573_c;
    }

    public ChunkCoordinates getCoordinates() {
        return this.coordinates;
    }

    public boolean isMirrorX() {
        return LokiCursor.isMirrorX(this.mirrorMode);
    }

    public boolean isMirrorY() {
        return LokiCursor.isMirrorY(this.mirrorMode);
    }

    public boolean isMirrorZ() {
        return LokiCursor.isMirrorZ(this.mirrorMode);
    }

    public boolean isMirror() {
        return this.mirrorMode != 0;
    }
}

