/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.BiFunction;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.lib.util.IStringSerializable;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.misc.NameMap;

public enum EnumTeamStatus implements IStringSerializable
{
    ENEMY(-10, "enemy", EnumChatFormatting.RED, true),
    NONE(0, "none", EnumChatFormatting.WHITE, true),
    INVITED(10, "invited", EnumChatFormatting.DARK_AQUA, true),
    ALLY(30, "ally", EnumChatFormatting.DARK_GREEN, true),
    MEMBER(50, "member", EnumChatFormatting.BLUE, false),
    MOD(80, "mod", EnumChatFormatting.BLUE, true),
    OWNER(100, "owner", EnumChatFormatting.GOLD, false);

    public static final EnumTeamStatus[] VALUES;
    public static final BiFunction<ICommandSender, EnumTeamStatus, IChatComponent> NAME_GETTER;
    public static final NameMap<EnumTeamStatus> NAME_MAP;
    public static final NameMap<EnumTeamStatus> NAME_MAP_PERMS;
    public static final Collection<EnumTeamStatus> VALID_VALUES;
    private final String name;
    private final int status;
    private final EnumChatFormatting color;
    private final String langKey;
    private final boolean canBeSet;

    private EnumTeamStatus(int s, String n2, EnumChatFormatting c, boolean cs) {
        this.name = n2;
        this.status = s;
        this.color = c;
        this.langKey = "serverutilities.lang.team_status." + this.name;
        this.canBeSet = cs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getStatus() {
        return this.status;
    }

    public EnumChatFormatting getColor() {
        return this.color;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public boolean canBeSet() {
        return this.canBeSet;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean isEqualOrGreaterThan(EnumTeamStatus s) {
        return this.status >= s.status;
    }

    public String toString() {
        return this.getName();
    }

    static {
        VALUES = EnumTeamStatus.values();
        NAME_GETTER = (sender, value) -> StringUtils.color(ServerUtilities.lang(sender, value.getLangKey(), new Object[0]), value.getColor());
        NAME_MAP = NameMap.createWithName(NONE, NAME_GETTER, VALUES);
        NAME_MAP_PERMS = NameMap.createWithName(ALLY, NAME_GETTER, NONE, ALLY, MEMBER);
        VALID_VALUES = new LinkedHashSet<EnumTeamStatus>();
        for (EnumTeamStatus s : VALUES) {
            if (!s.canBeSet) continue;
            VALID_VALUES.add(s);
        }
    }
}

