/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.misc.URIHandlers;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.FormattingTag;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.core.BetterQuesting;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class PanelTextBox
implements IGuiPanel {
    private static final Pattern TOKEN_DELIMITER = Pattern.compile("(?=\\[)|(?=\u00a7.)|(?<=])|(?<=\u00a7.)");
    private static final Pattern COLOUR_FORMATTING_CODE_PATTERN = Pattern.compile("\u00a7[0-9a-f]");
    private static final String FORMATTING_CODE_RESET = "\u00a7r";
    private static final String defaultUrlProtocol = "https";
    private static final Set<String> supportedUrlProtocol = ImmutableSet.of((Object)"http", (Object)"https");
    private final GuiRectText transform;
    private final List<UrlRange> urlRanges = new ArrayList<UrlRange>();
    private final List<HotZone> hotZones = new ArrayList<HotZone>();
    private boolean enabled = true;
    private String text = "";
    private boolean shadow = false;
    private IGuiColor color = new GuiColorStatic(255, 255, 255, 255);
    private final boolean autoFit;
    private int align = 0;
    private int fontScale = 12;
    private int lines = 1;
    private boolean hyperlinkAware;

    public PanelTextBox(IGuiRect rect, String text) {
        this(rect, text, false);
    }

    public PanelTextBox(IGuiRect rect, String text, boolean autoFit) {
        this(rect, text, autoFit, false);
    }

    public PanelTextBox(IGuiRect rect, String text, boolean autoFit, boolean hyperlinkAware) {
        this.transform = new GuiRectText(rect, autoFit);
        this.autoFit = autoFit;
        this.hyperlinkAware = hyperlinkAware;
        this.setText(text);
    }

    public boolean isHyperlinkAware() {
        return this.hyperlinkAware;
    }

    public PanelTextBox setHyperlinkAware(boolean hyperlinkAware) {
        this.hyperlinkAware = hyperlinkAware;
        this.bakeHotZones(null);
        return this;
    }

    public PanelTextBox setText(String text) {
        if (this.hyperlinkAware) {
            StringBuilder textBuilder = new StringBuilder();
            this.urlRanges.clear();
            int currUrlStart = -1;
            ArrayDeque<FormattingTag.TagInstance> tags = new ArrayDeque<FormattingTag.TagInstance>();
            Scanner scanner = new Scanner(text).useDelimiter(TOKEN_DELIMITER);
            while (scanner.hasNext()) {
                String token = scanner.next();
                if (token.equals(FORMATTING_CODE_RESET)) {
                    textBuilder.append(FORMATTING_CODE_RESET);
                    tags.descendingIterator().forEachRemaining(t -> textBuilder.append(t.getTag().getColourFormattingString()));
                    tags.descendingIterator().forEachRemaining(t -> textBuilder.append(t.getTag().getTextFormattingString()));
                    continue;
                }
                if (COLOUR_FORMATTING_CODE_PATTERN.matcher(token).matches()) {
                    textBuilder.append(token);
                    tags.descendingIterator().forEachRemaining(t -> textBuilder.append(t.getTag().getTextFormattingString()));
                    continue;
                }
                Optional<FormattingTag.TagInstance> openingTagOptional = FormattingTag.parseOpeningTag(token);
                if (openingTagOptional.isPresent()) {
                    FormattingTag.TagInstance openingTag = openingTagOptional.get();
                    tags.push(openingTag);
                    textBuilder.append(openingTag.getTag().getColourFormattingString());
                    tags.descendingIterator().forEachRemaining(t -> textBuilder.append(t.getTag().getTextFormattingString()));
                    if (openingTag.getTag() != FormattingTag.URL) continue;
                    currUrlStart = textBuilder.length();
                    continue;
                }
                Optional<FormattingTag> closingTagOptional = FormattingTag.parseClosingTag(token);
                if (closingTagOptional.isPresent()) {
                    FormattingTag closingTag = closingTagOptional.get();
                    if (tags.isEmpty() || closingTag != ((FormattingTag.TagInstance)tags.peek()).getTag()) continue;
                    FormattingTag.TagInstance openingTag = (FormattingTag.TagInstance)tags.pop();
                    if (closingTag == FormattingTag.URL && currUrlStart >= 0) {
                        String url = (String)openingTag.getParams().getOrDefault((Object)"link", (Object)textBuilder.substring(currUrlStart));
                        this.urlRanges.add(new UrlRange(currUrlStart, textBuilder.length(), url));
                        currUrlStart = -1;
                    }
                    textBuilder.append(FORMATTING_CODE_RESET);
                    tags.descendingIterator().forEachRemaining(t -> textBuilder.append(t.getTag().getColourFormattingString()));
                    tags.descendingIterator().forEachRemaining(t -> textBuilder.append(t.getTag().getTextFormattingString()));
                    continue;
                }
                textBuilder.append(token);
            }
            this.text = textBuilder.toString();
        } else {
            this.text = text;
        }
        IGuiRect bounds = this.getTransform();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        if (this.autoFit) {
            float scale = (float)this.fontScale / 12.0f;
            List<String> sl = RenderUtils.splitStringWithoutFormat(this.text, (int)Math.floor((float)bounds.getWidth() / scale / BQ_Settings.textWidthCorrection), fr);
            this.lines = sl.size() - 1;
            this.transform.h = fr.field_78288_b * sl.size();
            this.bakeHotZones(sl);
        } else {
            this.lines = bounds.getHeight() / fr.field_78288_b - 1;
        }
        return this;
    }

    private void bakeHotZones(List<String> lines) {
        this.hotZones.clear();
        if (!this.isHyperlinkAware()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.text)) {
            return;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        IGuiRect fullbox = this.getTransform();
        if (lines == null) {
            float scale = (float)this.fontScale / 12.0f;
            lines = RenderUtils.splitStringWithoutFormat(this.text, (int)Math.floor((float)fullbox.getWidth() / scale / BQ_Settings.textWidthCorrection), fr);
        }
        block0: for (UrlRange urlRange : this.urlRanges) {
            String url = urlRange.url;
            int start = urlRange.start;
            int end = urlRange.end;
            int currentPos = 0;
            boolean foundUrlStart = false;
            int lineIndex = 0;
            int lineCount = lines.size();
            while (lineIndex < lineCount) {
                String line = lines.get(lineIndex);
                if (!foundUrlStart) {
                    if (start < currentPos + line.length()) {
                        int left = RenderUtils.getStringWidth(line.substring(0, start - currentPos), fr);
                        if (end <= currentPos + line.length()) {
                            int right = RenderUtils.getStringWidth(line.substring(0, end - currentPos), fr);
                            GuiTransform location = new GuiTransform(GuiAlign.FULL_BOX, left, fr.field_78288_b * lineIndex, right - left, fr.field_78288_b, 0);
                            location.setParent(fullbox);
                            this.hotZones.add(new HotZone(location, url));
                            continue block0;
                        }
                        foundUrlStart = true;
                        GuiTransform location = new GuiTransform(GuiAlign.FULL_BOX, left, fr.field_78288_b * lineIndex, fullbox.getWidth(), fr.field_78288_b, 0);
                        location.setParent(fullbox);
                        this.hotZones.add(new HotZone(location, url));
                    }
                } else {
                    if (end <= currentPos + line.length()) {
                        GuiTransform location = new GuiTransform(GuiAlign.FULL_BOX, 0, fr.field_78288_b * lineIndex, RenderUtils.getStringWidth(line.substring(0, end - currentPos), fr), fr.field_78288_b, 0);
                        location.setParent(fullbox);
                        this.hotZones.add(new HotZone(location, url));
                        continue block0;
                    }
                    GuiTransform location = new GuiTransform(GuiAlign.FULL_BOX, 0, fr.field_78288_b * lineIndex, fullbox.getWidth(), fr.field_78288_b, 0);
                    location.setParent(fullbox);
                    this.hotZones.add(new HotZone(location, url));
                }
                currentPos += lines.get(lineIndex++).length();
            }
        }
    }

    public PanelTextBox setColor(IGuiColor color) {
        this.color = color;
        return this;
    }

    public PanelTextBox setAlignment(int align) {
        this.align = MathHelper.func_76125_a((int)align, (int)0, (int)2);
        return this;
    }

    public PanelTextBox setFontSize(int size) {
        this.fontScale = size;
        return this;
    }

    public PanelTextBox enableShadow(boolean enable) {
        this.shadow = enable;
        return this;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void initPanel() {
        IGuiRect bounds = this.getTransform();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        float scale = (float)this.fontScale / 12.0f;
        if (!this.autoFit) {
            this.lines = (int)Math.floor((float)bounds.getHeight() / ((float)fr.field_78288_b * scale)) - 1;
            return;
        }
        List<String> sl = RenderUtils.splitStringWithoutFormat(this.text, (int)Math.floor((float)bounds.getWidth() / scale / BQ_Settings.textWidthCorrection), fr);
        this.lines = sl.size() - 1;
        this.bakeHotZones(sl);
        this.transform.h = (int)Math.floor((float)(fr.field_78288_b * sl.size()) * scale);
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        IGuiRect bounds = this.getTransform();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        float s = (float)this.fontScale / 12.0f;
        int w = (int)Math.ceil((float)RenderUtils.getStringWidth(this.text, fr) * s);
        int bw = (int)Math.floor((float)bounds.getWidth() / s / BQ_Settings.textWidthCorrection);
        if (bw <= 0) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)bounds.getX(), (float)bounds.getY(), (float)1.0f);
        GL11.glScalef((float)s, (float)s, (float)1.0f);
        if (this.align == 2 && bw >= w) {
            RenderUtils.drawSplitString(fr, this.text, bw - w, 0, bw, this.color.getRGB(), this.shadow, 0, this.lines);
        } else if (this.align == 1 && bw >= w) {
            RenderUtils.drawSplitString(fr, this.text, bw / 2 - w / 2, 0, bw, this.color.getRGB(), this.shadow, 0, this.lines);
        } else {
            RenderUtils.drawSplitString(fr, this.text, 0, 0, bw, this.color.getRGB(), this.shadow, 0, this.lines);
        }
        if (BQ_Settings.urlDebug) {
            int hotZonesSize = this.hotZones.size();
            for (int i = 0; i < hotZonesSize; ++i) {
                RenderUtils.drawHighlightBox(this.hotZones.get((int)i).location, new GuiColorStatic(i % 3 == 0 ? 255 : 0, i % 3 == 1 ? 255 : 0, i % 3 == 2 ? 255 : 0, 255));
            }
        }
        GL11.glPopMatrix();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        int mxt = mx + this.getTransform().getX();
        int myt = my + this.getTransform().getY();
        for (HotZone hotZone : this.hotZones) {
            URI uri;
            if (!hotZone.location.contains(mxt, myt)) continue;
            try {
                URI tmp = new URI(hotZone.url);
                if (tmp.getScheme() == null) {
                    tmp = new URI("https://" + hotZone.url);
                }
                uri = tmp;
            }
            catch (URISyntaxException ex) {
                return false;
            }
            Predicate<URI> handler = URIHandlers.get(uri.getScheme());
            if (handler == null) {
                return false;
            }
            return handler.test(uri);
        }
        return false;
    }

    private static void openURL(URI p_146407_1_) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, p_146407_1_);
        }
        catch (Throwable throwable) {
            BetterQuesting.logger.error("Couldn't open link", throwable);
        }
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        return false;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }

    private static class GuiRectText
    implements IGuiRect {
        private final IGuiRect proxy;
        private final boolean useH;
        private int h;

        public GuiRectText(IGuiRect proxy, boolean useH) {
            this.proxy = proxy;
            this.useH = useH;
        }

        @Override
        public int getX() {
            return this.proxy.getX();
        }

        @Override
        public int getY() {
            return this.proxy.getY();
        }

        @Override
        public int getWidth() {
            return this.proxy.getWidth();
        }

        @Override
        public int getHeight() {
            return this.useH ? this.h : this.proxy.getHeight();
        }

        @Override
        public int getDepth() {
            return this.proxy.getDepth();
        }

        @Override
        public IGuiRect getParent() {
            return this.proxy.getParent();
        }

        @Override
        public void setParent(IGuiRect rect) {
            this.proxy.setParent(rect);
        }

        @Override
        public boolean contains(int x, int y) {
            int x1 = this.getX();
            int x2 = x1 + this.getWidth();
            int y1 = this.getY();
            int y2 = y1 + this.getHeight();
            return x >= x1 && x < x2 && y >= y1 && y < y2;
        }

        @Override
        public int compareTo(IGuiRect o) {
            return this.proxy.compareTo(o);
        }
    }

    private static class UrlRange {
        final int start;
        final int end;
        final String url;

        public UrlRange(int start, int end, String url) {
            this.start = start;
            this.end = end;
            this.url = url;
        }
    }

    private static class HotZone {
        final IGuiRect location;
        final String url;

        public HotZone(IGuiRect location, String url) {
            this.location = location;
            this.url = url;
        }
    }
}

