/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.EnumUtils;

public class ConfigMigrator {
    private Configuration config;
    private List<String> warnings = new ArrayList<String>();

    public ConfigMigrator(Configuration config) {
        this.config = config;
    }

    public void writeWarnings() {
        if (this.warnings.isEmpty()) {
            return;
        }
        File outFile = new File(this.config.getConfigFile().getParentFile(), this.config.getConfigFile().getName() + ".migration_log.txt");
        boolean writeIntro = !outFile.exists();
        try (FileWriter fw = new FileWriter(outFile, true);){
            if (writeIntro) {
                fw.write("Warnings encountered while migrating the config are logged here.\nFeel free to delete this file once you are done looking at it.\n\n");
            }
            for (String warning : this.warnings) {
                fw.write(warning + "\n");
            }
        }
        catch (IOException e) {
            CoreTweaks.LOGGER.error("Failed to write migration log");
            e.printStackTrace();
        }
    }

    public void migrate_0_2_to_0_3() {
        CoreTweaks.LOGGER.info("Migrating config from 0.2 to 0.3");
        this.migrateFeatureSetting("bugfixes", "fixDisplayListDelete", Config.fixDisplayListDelete);
        this.migrateFeatureSetting("bugfixes", "fixDoubleEat", Config.fixDoubleEat);
        this.migrateFeatureSetting("bugfixes", "fixForgeChatLinkCrash", Config.fixForgeChatLinkCrash);
        this.migrateFeatureSetting("bugfixes", "fixHeightmapRange", Config.fixHeightmapRange);
        this.migrateFeatureSetting("bugfixes", "fixSmallEntitySwim", Config.fixSmallEntitySwim);
        this.migrateFeatureSetting("bugfixes", "restoreTravelSound", Config.restoreTravelSound);
        this.migrateFeatureSetting("optimizations", "clientChunkMap", Config.clientChunkMap);
        this.migrateFeatureSetting("optimizations", "fastFolderTexturePack", Config.fastFolderResourcePack);
        this.migrateFeatureSetting("optimizations", "fcOptimizeTextureUpload", Config.fcOptimizeTextureUpload);
        this.migrateFeatureSetting("optimizations", "forgeFastDeobfuscationRemapper", Config.forgeFastDeobfuscationRemapper);
        this.migrateFeatureSetting("optimizations", "forgeFastProgressBar", Config.forgeFastProgressBar);
        this.migrateFeatureSetting("optimizations", "forgeFastStepMessageStrip", Config.forgeFastStepMessageStrip);
        this.migrateFeatureSetting("optimizations", "forgeModDiscovererSkipKnownLibraries", Config.forgeModDiscovererSkipKnownLibraries);
        this.migrateFeatureSetting("optimizations", "getPendingBlockUpdates", Config.optimizeGetPendingBlockUpdates);
        this.migrateFeatureSetting("optimizations", "jarDiscovererCache", Config.jarDiscovererCache);
        this.migrateFeatureSetting("optimizations", "ofOptimizeWorldRenderer", Config.ofOptimizeWorldRenderer);
        this.migrateFeatureSetting("optimizations", "tcpNoDelay", Config.tcpNoDelay);
        this.migrateInt("optimizations", "threadedTextureLoaderThreadCount", x -> {
            Config.threadedTextureLoaderThreadCount = x;
        });
        this.migrateEnum("optimizations", "transformerCache", x -> {
            if (x != null) {
                Config.transformerCacheMode = (Config.TransformerCache)((Object)x);
                Config.transformerCache.setValue(Config.FeatureSetting.Setting.TRUE);
            } else {
                Config.transformerCache.setValue(Config.FeatureSetting.Setting.FALSE);
            }
        }, ((Object)((Object)Config.transformerCacheMode)).getClass());
        this.migrateString("transformer_cache_full", "badClasses", x -> {
            Config.badClasses = x;
        });
        this.migrateString("transformer_cache_full", "badTransformers", x -> {
            Config.badTransformers = x;
        });
        this.migrateString("transformer_cache_full", "modFilesToIgnore", x -> {
            Config.modFilesToIgnore = x;
        });
        this.migrateInt("transformer_cache_full", "recentCacheSize", x -> {
            Config.recentCacheSize = x;
        });
        this.migrateInt("transformer_cache_full", "verbosity", x -> {
            Config.verbosity = x;
        });
        this.migrateStringList("transformer_cache_lite", "transformersToCache", x -> {
            Config.transformersToCache = new Config.StringList((String[])x);
        });
        this.migrateEnum("tweaks", "cloudHeightCheck", x -> {
            if (x != null) {
                Config.cloudHeightCheckMode = (Config.CloudHeightCheck)((Object)x);
                Config.tweakCloudHeightCheck.setValue(Config.FeatureSetting.Setting.TRUE);
            } else {
                Config.tweakCloudHeightCheck.setValue(Config.FeatureSetting.Setting.FALSE);
            }
        }, ((Object)((Object)Config.cloudHeightCheckMode)).getClass());
        this.migrateFeatureSetting("tweaks", "crashHandler", Config.crashHandler);
        this.migrateFeatureSetting("tweaks", "disableFog", Config.disableFog);
        this.migrateFeatureSetting("tweaks", "forceUncapFramerate", Config.forceUncapFramerate);
        this.migrateFeatureSetting("tweaks", "lightFixStare", Config.lightFixStare);
        this.migrateFeatureSetting("tweaks", "mainMenuContinueButton", Config.mainMenuContinueButton);
        this.migrateFloat("tweaks", "minFarPlaneDistance", x -> {
            Config.minFarPlaneDistance = Math.max(0.0f, x.floatValue());
            Config.clampFarPlaneDistance.setValue(x.floatValue() >= 0.0f ? Config.FeatureSetting.Setting.TRUE : Config.FeatureSetting.Setting.FALSE);
        });
        this.migrateFeatureSetting("tweaks", "ofFixUpdateRenderersReturnValue", Config.ofFixUpdateRenderersReturnValue);
        this.migrateFeatureSetting("tweaks", "ofUnlockCustomSkyMinRenderDistance", Config.ofUnlockCustomSkyMinRenderDistance);
        this.migrateFeatureSetting("tweaks", "uncapCreateWorldGuiTextFieldLength", Config.uncapCreateWorldGuiTextFieldLength);
        this.deleteBooleanIfDefault("diagnostics", "coreTweaksCommand", true);
        this.deleteBooleanIfDefault("diagnostics", "crasher", false);
        this.deleteBooleanIfDefault("diagnostics", "forgeBarProfiler", false);
        this.deleteBooleanIfDefault("diagnostics", "frameProfilerHooks", false);
        this.deleteBooleanIfDefault("diagnostics", "frameProfilerPrint", false);
        this.deleteBooleanIfDefault("diagnostics", "frameProfilerStartEnabled", false);
        this.deleteStringIfDefault("diagnostics", "profilerMethods", "");
        this.deleteBooleanIfDefault("diagnostics", "serverRunTimePrinter", false);
        this.deleteBooleanIfDefault("diagnostics", "wireframe", false);
        this.deleteBooleanIfDefault("tweaks", "autoLoadDingOnWorldEntry", true);
        this.deleteBooleanIfDefault("tweaks", "autoLoadPauseOnWorldEntry", true);
        this.deleteIntIfDefault("tweaks", "autoLoadPauseWaitLength", 20);
        this.removeEmptyCategories();
    }

    private void removeEmptyCategories() {
        for (String catName : this.config.getCategoryNames()) {
            ConfigCategory cat = this.config.getCategory(catName);
            if (!cat.isEmpty()) continue;
            this.config.removeCategory(cat);
        }
    }

    public void migrate_0_3_0_to_0_3_1(boolean newer) {
        CoreTweaks.LOGGER.info("Migrating config from 0.3 to 0.3.1");
        this.migrateRenamedFeatureSetting("optimizations.fast_folder_texture_pack", Config.fastFolderResourcePack);
        this.migrateRenamedFeatureSetting("optimizations.fast_default_texture_pack", Config.fastDefaultResourcePack);
        this.deleteIntIfDefault("tweaks.extend_sprint_time_limit", "sprintTimeLimit", Integer.MAX_VALUE);
        if (newer) {
            if ((Config.FeatureSetting.Setting)((Object)Config.extendSprintTimeLimit.getValue()) == Config.FeatureSetting.Setting.FALSE) {
                this.warn("0.3.1", "The default value of extend_sprint_time_limit has changed to TRUE, but you have it set to the old default value of FALSE. You might wish to enable it.");
            }
            if ((Config.FeatureSetting.Setting)((Object)Config.fastDefaultResourcePack.getValue()) == Config.FeatureSetting.Setting.FALSE) {
                this.warn("0.3.1", "The default value of fast_folder_resource_pack has changed to TRUE, but you have it set to the old default value of FALSE. You might wish to enable it.");
            }
        }
        this.removeEmptyCategories();
    }

    private void warn(String version, String message) {
        String fullMessage = "Warning while migrating config to " + version + ": " + message;
        CoreTweaks.LOGGER.warn(fullMessage);
        this.warnings.add(fullMessage);
    }

    private void migrateRenamedFeatureSetting(String category, Config.FeatureSetting setting) {
        try {
            ConfigCategory cat;
            if (this.config.hasCategory(category) && (cat = this.config.getCategory(category)) != null) {
                setting.setValue(Config.FeatureSetting.Setting.valueOf(cat.get("_enabled").getString().toUpperCase()));
                cat.remove((Object)"_enabled");
            }
        }
        catch (Exception e) {
            CoreTweaks.LOGGER.warn("Something went wrong while trying to migrate " + category);
            e.printStackTrace();
        }
    }

    private void deleteIntIfDefault(String cat, String name, int def) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.INTEGER && prop.getInt() == def) {
            category.remove((Object)name);
        }
    }

    private void deleteStringIfDefault(String cat, String name, String def) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING && prop.getString().equals(def)) {
            category.remove((Object)name);
        }
    }

    private void deleteBooleanIfDefault(String cat, String name, boolean def) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.BOOLEAN && prop.getBoolean() == def) {
            category.remove((Object)name);
        }
    }

    private void migrateFeatureSetting(String cat, String name, Config.FeatureSetting setting) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.BOOLEAN) {
            setting.setValue(prop.getBoolean() ? Config.FeatureSetting.Setting.TRUE : Config.FeatureSetting.Setting.FALSE);
            category.remove((Object)name);
        }
    }

    private void migrateInt(String cat, String name, Consumer<Integer> consumer) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.INTEGER) {
            consumer.accept(prop.getInt());
            category.remove((Object)name);
        }
    }

    private void migrateString(String cat, String name, Consumer<String> consumer) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING) {
            consumer.accept(prop.getString());
            category.remove((Object)name);
        }
    }

    private void migrateFloat(String cat, String name, Consumer<Float> consumer) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING) {
            consumer.accept(Float.valueOf((float)prop.getDouble()));
            category.remove((Object)name);
        }
    }

    private void migrateStringList(String cat, String name, Consumer<String[]> consumer) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING) {
            consumer.accept(prop.getStringList());
            category.remove((Object)name);
        }
    }

    private void migrateEnum(String cat, String name, Consumer<Enum<?>> consumer, Class<? extends Enum> enumClass) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING) {
            consumer.accept((Enum)EnumUtils.getEnumMap(enumClass).get(prop.getString().toUpperCase()));
            category.remove((Object)name);
        }
    }
}

