/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import gcewing.architecture.ArchitectureContent;
import gcewing.architecture.ArchitectureCraftClient;
import gcewing.architecture.ArchitectureGuiHandler;
import gcewing.architecture.client.render.model.IArchitectureModel;
import gcewing.architecture.client.render.model.ObjJsonModel;
import gcewing.architecture.common.config.ArchitectConfiguration;
import gcewing.architecture.common.network.DataChannel;
import java.io.File;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="ArchitectureCraft", name="ArchitectureCraft", version="1.10.2", acceptedMinecraftVersions="[1.7.10]")
public class ArchitectureCraft {
    public static final String MOD_NAME = "ArchitectureCraft";
    public static final String MOD_ID = "ArchitectureCraft";
    public static final String VERSION = "1.10.2";
    public static final String ASSET_KEY = "ArchitectureCraft".toLowerCase();
    public static final String REGISTRY_PREFIX = "ArchitectureCraft".toLowerCase();
    private File cfgFile;
    public ArchitectConfiguration config;
    public static final ArchitectureContent content = new ArchitectureContent();
    public static ArchitectureCraftClient client;
    @Mod.Instance(value="ArchitectureCraft")
    public static ArchitectureCraft mod;
    public static DataChannel channel;

    public ArchitectureCraft() {
        channel = new DataChannel("ArchitectureCraft", new Object[0]);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        this.cfgFile = e.getSuggestedConfigurationFile();
        this.loadConfig();
        this.configure();
        content.preInit(e);
        if (e.getSide().isClient()) {
            client = this.initClient();
        }
        if (client != null) {
            client.preInit(e);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        if (client != null) {
            client.init(e);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        content.postInit(e);
        if (client != null) {
            client.postInit(e);
        }
        this.saveConfig();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ArchitectureGuiHandler());
    }

    public ArchitectureCraftClient initClient() {
        return new ArchitectureCraftClient(this);
    }

    void configure() {
    }

    void loadConfig() {
        this.config = new ArchitectConfiguration(this.cfgFile);
    }

    void saveConfig() {
        if (this.config.extended) {
            this.config.save();
        }
    }

    public static ResourceLocation resourceLocation(String path) {
        if (path.contains(":")) {
            return new ResourceLocation(path);
        }
        return new ResourceLocation(ASSET_KEY, path);
    }

    public ResourceLocation modelLocation(String path) {
        return ArchitectureCraft.resourceLocation("models/" + path);
    }

    public IArchitectureModel getModel(String name) {
        ResourceLocation loc = this.modelLocation(name);
        IArchitectureModel model = ArchitectureCraft.content.modelCache.get(loc);
        if (model == null) {
            model = ObjJsonModel.fromResource(loc);
            ArchitectureCraft.content.modelCache.put(loc, model);
        }
        return model;
    }

    public static void sendTileEntityUpdate(TileEntity te) {
        Packet packet = te.func_145844_m();
        if (packet != null) {
            int x = te.field_145851_c >> 4;
            int z = te.field_145849_e >> 4;
            WorldServer world = (WorldServer)te.func_145831_w();
            ServerConfigurationManager cm = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab();
            PlayerManager pm = world.func_73040_p();
            for (EntityPlayerMP player : cm.field_72404_b) {
                if (!pm.func_72694_a(player, x, z)) continue;
                player.field_71135_a.func_147359_a(packet);
            }
        }
    }
}

