/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import vswe.stevesfactory.blocks.BlockCamouflageBase;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.components.ComponentMenuCamouflageInside;
import vswe.stevesfactory.components.ComponentMenuCamouflageShape;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.IPacketBlock;
import vswe.stevesfactory.network.PacketHandler;

public class TileEntityCamouflage
extends TileEntityClusterElement
implements IPacketBlock {
    private static final Random rand = new Random();
    private boolean useCollision = true;
    private boolean fullCollision = false;
    private int[] bounds = new int[]{0, 32, 0, 32, 0, 32};
    private int[] ids = new int[ForgeDirection.VALID_DIRECTIONS.length * 2];
    private int[] metas = new int[ForgeDirection.VALID_DIRECTIONS.length * 2];
    private static final int UPDATE_BUFFER_DISTANCE = 5;
    private boolean hasClientUpdatedData;
    private boolean isServerDirty;
    private static final String NBT_SIDES = "Sides";
    private static final String NBT_ID = "Id";
    private static final String NBT_META = "Meta";
    private static final String NBT_COLLISION = "Collision";
    private static final String NBT_FULL = "Full";
    private static final String NBT_MIN_X = "MinX";
    private static final String NBT_MAX_X = "MaxX";
    private static final String NBT_MIN_Y = "MinY";
    private static final String NBT_MAX_Y = "MaxY";
    private static final String NBT_MIN_Z = "MinZ";
    private static final String NBT_MAX_Z = "MaxZ";

    public boolean isNormalBlock() {
        if (this.getCamouflageType().useSpecialShape()) {
            if (!this.useCollision) {
                return false;
            }
            for (int i = 0; i < this.bounds.length; ++i) {
                if (this.bounds[i] == (i % 2 == 0 ? 0 : 32)) continue;
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockEffect(Block camoBlock, int sideHit, EffectRenderer effectRenderer) {
        try {
            Block block;
            if (this.ids[sideHit] != 0 && (block = Block.func_149729_e((int)this.ids[sideHit])) != null) {
                float f = 0.1f;
                double x = (double)this.field_145851_c + rand.nextDouble() * (camoBlock.func_149753_y() - camoBlock.func_149704_x() - (double)(f * 2.0f)) + (double)f + camoBlock.func_149704_x();
                double y = (double)this.field_145848_d + rand.nextDouble() * (camoBlock.func_149669_A() - camoBlock.func_149665_z() - (double)(f * 2.0f)) + (double)f + camoBlock.func_149665_z();
                double z = (double)this.field_145849_e + rand.nextDouble() * (camoBlock.func_149693_C() - camoBlock.func_149706_B() - (double)(f * 2.0f)) + (double)f + camoBlock.func_149706_B();
                switch (sideHit) {
                    case 0: {
                        y = (double)this.field_145848_d + camoBlock.func_149665_z() - (double)f;
                        break;
                    }
                    case 1: {
                        y = (double)this.field_145848_d + camoBlock.func_149669_A() + (double)f;
                        break;
                    }
                    case 2: {
                        z = (double)this.field_145849_e + camoBlock.func_149706_B() - (double)f;
                        break;
                    }
                    case 3: {
                        z = (double)this.field_145849_e + camoBlock.func_149693_C() + (double)f;
                        break;
                    }
                    case 4: {
                        x = (double)this.field_145851_c + camoBlock.func_149704_x() - (double)f;
                        break;
                    }
                    case 5: {
                        x = (double)this.field_145851_c + camoBlock.func_149753_y() + (double)f;
                    }
                }
                effectRenderer.func_78873_a(new EntityDiggingFX(this.field_145850_b, x, y, z, 0.0, 0.0, 0.0, block, this.metas[sideHit]).func_70543_e(0.2f).func_70541_f(0.6f));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public CamouflageType getCamouflageType() {
        return CamouflageType.values()[ModBlocks.blockCableCamouflage.getId(this.func_145832_p())];
    }

    public void setBlockBounds(BlockCamouflageBase blockCamouflageBase) {
        blockCamouflageBase.func_149676_a((float)this.bounds[0] / 32.0f, (float)this.bounds[2] / 32.0f, (float)this.bounds[4] / 32.0f, (float)this.bounds[1] / 32.0f, (float)this.bounds[3] / 32.0f, (float)this.bounds[5] / 32.0f);
    }

    public boolean isUseCollision() {
        return this.useCollision;
    }

    public boolean isFullCollision() {
        return this.fullCollision;
    }

    public void setBounds(ComponentMenuCamouflageShape menu) {
        if (this.getCamouflageType().useSpecialShape() && menu.shouldUpdate()) {
            int i;
            if (menu.isUseCollision() != this.useCollision) {
                this.useCollision = menu.isUseCollision();
                this.isServerDirty = true;
            }
            if (menu.isFullCollision() != this.fullCollision) {
                this.fullCollision = menu.isFullCollision();
                this.isServerDirty = true;
            }
            for (i = 0; i < this.bounds.length; ++i) {
                if (this.bounds[i] == menu.getBounds(i)) continue;
                this.bounds[i] = menu.getBounds(i);
                this.isServerDirty = true;
            }
            for (i = 0; i < this.bounds.length; i += 2) {
                if (this.bounds[i] <= this.bounds[i + 1]) continue;
                int tmp = this.bounds[i + 1];
                this.bounds[i + 1] = this.bounds[i];
                this.bounds[i] = tmp;
            }
        }
    }

    public void setItem(ItemStack item, int side, ComponentMenuCamouflageInside.InsideSetType type) {
        switch (type) {
            case ONLY_OUTSIDE: {
                this.setItem(item, side);
                break;
            }
            case ONLY_INSIDE: {
                this.setItemForInside(item, side + ForgeDirection.VALID_DIRECTIONS.length);
                break;
            }
            case SAME: {
                this.setItem(item, side);
                this.setItemForInside(item, side + ForgeDirection.VALID_DIRECTIONS.length);
                break;
            }
            case OPPOSITE: {
                this.setItem(item, side);
                int sidePairInternalId = side % 2;
                int insideSide = side + (sidePairInternalId == 0 ? 1 : -1);
                this.setItemForInside(item, insideSide + ForgeDirection.VALID_DIRECTIONS.length);
                break;
            }
        }
    }

    private void setItemForInside(ItemStack item, int side) {
        if (this.getCamouflageType().useDoubleRendering()) {
            this.setItem(item, side);
        }
    }

    private void setItem(ItemStack item, int side) {
        int oldId = this.ids[side];
        int oldMeta = this.metas[side];
        if (item == null) {
            this.ids[side] = 0;
            this.metas[side] = 0;
        } else if (item.func_77973_b() != null && item.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)item.func_77973_b()).field_150939_a;
            if (block != null) {
                this.ids[side] = Block.func_149682_b((Block)block);
                this.metas[side] = item.func_77973_b().func_77647_b(item.func_77960_j());
                this.validateSide(side);
            } else {
                this.ids[side] = 0;
                this.metas[side] = 0;
            }
        }
        if (this.ids[side] != oldId || this.metas[side] != oldMeta) {
            this.isServerDirty = true;
        }
    }

    public int getId(int side) {
        return this.ids[side];
    }

    public int getMeta(int side) {
        return this.metas[side];
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.ON_BLOCK_PLACED_BY);
    }

    private int getSideCount() {
        return this.getCamouflageType().useDoubleRendering() ? this.ids.length : this.ids.length / 2;
    }

    @Override
    public void writeData(DataWriter dw, EntityPlayer player, boolean onServer, int id) {
        if (onServer) {
            for (int i = 0; i < this.getSideCount(); ++i) {
                if (this.ids[i] == 0) {
                    dw.writeBoolean(false);
                    continue;
                }
                dw.writeBoolean(true);
                dw.writeData(this.ids[i], DataBitHelper.BLOCK_ID);
                dw.writeData(this.metas[i], DataBitHelper.BLOCK_META);
            }
            if (this.getCamouflageType().useSpecialShape()) {
                dw.writeBoolean(this.useCollision);
                if (this.useCollision) {
                    dw.writeBoolean(this.fullCollision);
                }
                for (int bound : this.bounds) {
                    if (bound == 0) {
                        dw.writeBoolean(true);
                        dw.writeBoolean(false);
                        continue;
                    }
                    if (bound == 32) {
                        dw.writeBoolean(true);
                        dw.writeBoolean(true);
                        continue;
                    }
                    dw.writeData(bound << 1, DataBitHelper.CAMOUFLAGE_BOUNDS.getBitCount());
                }
            }
        }
    }

    @Override
    public void readData(DataReader dr, EntityPlayer player, boolean onServer, int id) {
        if (onServer) {
            PacketHandler.sendBlockPacket(this, player, 0);
        } else {
            int i;
            for (i = 0; i < this.getSideCount(); ++i) {
                if (!dr.readBoolean()) {
                    this.ids[i] = 0;
                    this.metas[i] = 0;
                    continue;
                }
                this.ids[i] = dr.readData(DataBitHelper.BLOCK_ID);
                this.metas[i] = dr.readData(DataBitHelper.BLOCK_META);
                this.validateSide(i);
            }
            if (this.getCamouflageType().useSpecialShape()) {
                this.useCollision = dr.readBoolean();
                this.fullCollision = this.useCollision ? dr.readBoolean() : false;
                for (i = 0; i < this.bounds.length; ++i) {
                    this.bounds[i] = dr.readBoolean() ? (dr.readBoolean() ? 32 : 0) : dr.readData(DataBitHelper.CAMOUFLAGE_BOUNDS.getBitCount() - 1);
                }
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void validateSide(int i) {
        if (this.ids[i] < 0 || this.ids[i] >= Block.field_149771_c.func_148742_b().size()) {
            this.ids[i] = 0;
        }
    }

    @Override
    public int infoBitLength(boolean onServer) {
        return 1;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.keepClientDataUpdated();
        } else if (this.isServerDirty) {
            this.isServerDirty = false;
            PacketHandler.sendBlockPacket(this, null, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void keepClientDataUpdated() {
        double distance = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        if (distance > Math.pow(128.0, 2.0)) {
            this.hasClientUpdatedData = false;
        } else if (!this.hasClientUpdatedData && distance < Math.pow(123.0, 2.0)) {
            this.hasClientUpdatedData = true;
            PacketHandler.sendBlockPacket(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
        }
    }

    @Override
    protected void writeContentToNBT(NBTTagCompound tagCompound) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.getSideCount(); ++i) {
            NBTTagCompound element = new NBTTagCompound();
            element.func_74777_a(NBT_ID, (short)this.ids[i]);
            element.func_74774_a(NBT_META, (byte)this.metas[i]);
            list.func_74742_a((NBTBase)element);
        }
        tagCompound.func_74782_a(NBT_SIDES, (NBTBase)list);
        if (this.getCamouflageType().useSpecialShape()) {
            tagCompound.func_74757_a(NBT_COLLISION, this.useCollision);
            tagCompound.func_74757_a(NBT_FULL, this.fullCollision);
            tagCompound.func_74774_a(NBT_MIN_X, (byte)this.bounds[0]);
            tagCompound.func_74774_a(NBT_MAX_X, (byte)this.bounds[1]);
            tagCompound.func_74774_a(NBT_MIN_Y, (byte)this.bounds[2]);
            tagCompound.func_74774_a(NBT_MAX_Y, (byte)this.bounds[3]);
            tagCompound.func_74774_a(NBT_MIN_Z, (byte)this.bounds[4]);
            tagCompound.func_74774_a(NBT_MAX_Z, (byte)this.bounds[5]);
        }
    }

    @Override
    protected void readContentFromNBT(NBTTagCompound tagCompound) {
        NBTTagList list = tagCompound.func_150295_c(NBT_SIDES, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound element = list.func_150305_b(i);
            this.ids[i] = element.func_74765_d(NBT_ID);
            this.metas[i] = element.func_74771_c(NBT_META);
            this.validateSide(i);
        }
        if (tagCompound.func_74764_b(NBT_COLLISION)) {
            this.useCollision = tagCompound.func_74767_n(NBT_COLLISION);
            this.fullCollision = tagCompound.func_74767_n(NBT_FULL);
            this.bounds[0] = tagCompound.func_74771_c(NBT_MIN_X);
            this.bounds[1] = tagCompound.func_74771_c(NBT_MAX_X);
            this.bounds[2] = tagCompound.func_74771_c(NBT_MIN_Y);
            this.bounds[3] = tagCompound.func_74771_c(NBT_MAX_Y);
            this.bounds[4] = tagCompound.func_74771_c(NBT_MIN_Z);
            this.bounds[5] = tagCompound.func_74771_c(NBT_MAX_Z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon getIcon(int side, boolean inside) {
        Block block;
        if (inside) {
            side += ForgeDirection.VALID_DIRECTIONS.length;
        }
        if ((block = Block.func_149729_e((int)this.ids[side])) != null) {
            try {
                IIcon icon = block.func_149691_a(side, this.metas[side]);
                if (icon != null) {
                    return icon;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconWithDefault(IBlockAccess world, int x, int y, int z, BlockCamouflageBase block, int side, boolean inside) {
        IIcon icon = this.getIcon(side, inside);
        if (icon == null) {
            icon = block.getDefaultIcon(side, world.func_72805_g(x, y, z), this.func_145832_p());
        }
        return icon;
    }

    public static enum CamouflageType {
        NORMAL("BlockCableCamouflage", "cable_camo", false, false),
        INSIDE("BlockCableInsideCamouflage", "cable_camo_inside", true, false),
        SHAPE("BlockCableShapeCamouflage", "cable_camo_shape", true, true);

        private String unlocalized;
        private String icon;
        private boolean useDouble;
        private boolean useShape;

        private CamouflageType(String unlocalized, String icon, boolean useDouble, boolean useShape) {
            this.unlocalized = unlocalized;
            this.icon = icon;
            this.useDouble = useDouble;
            this.useShape = useShape;
        }

        public String getUnlocalized() {
            return this.unlocalized;
        }

        public String getIcon() {
            return this.icon;
        }

        public boolean useDoubleRendering() {
            return this.useDouble;
        }

        public boolean useSpecialShape() {
            return this.useShape;
        }
    }
}

