/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.recipe;

import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.set.hash.TCustomHashSet;
import gregtech.api.util.GTRecipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.slots.SlotIntegratedCircuit;
import gtPlusPlus.core.util.recipe.RecipeHashStrat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class GTRecipeUtils {
    public static List<GTRecipe> removeDuplicates(List<GTRecipe> inputRecipes, String recipeMapName) {
        TCustomHashSet recipesHashSet = new TCustomHashSet(RecipeHashStrat.RecipeHashingStrategy);
        ArrayList<GTRecipe> recipeOutput = new ArrayList<GTRecipe>();
        TCustomHashMap circuitMap = new TCustomHashMap(RecipeHashStrat.RecipeHashingStrategy);
        int removedRecipeCount = 0;
        for (GTRecipe recipeInput : inputRecipes) {
            ItemStack savedCircuit = null;
            ArrayList<ItemStack> itemInputsWithoutProgrammableCircuit = new ArrayList<ItemStack>();
            for (ItemStack itemStack : recipeInput.mInputs) {
                if (itemStack == null) continue;
                if (SlotIntegratedCircuit.isRegularProgrammableCircuit(itemStack) == -1) {
                    itemInputsWithoutProgrammableCircuit.add(itemStack);
                    continue;
                }
                savedCircuit = itemStack;
            }
            GTRecipe newRecipe = new GTRecipe(false, itemInputsWithoutProgrammableCircuit.toArray(new ItemStack[0]), recipeInput.mOutputs, recipeInput.mSpecialItems, recipeInput.mChances, recipeInput.mFluidInputs, recipeInput.mFluidOutputs, recipeInput.mDuration, recipeInput.mEUt, recipeInput.mSpecialValue);
            if (!recipesHashSet.contains((Object)newRecipe)) {
                recipesHashSet.add((Object)newRecipe);
            } else {
                ++removedRecipeCount;
            }
            if (savedCircuit == null) continue;
            if (circuitMap.containsKey((Object)newRecipe)) {
                if (((ItemStack)circuitMap.get((Object)newRecipe)).func_77960_j() <= savedCircuit.func_77960_j()) continue;
                circuitMap.put((Object)newRecipe, (Object)savedCircuit);
                continue;
            }
            circuitMap.put((Object)newRecipe, (Object)savedCircuit);
        }
        for (GTRecipe filteredRecipe : recipesHashSet) {
            if (circuitMap.contains((Object)filteredRecipe)) {
                filteredRecipe.mInputs = (ItemStack[])ArrayUtils.add((Object[])filteredRecipe.mInputs, (Object)((ItemStack)circuitMap.get((Object)filteredRecipe)));
            }
            recipeOutput.add(filteredRecipe);
        }
        Logger.INFO("Recipe Array duplication removal process completed for '" + recipeMapName + "': '" + removedRecipeCount + "' removed.");
        return recipeOutput;
    }
}

