/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import codechicken.lib.gui.GuiDraw;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class NEIHandlerAbsoluteTooltip {
    private final Rectangle area;
    private final String tooltip;
    private Dimension displaySize;

    public NEIHandlerAbsoluteTooltip(String tooltip, Rectangle area) {
        this.tooltip = tooltip;
        this.area = area;
    }

    public void handleTooltip(List<String> currenttip, int recipeIndex) {
        this.displaySize = GuiDraw.displaySize();
        if (this.shouldAddTooltip(recipeIndex)) {
            currenttip.add(this.tooltip);
        }
    }

    private boolean shouldAddTooltip(int recipeIndex) {
        return this.isPageFirstRecipe(recipeIndex) && this.mouseInArea();
    }

    private boolean mouseInArea() {
        Point mousePos = this.getRelMouse();
        return this.area.contains(mousePos);
    }

    private Point getRelMouse() {
        int ySize = Math.min(Math.max(this.displaySize.height - 68, 166), 370);
        int guiLeft = (this.displaySize.width - 176) / 2;
        int guiTop = (this.displaySize.height - ySize) / 2 + 10;
        Point mousePos = GuiDraw.getMousePosition();
        return new Point(mousePos.x - guiLeft - 5, mousePos.y - guiTop - 38);
    }

    private boolean isPageFirstRecipe(int recipe) {
        int actualRecipesPerPage = this.getActualRecipesPerPage();
        return actualRecipesPerPage < 2 || recipe % 2 == 0;
    }

    private int getActualRecipesPerPage() {
        int ySize = Math.min(Math.max(this.displaySize.height - 68, 166), 370);
        return (ySize - 36) / 135;
    }
}

