/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.util.GTToolHarvestHelper;
import gregtech.common.items.behaviors.BehaviourPlungerEssentia;
import gregtech.common.items.behaviors.BehaviourPlungerFluid;
import gregtech.common.items.behaviors.BehaviourPlungerItem;
import gregtech.common.tools.GTTool;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ToolPlunger
extends GTTool {
    @Override
    public float getBaseDamage() {
        return 1.25f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 0.25f;
    }

    @Override
    public String getCraftingSound() {
        return SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE.toString();
    }

    @Override
    public String getEntityHitSound() {
        return SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE.toString();
    }

    @Override
    public String getMiningSound() {
        return SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE.toString();
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        return GTToolHarvestHelper.isAppropriateTool(aBlock, aMetaData, "plunger");
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.PLUNGER : null;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mRGBa : MetaGeneratedTool.getSecondaryMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public void onStatsAddedToTool(MetaGeneratedTool aItem, int aID) {
        aItem.addItemBehavior(aID, new BehaviourPlungerItem(this.getToolDamagePerDropConversion()));
        aItem.addItemBehavior(aID, new BehaviourPlungerFluid(this.getToolDamagePerDropConversion()));
        if (Mods.Thaumcraft.isModLoaded()) {
            aItem.addItemBehavior(aID, new BehaviourPlungerEssentia(this.getToolDamagePerDropConversion()));
        }
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " got stuck trying to escape through a Pipe while fighting " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }
}

