/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEPurificationUnitOzonation
extends MTEPurificationUnitBase<MTEPurificationUnitOzonation>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_SURVIVAL = "main_survival";
    private static final String[][] structure = new String[][]{{"         ", "         ", "      A  ", "      A  ", "     AAA ", "     AAA ", "     A A ", "     A A ", "     A A ", "     A~A "}, {"      A  ", "      A  ", "     A A ", "     A A ", "BBBBA   A", "BDDBA   A", "BBBBA D A", "E   A D A", "E   A D A", "E   AAAAA"}, {"     AAA ", "     A A ", "    A   A", "    A   A", "BDDBA   A", "O  BA   A", "BBBBA   A", "  C A   A", "  CCA   A", "    AAAAA"}, {"      A  ", "      A  ", "     A A ", "     A A ", "BBBBA   A", "BDDBA   A", "BBBBA   A", "E   A   A", "E   A   A", "E   AAAAA"}, {"         ", "         ", "      A  ", "      A  ", "     AAA ", "     AAA ", "     AAA ", "     AAA ", "     AAA ", "     AAA "}};
    private static final int MAIN_CASING_INDEX = MTEPurificationUnitOzonation.getTextureIndex(GregTechAPI.sBlockCasings9, 10);
    private static final int OFFSET_X = 6;
    private static final int OFFSET_Y = 9;
    private static final int OFFSET_Z = 0;
    public static final int MAX_OZONE_GAS_FOR_EXPLOSION = 1000 * (int)Math.pow(2.0, 10.0);
    private int casingCount = 0;
    private static final int MIN_CASING = 96;
    private static final IStructureDefinition<MTEPurificationUnitOzonation> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(ImmutableList.of((Object)HatchElement.InputHatch, (Object)HatchElement.OutputHatch, (Object)HatchElement.OutputBus)).casingIndex(MTEPurificationUnitOzonation.getTextureIndex(GregTechAPI.sBlockCasings9, 10)).dot(1).build()), StructureUtility.onElementPass(t -> ++t.casingCount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)10))})).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)9)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)1)).addElement('D', StructureUtility.ofBlockAnyMeta((Block)GregTechAPI.sBlockTintedGlass)).addElement('E', GTStructureUtility.ofFrame(Materials.TungstenSteel)).addElement('O', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeast(HatchElement.InputHatch).casingIndex(MTEPurificationUnitOzonation.getTextureIndex(GregTechAPI.sBlockCasings9, 9)).dot(2).buildAndChain(StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)9)))).build();

    public MTEPurificationUnitOzonation(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected MTEPurificationUnitOzonation(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPurificationUnitOzonation(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(MAIN_CASING_INDEX), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(MAIN_CASING_INDEX), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(MAIN_CASING_INDEX)};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 6, 9, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 6, 9, 0, elementBudget, env, true);
    }

    @Override
    public IStructureDefinition<MTEPurificationUnitOzonation> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Purification Unit").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Water Tier: " + EnumChatFormatting.WHITE + GTUtility.formatNumbers(this.getWaterTier()) + EnumChatFormatting.RESET).addInfo("Must be linked to a Purification Plant using a data stick to work.").addSeparator().addInfo("Will explode if the input hatch contains more than " + EnumChatFormatting.RED + MAX_OZONE_GAS_FOR_EXPLOSION + "L " + EnumChatFormatting.WHITE + "Ozone Gas.").addInfo("Receives a " + EnumChatFormatting.RED + "20%" + EnumChatFormatting.GRAY + " bonus to success chance for every doubling of " + EnumChatFormatting.WHITE + "Ozone Gas.").addSeparator().addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "The second step in water purification is ozonation, which involves injecting large quantities of small").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "bubbles of highly reactive ozone gas into the water. This removes trace element contaminants like").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "sulfur, iron and manganese, creating insoluble oxide compounds which are then filtered out.").beginStructureBlock(9, 10, 5, false).addCasingInfoRangeColored("Inert Filtration Casing", EnumChatFormatting.GRAY, 96, 102, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Reactive Gas Containment Casing", EnumChatFormatting.GRAY, 28, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Any Tinted Industrial Glass", EnumChatFormatting.GRAY, 9, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Tungstensteel Frame Box", EnumChatFormatting.GRAY, 6, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("PTFE Pipe Casing", EnumChatFormatting.GRAY, 3, EnumChatFormatting.GOLD, false).addOutputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addInputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addOutputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addOtherStructurePart("Input Hatch (Ozone)", EnumChatFormatting.GOLD + "1", 2).toolTipFinisher(GTValues.AuthorNotAPenguin);
        return tt;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.purificationOzonationRecipes;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        CheckRecipeResult result = super.checkProcessing();
        if (!result.wasSuccessful()) {
            return result;
        }
        for (FluidStack fluid : this.storedFluids) {
            if (!fluid.isFluidEqual(Materials.Ozone.getGas(1L)) || fluid.amount <= MAX_OZONE_GAS_FOR_EXPLOSION) continue;
            this.explodeMultiblock();
        }
        return result;
    }

    @Override
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_OZONATION_LOOP;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getWaterTier() {
        return 2;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingCount = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 6, 9, 0)) {
            return false;
        }
        if (this.casingCount < 96) {
            return false;
        }
        return super.checkMachine(aBaseMetaTileEntity, aStack);
    }

    @Override
    public long getBasePowerUsage() {
        return TierEU.RECIPE_LuV;
    }
}

