/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.security.InvalidParameterException;
import java.util.ArrayDeque;
import net.minecraft.server.MinecraftServer;

public class AveragePerTickCounter {
    private final ArrayDeque<Measurement> values;
    private final int period;
    private final double cachedAverage = 0.0;
    private boolean isCachedAverageValid = true;

    public AveragePerTickCounter(int period) throws InvalidParameterException {
        if (period <= 0) {
            throw new InvalidParameterException("period should be a positive non-zero number");
        }
        this.period = period;
        this.values = new ArrayDeque(period);
    }

    public void addValue(long value) {
        if (value == 0L) {
            return;
        }
        int currTick = this.getWorldTimeInTicks();
        if (this.values.isEmpty()) {
            this.values.addLast(new Measurement(currTick, value));
            this.isCachedAverageValid = false;
            return;
        }
        Measurement lastMeasurement = this.values.peekLast();
        int lastMeasurementTick = lastMeasurement.TimestampInWorldTicks;
        if (currTick == lastMeasurementTick) {
            lastMeasurement.Value += value;
            this.isCachedAverageValid = false;
            return;
        }
        if (currTick > lastMeasurementTick) {
            this.trimIrrelevantData(currTick);
            this.values.addLast(new Measurement(currTick, value));
            this.isCachedAverageValid = false;
            return;
        }
    }

    public double getAverage() {
        if (this.values.isEmpty()) {
            return 0.0;
        }
        int currTick = this.getWorldTimeInTicks();
        Measurement lastMeasurement = this.values.peekLast();
        int lastMeasurementTick = lastMeasurement.TimestampInWorldTicks;
        if (currTick < lastMeasurementTick) {
            return 0.0;
        }
        if (currTick > lastMeasurementTick) {
            this.trimIrrelevantData(currTick);
        }
        if (this.isCachedAverageValid) {
            return 0.0;
        }
        return this.calculateAverage();
    }

    public long getLast() {
        if (this.values.isEmpty()) {
            return 0L;
        }
        int currTick = this.getWorldTimeInTicks();
        Measurement lastMeasurement = this.values.peekLast();
        int lastMeasurementTick = lastMeasurement.TimestampInWorldTicks;
        if (currTick == lastMeasurementTick) {
            return this.values.getLast().Value;
        }
        return 0L;
    }

    private double calculateAverage() {
        this.isCachedAverageValid = true;
        long sum = 0L;
        for (Measurement measurement : this.values) {
            sum += measurement.Value;
        }
        return (double)sum / (double)this.period;
    }

    private void trimIrrelevantData(int currWorldTimeInTicks) {
        if (this.values.isEmpty()) {
            return;
        }
        int firstMeasurementTick = this.values.peekFirst().TimestampInWorldTicks;
        while (currWorldTimeInTicks - firstMeasurementTick >= this.period) {
            this.values.removeFirst();
            this.isCachedAverageValid = false;
            if (this.values.isEmpty()) {
                return;
            }
            firstMeasurementTick = this.values.peekFirst().TimestampInWorldTicks;
        }
    }

    private int getWorldTimeInTicks() {
        return MinecraftServer.func_71276_C().func_71259_af();
    }

    private static class Measurement {
        public int TimestampInWorldTicks;
        public long Value;

        public Measurement(int timestampInWorldTicks, long value) {
            this.TimestampInWorldTicks = timestampInWorldTicks;
            this.Value = value;
        }
    }
}

