/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.interfaces.HatchElement;
import gregtech.api.interfaces.HatchElementEither;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.IGTHatchAdder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.ToLongFunction;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public interface IHatchElement<T> {
    public List<? extends Class<? extends IMetaTileEntity>> mteClasses();

    public IGTHatchAdder<? super T> adder();

    public String name();

    public long count(T var1);

    default public <T2 extends T> IHatchElement<T2> withMteClass(Class<? extends IMetaTileEntity> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException();
        }
        return this.withMteClasses(Collections.singletonList(aClass));
    }

    default public <T2 extends T> IHatchElement<T2> withMteClasses(Class<? extends IMetaTileEntity> ... aClasses) {
        if (aClasses == null) {
            throw new IllegalArgumentException();
        }
        return this.withMteClasses(Arrays.asList(aClasses));
    }

    default public <T2 extends T> IHatchElement<T2> withMteClasses(List<Class<? extends IMetaTileEntity>> aClasses) {
        if (aClasses == null) {
            throw new IllegalArgumentException();
        }
        return new HatchElement(aClasses, null, null, null, this);
    }

    default public <T2 extends T> IHatchElement<T2> withAdder(IGTHatchAdder<T2> aAdder) {
        if (aAdder == null) {
            throw new IllegalArgumentException();
        }
        return new HatchElement<T2>(null, aAdder, null, null, this);
    }

    default public IHatchElement<T> withName(String aName) {
        if (aName == null) {
            throw new IllegalArgumentException();
        }
        return new HatchElement(null, null, aName, null, this);
    }

    default public <T2 extends T> IHatchElement<T2> withCount(ToLongFunction<T2> aCount) {
        if (aCount == null) {
            throw new IllegalArgumentException();
        }
        return new HatchElement<T2>(null, null, null, aCount, this);
    }

    default public <T2 extends T> IStructureElement<T2> newAny(int aCasingIndex, int aDot) {
        if (aCasingIndex < 0 || aDot < 0) {
            throw new IllegalArgumentException();
        }
        return GTStructureUtility.buildHatchAdder().anyOf(this).casingIndex(aCasingIndex).dot(aDot).continueIfSuccess().exclusive().build();
    }

    default public <T2 extends T> IStructureElement<T2> newAnyOrCasing(int aCasingIndex, int aDot, Block casingBlock, int casingMeta) {
        if (aCasingIndex < 0 || aDot < 0) {
            throw new IllegalArgumentException();
        }
        return GTStructureUtility.buildHatchAdder().anyOf(this).casingIndex(aCasingIndex).dot(aDot).continueIfSuccess().buildAndChain(StructureUtility.ofBlock((Block)casingBlock, (int)casingMeta));
    }

    default public <T2 extends T> IStructureElement<T2> newAny(int aCasingIndex, int aDot, ForgeDirection ... allowedFacings) {
        if (aCasingIndex < 0 || aDot < 0) {
            throw new IllegalArgumentException();
        }
        return GTStructureUtility.buildHatchAdder().anyOf(this).casingIndex(aCasingIndex).dot(aDot).continueIfSuccess().allowOnly(allowedFacings).exclusive().build();
    }

    default public <T2 extends T> IStructureElement<T2> newAny(int aCasingIndex, int aDot, BiPredicate<? super T2, ? super IGregTechTileEntity> aShouldSkip) {
        if (aCasingIndex < 0 || aDot < 0 || aShouldSkip == null) {
            throw new IllegalArgumentException();
        }
        return GTStructureUtility.buildHatchAdder().anyOf(this).casingIndex(aCasingIndex).dot(aDot).shouldSkip(aShouldSkip).continueIfSuccess().build();
    }

    default public <T2 extends T> IHatchElement<T2> or(IHatchElement<? super T2> fallback) {
        return new HatchElementEither<T2>(this, fallback);
    }
}

