/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.liquid;

import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidDefinition;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc1710.liquid.MCLiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MCLiquidDefinition
implements ILiquidDefinition {
    private final Fluid fluid;

    public MCLiquidDefinition(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public String getName() {
        return this.fluid.getName();
    }

    @Override
    public String getDisplayName() {
        return this.fluid.getLocalizedName();
    }

    @Override
    public ILiquidStack asStack(int millibuckets) {
        return new MCLiquidStack(new FluidStack(this.fluid, millibuckets));
    }

    @Override
    public int getLuminosity() {
        return this.fluid.getLuminosity();
    }

    @Override
    public void setLuminosity(int value) {
        MineTweakerAPI.apply(new ActionSetLuminosity(value));
    }

    @Override
    public int getDensity() {
        return this.fluid.getDensity();
    }

    @Override
    public void setDensity(int density) {
        MineTweakerAPI.apply(new ActionSetDensity(density));
    }

    @Override
    public int getTemperature() {
        return this.fluid.getTemperature();
    }

    @Override
    public void setTemperature(int temperature) {
        MineTweakerAPI.apply(new ActionSetTemperature(temperature));
    }

    @Override
    public int getViscosity() {
        return this.fluid.getViscosity();
    }

    @Override
    public void setViscosity(int viscosity) {
        MineTweakerAPI.apply(new ActionSetViscosity(viscosity));
    }

    @Override
    public boolean isGaseous() {
        return this.fluid.isGaseous();
    }

    @Override
    public void setGaseous(boolean gaseous) {
        MineTweakerAPI.apply(new ActionSetGaseous(gaseous));
    }

    @Override
    public List<IItemStack> getContainers() {
        ArrayList<IItemStack> result = new ArrayList<IItemStack>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (data.fluid.getFluid() != this.fluid) continue;
            result.add(MineTweakerMC.getIItemStack(data.filledContainer));
        }
        return result;
    }

    @Override
    public void addContainer(IItemStack filled, IItemStack empty, int amount) {
        MineTweakerAPI.apply(new AddContainerAction(filled, empty, amount));
    }

    @Override
    public void removeContainer(IItemStack filled) {
        MineTweakerAPI.logError("Cannot remove container items in MineCraft 1.7.X");
    }

    private class ActionSetGaseous
    implements IUndoableAction {
        private final boolean oldValue;
        private final boolean newValue;

        public ActionSetGaseous(boolean newValue) {
            this.oldValue = MCLiquidDefinition.this.isGaseous();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setGaseous(this.newValue);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MCLiquidDefinition.this.fluid.setGaseous(this.oldValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " gaseous to " + this.newValue;
        }

        @Override
        public String describeUndo() {
            return "Restoring " + MCLiquidDefinition.this.fluid.getName() + " gaseous to " + this.oldValue;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private class ActionSetViscosity
    implements IUndoableAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetViscosity(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getViscosity();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setViscosity(this.newValue);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MCLiquidDefinition.this.fluid.setViscosity(this.oldValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " viscosity to " + this.newValue;
        }

        @Override
        public String describeUndo() {
            return "Restoring " + MCLiquidDefinition.this.fluid.getName() + " viscosity to " + this.oldValue;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private class ActionSetTemperature
    implements IUndoableAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetTemperature(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getTemperature();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setTemperature(this.newValue);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MCLiquidDefinition.this.fluid.setTemperature(this.oldValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " temperature to " + this.newValue;
        }

        @Override
        public String describeUndo() {
            return "Restoring " + MCLiquidDefinition.this.fluid.getName() + " temperature to " + this.oldValue;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private class ActionSetDensity
    implements IUndoableAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetDensity(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getDensity();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setDensity(this.newValue);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MCLiquidDefinition.this.fluid.setDensity(this.oldValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " density to " + this.newValue;
        }

        @Override
        public String describeUndo() {
            return "Restoring " + MCLiquidDefinition.this.fluid.getName() + " density to " + this.oldValue;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private class ActionSetLuminosity
    implements IUndoableAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetLuminosity(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getLuminosity();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setLuminosity(this.newValue);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MCLiquidDefinition.this.fluid.setLuminosity(this.oldValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " luminosity to " + this.newValue;
        }

        @Override
        public String describeUndo() {
            return "Restoring " + MCLiquidDefinition.this.fluid.getName() + " luminosity to " + this.oldValue;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private class AddContainerAction
    implements IUndoableAction {
        private final IItemStack filled;
        private final IItemStack empty;
        private final int amount;

        public AddContainerAction(IItemStack filled, IItemStack empty, int amount) {
            this.filled = filled;
            this.empty = empty;
            this.amount = amount;
        }

        @Override
        public void apply() {
            FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(MCLiquidDefinition.this.fluid, this.amount), (ItemStack)MineTweakerMC.getItemStack(this.filled), (ItemStack)MineTweakerMC.getItemStack(this.empty));
        }

        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public void undo() {
        }

        @Override
        public String describe() {
            return "Adding " + this.filled.getDisplayName() + " as liquid container for " + MCLiquidDefinition.this.fluid.getLocalizedName();
        }

        @Override
        public String describeUndo() {
            return "Removing liquid container " + this.filled;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

