/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.buildcraft.statements.triggers;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.integration.buildcraft.statements.triggers.IComputronicsTrigger;
import pl.asie.computronics.integration.buildcraft.statements.triggers.TriggerComputer;
import pl.asie.computronics.integration.buildcraft.statements.triggers.TriggerTapeDrive;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.util.StringUtil;

public enum Triggers implements ITriggerExternal
{
    Computer_Running("computer_running", new TriggerComputer.Running()),
    Computer_Stopped("computer_stopped", new TriggerComputer.Stopped()),
    TapeDrive_Playing("tape_drive_playing", new TriggerTapeDrive(TapeDriveState.State.PLAYING)),
    TapeDrive_Stopped("tape_drive_stopped", new TriggerTapeDrive(TapeDriveState.State.STOPPED)),
    TapeDrive_Rewinding("tape_drive_rewinding", new TriggerTapeDrive(TapeDriveState.State.REWINDING)),
    TapeDrive_Forwarding("tape_drive_forwarding", new TriggerTapeDrive(TapeDriveState.State.FORWARDING));

    public static final Triggers[] VALUES;
    private String tag;
    private IComputronicsTrigger trigger;
    private IIcon icon;

    private Triggers(String tag, IComputronicsTrigger trigger) {
        this.tag = tag;
        this.trigger = trigger;
    }

    public static void initialize() {
        for (Triggers trigger : VALUES) {
            StatementManager.registerStatement((IStatement)trigger);
        }
    }

    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer container, IStatementParameter[] statements) {
        return this.trigger.isTriggerActive(tile, side, container, statements);
    }

    public String getUniqueTag() {
        return "computroncis:trigger." + this.tag;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("computronics:buildcraft/triggers/trigger." + this.tag);
    }

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    public IStatementParameter createParameter(int i) {
        return null;
    }

    public String getDescription() {
        return StringUtil.localize("tooltip.computronics.gate.trigger." + this.tag);
    }

    public ITriggerExternal rotateLeft() {
        return this;
    }

    static {
        VALUES = Triggers.values();
    }
}

