/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.common.blocks.BlockFactory;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.modules.ModuleManager;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;

public abstract class RailcraftModule {
    public final List<BlockFactory> blockFactories = new ArrayList<BlockFactory>();

    public final void addBlockFactory(BlockFactory factory) {
        if (ModuleManager.getStage() != ModuleManager.Stage.PRE_INIT) {
            throw new RuntimeException("You can only define Block Factories in Pre-Init!");
        }
        this.blockFactories.add(factory);
    }

    public final void initBlocks() {
        for (BlockFactory factory : this.blockFactories) {
            factory.initBlock();
        }
    }

    public final void initRecipes(ModuleManager.Module module) {
        for (BlockFactory factory : this.blockFactories) {
            factory.initRecipes(module);
        }
    }

    public final void finalizeBlocks(ModuleManager.Module module) {
        for (BlockFactory factory : this.blockFactories) {
            factory.finalizeBlocks(module);
        }
    }

    public Set<ModuleManager.Module> getDependencies() {
        return EnumSet.noneOf(ModuleManager.Module.class);
    }

    public void preInit() {
    }

    public void initFirst() {
    }

    public void initSecond() {
    }

    public void postInit() {
    }

    public void postInitNotLoaded() {
    }

    public boolean canModuleLoad() {
        return true;
    }

    public void printLoadError() {
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGuiScreen(EnumGui gui, InventoryPlayer inv, Object obj, World world, int x, int y, int z) {
        return null;
    }

    public Container getGuiContainer(EnumGui gui, InventoryPlayer inv, Object obj, World world, int x, int y, int z) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

