/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.Arrays;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.ISignalBlockTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.RenderTools;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderTESRSignals
extends TileEntitySpecialRenderer {
    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        EntityLivingBase player;
        String name;
        if (tile instanceof IControllerTile) {
            if (EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.TUNING)) {
                this.renderPairs(tile, x, y, z, f, ((IControllerTile)tile).getController(), ColorProfile.RAINBOW);
            } else if (EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.SIGNALLING)) {
                this.renderPairs(tile, x, y, z, f, ((IControllerTile)tile).getController(), ColorProfile.ASPECT);
            }
        }
        if (tile instanceof ISignalBlockTile) {
            if (EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.SURVEYING)) {
                this.renderPairs(tile, x, y, z, f, ((ISignalBlockTile)tile).getSignalBlock(), ColorProfile.RAINBOW);
            } else if (EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.SIGNALLING)) {
                this.renderPairs(tile, x, y, z, f, ((ISignalBlockTile)tile).getSignalBlock(), ColorProfile.BLUE);
            }
        }
        AbstractPair pair = null;
        if (tile instanceof IReceiverTile) {
            pair = ((IReceiverTile)tile).getReceiver();
        } else if (tile instanceof IControllerTile) {
            pair = ((IControllerTile)tile).getController();
        } else if (tile instanceof ISignalBlockTile) {
            pair = ((ISignalBlockTile)tile).getSignalBlock();
        }
        if (pair != null && (name = pair.getName()) != null && (player = RenderManager.field_78727_a.field_78734_h) != null) {
            MovingObjectPosition mop;
            float viewDist = 8.0f;
            double dist = player.func_70092_e((double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5);
            if (dist <= 64.0 && (mop = player.func_70614_a(8.0, f)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && player.field_70170_p.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == tile) {
                RenderTools.renderString(name, x + 0.5, y + 1.5, z + 0.5);
            }
        }
    }

    private void renderPairs(TileEntity tile, double x, double y, double z, float f, AbstractPair pair, ColorProfile colorProfile) {
        if (pair.getPairs().isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glLineWidth((float)5.0f);
        GL11.glBegin((int)1);
        for (WorldCoordinate target : pair.getPairs()) {
            int color = colorProfile.getColor(tile, pair.getCoords(), target);
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor3f((float)c1, (float)c2, (float)c3);
            GL11.glVertex3f((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            float tx = (float)x + (float)target.x - (float)tile.field_145851_c;
            float ty = (float)y + (float)target.y - (float)tile.field_145848_d;
            float tz = (float)z + (float)target.z - (float)tile.field_145849_e;
            GL11.glVertex3f((float)(tx + 0.5f), (float)(ty + 0.5f), (float)(tz + 0.5f));
        }
        GL11.glEnd();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    protected static void doRenderAspect(RenderFakeBlock.RenderInfo info, TileEntity tile, double x, double y, double z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float depth = 0.125f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        tessellator.func_78382_b();
        if (info.brightness < 0) {
            float lightBottom = 0.5f;
            float light = info.light < 0.0f ? 1.0f : info.light;
            int br = info.brightness < 0 ? info.template.func_149677_c((IBlockAccess)tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e) : info.brightness;
            tessellator.func_78380_c(br);
            tessellator.func_78386_a(lightBottom * light, lightBottom * light, lightBottom * light);
        } else {
            tessellator.func_78380_c(info.brightness);
        }
        if (info.renderSide[2]) {
            tessellator.func_78374_a(0.0, 0.0, 0.125, (double)info.texture[2].func_94214_a(16.0), (double)info.texture[2].func_94207_b(16.0));
            tessellator.func_78374_a(0.0, 1.0, 0.125, (double)info.texture[2].func_94214_a(16.0), (double)info.texture[2].func_94207_b(0.0));
            tessellator.func_78374_a(1.0, 1.0, 0.125, (double)info.texture[2].func_94214_a(0.0), (double)info.texture[2].func_94207_b(0.0));
            tessellator.func_78374_a(1.0, 0.0, 0.125, (double)info.texture[2].func_94214_a(0.0), (double)info.texture[2].func_94207_b(16.0));
        }
        if (info.renderSide[3]) {
            tessellator.func_78374_a(0.0, 0.0, 0.875, (double)info.texture[3].func_94214_a(0.0), (double)info.texture[3].func_94207_b(16.0));
            tessellator.func_78374_a(1.0, 0.0, 0.875, (double)info.texture[3].func_94214_a(16.0), (double)info.texture[3].func_94207_b(16.0));
            tessellator.func_78374_a(1.0, 1.0, 0.875, (double)info.texture[3].func_94214_a(16.0), (double)info.texture[3].func_94207_b(0.0));
            tessellator.func_78374_a(0.0, 1.0, 0.875, (double)info.texture[3].func_94214_a(0.0), (double)info.texture[3].func_94207_b(0.0));
        }
        if (info.renderSide[4]) {
            tessellator.func_78374_a(0.125, 0.0, 0.0, (double)info.texture[4].func_94214_a(0.0), (double)info.texture[4].func_94207_b(16.0));
            tessellator.func_78374_a(0.125, 0.0, 1.0, (double)info.texture[4].func_94214_a(16.0), (double)info.texture[4].func_94207_b(16.0));
            tessellator.func_78374_a(0.125, 1.0, 1.0, (double)info.texture[4].func_94214_a(16.0), (double)info.texture[4].func_94207_b(0.0));
            tessellator.func_78374_a(0.125, 1.0, 0.0, (double)info.texture[4].func_94214_a(0.0), (double)info.texture[4].func_94207_b(0.0));
        }
        if (info.renderSide[5]) {
            tessellator.func_78374_a(0.875, 0.0, 0.0, (double)info.texture[5].func_94214_a(16.0), (double)info.texture[5].func_94207_b(16.0));
            tessellator.func_78374_a(0.875, 1.0, 0.0, (double)info.texture[5].func_94214_a(16.0), (double)info.texture[5].func_94207_b(0.0));
            tessellator.func_78374_a(0.875, 1.0, 1.0, (double)info.texture[5].func_94214_a(0.0), (double)info.texture[5].func_94207_b(0.0));
            tessellator.func_78374_a(0.875, 0.0, 1.0, (double)info.texture[5].func_94214_a(0.0), (double)info.texture[5].func_94207_b(16.0));
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public static enum ColorProfile {
        RAINBOW{
            private final WorldCoordinate[] coords = new WorldCoordinate[2];
            private final boolean apiUpdated = Comparable.class.isAssignableFrom(WorldCoordinate.class);

            @Override
            public int getColor(TileEntity tile, WorldCoordinate source, WorldCoordinate target) {
                this.coords[0] = source;
                this.coords[1] = target;
                if (this.apiUpdated) {
                    Arrays.sort(this.coords);
                }
                return Arrays.hashCode(this.coords);
            }
        }
        ,
        BLUE{

            @Override
            public int getColor(TileEntity tile, WorldCoordinate source, WorldCoordinate target) {
                return EnumColor.BLUE.getHexColor();
            }
        }
        ,
        ASPECT{

            @Override
            public int getColor(TileEntity tile, WorldCoordinate source, WorldCoordinate target) {
                if (tile instanceof IControllerTile) {
                    SignalAspect aspect = ((IControllerTile)tile).getController().getAspectFor(target);
                    switch (aspect) {
                        case GREEN: {
                            return EnumColor.LIME.getHexColor();
                        }
                        case YELLOW: 
                        case BLINK_YELLOW: {
                            return EnumColor.YELLOW.getHexColor();
                        }
                    }
                    return EnumColor.RED.getHexColor();
                }
                return BLUE.getColor(tile, source, target);
            }
        };


        public abstract int getColor(TileEntity var1, WorldCoordinate var2, WorldCoordinate var3);
    }
}

