/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.helper;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.astronomy.AngleDistance;
import de.katzenpapst.amunra.mothership.Mothership;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;

public class AstronomyHelper {
    public static final long yearFactor = 8640000L;
    public static final long monthFactor = 192000L;
    public static final double moonDistanceFactor = 1.5E-4;
    public static final double planetDistanceFactor = 1.0;
    public static final double systemDistanceFactor = 0.011504250961025843;
    public static final float maxTemperature = 5.0f;
    public static final float maxSolarLevel = 10.0f;
    public static final double AUlength = 1.495978707E11;
    public static final double maxSpeed = 2.99792458E8;
    public static final String nameSeparator = "\\";

    public static AngleDistance projectBodyToSky(CelestialBody curBody, CelestialBody otherBody, float partialTicks, long worldTime) {
        double curBodyDist = curBody.getRelativeDistanceFromCenter().unScaledDistance;
        double otherBodyDist = otherBody.getRelativeDistanceFromCenter().unScaledDistance;
        double curBodyOrbitalAngle = AstronomyHelper.getOrbitalAngle(curBodyDist, curBody.getPhaseShift(), worldTime, partialTicks, 8640000.0);
        double otherBodyOrbitalAngle = AstronomyHelper.getOrbitalAngle(otherBody.getRelativeOrbitTime(), otherBody.getPhaseShift(), worldTime, partialTicks, 8640000.0);
        double innerAngle = Math.PI - (otherBodyOrbitalAngle -= Math.PI * 2 - curBodyOrbitalAngle);
        float distanceToPlanet = (float)AstronomyHelper.getDistanceBetweenBodies(innerAngle, curBodyDist, otherBodyDist);
        float projectedAngle = (float)AstronomyHelper.projectAngle(innerAngle, curBodyDist, otherBodyDist, distanceToPlanet);
        return new AngleDistance(projectedAngle, distanceToPlanet);
    }

    public static double getOrbitalAngle(double relOrbitTime, double phaseShift, long worldTime, double partialTicks, double orbitFactor) {
        double curYearLength = relOrbitTime * orbitFactor;
        int j = (int)(worldTime % (long)curYearLength);
        double orbitPos = ((double)j + partialTicks) / curYearLength - 0.25;
        return orbitPos * 2.0 * Math.PI + phaseShift;
    }

    public static double getDistanceBetweenBodies(double innerAngle, double body1distance, double body2distance) {
        return Math.sqrt(Math.pow(body2distance, 2.0) + Math.pow(body1distance, 2.0) - 2.0 * body2distance * body1distance * Math.cos(innerAngle));
    }

    public static double projectAngle(double innerAngle, double body1distance, double body2distance, double distanceBetweenBodies) {
        double sinBeta = Math.sin(innerAngle);
        double angleAroundCurBody = Math.asin(body2distance * sinBeta / distanceBetweenBodies);
        if (body1distance > body2distance) {
            return angleAroundCurBody;
        }
        double delta = Math.asin(sinBeta / distanceBetweenBodies * body1distance);
        double angleSum = innerAngle + delta + angleAroundCurBody;
        if (Math.abs(Math.abs(angleSum) / Math.PI - 1.0) < 0.001) {
            return angleAroundCurBody;
        }
        return Math.PI - angleAroundCurBody;
    }

    public static CelestialBody getClosestCommonParent(CelestialBody body1, CelestialBody body2) {
        Planet planet1;
        IChildBody child1;
        Mothership ship1;
        if (body1 == null || body2 == null) {
            return null;
        }
        if (body1.equals((Object)body2)) {
            return body1;
        }
        if (body1 instanceof Mothership) {
            ship1 = (Mothership)body1;
            if (!(body2 instanceof Mothership)) {
                return AstronomyHelper.getClosestCommonParent(ship1.getParent(), body2);
            }
        }
        if (body2 instanceof Mothership) {
            Mothership ship2 = (Mothership)body2;
            if (!(body1 instanceof Mothership)) {
                return AstronomyHelper.getClosestCommonParent(body1, ship2.getParent());
            }
        }
        if (body1 instanceof Mothership) {
            ship1 = (Mothership)body1;
            if (body2 instanceof Mothership) {
                Mothership ship2 = (Mothership)body2;
                return AstronomyHelper.getClosestCommonParent(ship1.getParent(), ship2.getParent());
            }
        }
        if (body1 instanceof IChildBody) {
            child1 = (IChildBody)body1;
            if (!(body2 instanceof IChildBody)) {
                return AstronomyHelper.getClosestCommonParent((CelestialBody)child1.getParentPlanet(), body2);
            }
        }
        if (body2 instanceof IChildBody) {
            IChildBody child2 = (IChildBody)body2;
            if (!(body1 instanceof IChildBody)) {
                return AstronomyHelper.getClosestCommonParent(body1, (CelestialBody)child2.getParentPlanet());
            }
        }
        if (body1 instanceof IChildBody) {
            child1 = (IChildBody)body1;
            if (body2 instanceof IChildBody) {
                IChildBody child2 = (IChildBody)body2;
                return AstronomyHelper.getClosestCommonParent((CelestialBody)child1.getParentPlanet(), (CelestialBody)child2.getParentPlanet());
            }
        }
        if (body1 instanceof Planet) {
            planet1 = (Planet)body1;
            if (!(body2 instanceof Planet)) {
                return AstronomyHelper.getClosestCommonParent((CelestialBody)planet1.getParentSolarSystem().getMainStar(), body2);
            }
        }
        if (body2 instanceof Planet) {
            Planet planet2 = (Planet)body2;
            if (!(body1 instanceof Planet)) {
                return AstronomyHelper.getClosestCommonParent(body1, (CelestialBody)planet2.getParentSolarSystem().getMainStar());
            }
        }
        if (body1 instanceof Planet) {
            planet1 = (Planet)body1;
            if (body2 instanceof Planet) {
                Planet planet2 = (Planet)body2;
                return AstronomyHelper.getClosestCommonParent((CelestialBody)planet1.getParentSolarSystem().getMainStar(), (CelestialBody)planet2.getParentSolarSystem().getMainStar());
            }
        }
        return null;
    }

    public static CelestialBody getCelestialBodyParent(CelestialBody body) {
        if (body instanceof Planet) {
            Planet planet = (Planet)body;
            return planet.getParentSolarSystem().getMainStar();
        }
        if (body instanceof IChildBody) {
            IChildBody child = (IChildBody)body;
            return child.getParentPlanet();
        }
        if (body instanceof Mothership) {
            Mothership ship = (Mothership)body;
            return ship.getParent();
        }
        if (body instanceof Star) {
            return body;
        }
        return null;
    }

    public static CelestialBody getParentPlanet(CelestialBody body) {
        if (body instanceof Moon) {
            Moon moon = (Moon)body;
            return moon.getParentPlanet();
        }
        if (body instanceof IChildBody) {
            IChildBody child = (IChildBody)body;
            return child.getParentPlanet();
        }
        if (body instanceof Mothership) {
            Mothership ship = (Mothership)body;
            return AstronomyHelper.getParentPlanet(ship.getParent());
        }
        return body;
    }

    protected static String getSystemMainStarName(SolarSystem sys) {
        return sys.getName();
    }

    protected static String getPlanetName(Planet planet) {
        return AstronomyHelper.getSystemMainStarName(planet.getParentSolarSystem()) + nameSeparator + planet.getName();
    }

    protected static String getMoonName(Moon moon) {
        return AstronomyHelper.getPlanetName(moon.getParentPlanet()) + nameSeparator + moon.getName();
    }

    public static String getOrbitableBodyName(CelestialBody body) {
        if (body instanceof Star) {
            Star star = (Star)body;
            return AstronomyHelper.getSystemMainStarName(star.getParentSolarSystem());
        }
        if (body instanceof Planet) {
            Planet planet = (Planet)body;
            return AstronomyHelper.getPlanetName(planet);
        }
        if (body instanceof Moon) {
            Moon moon = (Moon)body;
            return AstronomyHelper.getMoonName(moon);
        }
        throw new RuntimeException("Invalid celestialbody for " + body.getName());
    }

    public static String getDebugBodyName(CelestialBody body) {
        if (body instanceof Mothership) {
            Mothership ms = (Mothership)body;
            return "Mothership #" + ms.getID() + ", \"" + ms.getLocalizedName() + "\", DIM ID " + ms.getDimensionID();
        }
        if (body instanceof Satellite) {
            return AstronomyHelper.getOrbitableBodyName(AstronomyHelper.getParentPlanet(body)) + nameSeparator + "Space Station";
        }
        return AstronomyHelper.getOrbitableBodyName(body);
    }

    public static SolarSystem getSolarSystem(CelestialBody body) {
        if (body instanceof Star) {
            Star star = (Star)body;
            return star.getParentSolarSystem();
        }
        if (body instanceof Planet) {
            Planet planet = (Planet)body;
            return planet.getParentSolarSystem();
        }
        if (body instanceof IChildBody) {
            IChildBody child = (IChildBody)body;
            return child.getParentPlanet().getParentSolarSystem();
        }
        if (body instanceof Mothership) {
            Mothership ship = (Mothership)body;
            return AstronomyHelper.getSolarSystem(ship.getDestination());
        }
        return null;
    }

    public static boolean isStar(CelestialBody body) {
        return body instanceof Star || body == AmunRa.instance.starAmun || AmunRa.config.isSun(body);
    }

    private static double getDistanceToParent(CelestialBody parent, CelestialBody child) {
        double result = 0.0;
        while (!parent.equals((Object)child)) {
            if (child instanceof IChildBody) {
                result += (double)child.getRelativeDistanceFromCenter().unScaledDistance * 1.5E-4;
            } else if (child instanceof Planet) {
                result += (double)child.getRelativeDistanceFromCenter().unScaledDistance * 1.0;
            }
            child = AstronomyHelper.getCelestialBodyParent(child);
        }
        return result;
    }

    public static double getDistance(CelestialBody body1, CelestialBody body2) {
        CelestialBody commonParent;
        if (body1.equals((Object)body2)) {
            return 0.0;
        }
        if (body1 instanceof Mothership) {
            body1 = AstronomyHelper.getCelestialBodyParent(body1);
        }
        if (body2 instanceof Mothership) {
            body2 = AstronomyHelper.getCelestialBodyParent(body2);
        }
        if ((commonParent = AstronomyHelper.getClosestCommonParent(body1, body2)) == null) {
            SolarSystem sys1 = AstronomyHelper.getSolarSystem(body1);
            SolarSystem sys2 = AstronomyHelper.getSolarSystem(body2);
            Vector3 pos1 = sys1.getMapPosition();
            Vector3 pos2 = sys2.getMapPosition();
            double result = pos1.distance(pos2) * 0.011504250961025843;
            result += AstronomyHelper.getDistanceToParent((CelestialBody)sys1.getMainStar(), body1);
            return result += AstronomyHelper.getDistanceToParent((CelestialBody)sys2.getMainStar(), body2);
        }
        if (body1.equals((Object)commonParent)) {
            return AstronomyHelper.getDistanceToParent(commonParent, body2);
        }
        if (body2.equals((Object)commonParent)) {
            return AstronomyHelper.getDistanceToParent(commonParent, body1);
        }
        if (body1 instanceof IChildBody && body2 instanceof IChildBody && commonParent instanceof Planet) {
            return (double)Math.abs(body1.getRelativeDistanceFromCenter().unScaledDistance - body2.getRelativeDistanceFromCenter().unScaledDistance) * 1.5E-4;
        }
        double result = 0.0;
        if (body1 instanceof IChildBody) {
            result += (double)body1.getRelativeDistanceFromCenter().unScaledDistance * 1.5E-4;
            body1 = AstronomyHelper.getCelestialBodyParent(body1);
        }
        if (body2 instanceof IChildBody) {
            result += (double)body2.getRelativeDistanceFromCenter().unScaledDistance * 1.5E-4;
            body2 = AstronomyHelper.getCelestialBodyParent(body2);
        }
        float dist1 = body1.getRelativeDistanceFromCenter().unScaledDistance;
        float dist2 = body2.getRelativeDistanceFromCenter().unScaledDistance;
        return result += (double)Math.abs(dist1 - dist2) * 1.0;
    }

    public static float getThermalLevel(CelestialBody body) {
        if (body instanceof Star) {
            return 5.0f;
        }
        body = AstronomyHelper.getParentPlanet(body);
        float dist = body.getRelativeDistanceFromCenter().unScaledDistance;
        float temperature = -4.0f * dist + 4.0f;
        if (temperature < -5.0f) {
            temperature = -5.0f;
        } else if (temperature > 5.0f) {
            temperature = 5.0f;
        }
        return temperature;
    }

    public static float getSolarEnergyMultiplier(CelestialBody body, boolean hasAtmosphere) {
        if (body instanceof Star) {
            return 2.0f;
        }
        body = AstronomyHelper.getParentPlanet(body);
        float solarSize = 1.0f / body.getRelativeDistanceFromCenter().unScaledDistance;
        float level = solarSize * solarSize * solarSize;
        if (!hasAtmosphere) {
            level = (float)((double)level * ConfigManagerCore.spaceStationEnergyScalar);
        }
        if (level > 10.0f) {
            level = 10.0f;
        }
        return level;
    }

    public static long getTravelTime(double shipMass, double engineForce, double distance) {
        if (shipMass <= 0.0 || engineForce <= 0.0) {
            return -1L;
        }
        if (distance == 0.0) {
            return 0L;
        }
        double halfDistance = distance / 2.0;
        double accel = engineForce / shipMass;
        double tEnd = 2.99792458E8 / accel;
        double time = Math.sqrt(2.0 * halfDistance / (accel * (double)AmunRa.config.mothershipSpeedFactor));
        if (time > tEnd) {
            double halfDistanceReached = 0.5 * accel * tEnd;
            double halfDistanceRemaining = halfDistance - halfDistanceReached;
            double tRemaining = halfDistanceRemaining / 2.99792458E8;
            time = tEnd + tRemaining;
        }
        return (long)(2.0 * time);
    }

    public static long getTravelTimeAU(double shipMass, double engineForce, double distance) {
        return AstronomyHelper.getTravelTime(shipMass, engineForce, distance * 1.495978707E11);
    }
}

