/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.storage;

import appeng.api.AEApi;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellCacheRegistry;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEPassThrough;
import appeng.util.item.AEFluidStack;
import appeng.util.prioitylist.IPartitionList;
import appeng.util.prioitylist.PrecisePriorityList;
import com.glodblock.github.common.storage.CreativeFluidCellInventory;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IFluidCellInventoryHandler;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.Util;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidCellInventoryHandler
extends MEInventoryHandler<IAEFluidStack>
implements IFluidCellInventoryHandler,
ICellCacheRegistry {
    protected FluidCellInventoryHandler(IMEInventory<IAEFluidStack> c) {
        super(c, StorageChannel.FLUIDS);
        IFluidCellInventory ci = this.getCellInv();
        if (ci != null) {
            IInventory config = ci.getConfigInventory();
            IItemList priorityList = AEApi.instance().storage().createFluidList();
            for (int x = 0; x < config.func_70302_i_(); ++x) {
                ItemStack is = config.func_70301_a(x);
                FluidStack fluid = Util.getFluidFromItem(is);
                if (fluid == null) continue;
                priorityList.add((IAEStack)AEFluidStack.create((Object)fluid));
            }
            if (!priorityList.isEmpty()) {
                this.setPartitionList((IPartitionList)new PrecisePriorityList(priorityList));
            }
            IInventory upgrades = ci.getUpgradesInventory();
            boolean hasSticky = false;
            for (int x = 0; x < upgrades.func_70302_i_(); ++x) {
                Upgrades u;
                ItemStack is = upgrades.func_70301_a(x);
                if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) != Upgrades.STICKY) continue;
                hasSticky = true;
                break;
            }
            if (hasSticky) {
                this.setSticky(true);
            }
        }
    }

    @Override
    public IFluidCellInventory getCellInv() {
        IMEInventory<?> o = this.getInternal();
        if (o instanceof MEPassThrough) {
            o = Ae2Reflect.getInternal((MEPassThrough)o);
        }
        return (IFluidCellInventory)(o instanceof IFluidCellInventory ? o : null);
    }

    @Override
    public Iterable<IAEFluidStack> getPartitionInv() {
        return Ae2Reflect.getPartitionList(this).getItems();
    }

    @Override
    public boolean isPreformatted() {
        return !Ae2Reflect.getPartitionList(this).isEmpty();
    }

    @Override
    public IncludeExclude getIncludeExcludeMode() {
        return IncludeExclude.WHITELIST;
    }

    public int getStatusForCell() {
        int val = this.getCellInv().getStatusForCell();
        if ((val == 1 || val == 2) && this.isPreformatted()) {
            val = 3;
        }
        return val;
    }

    public boolean canGetInv() {
        IFluidCellInventory cellInv = this.getCellInv();
        return !(cellInv instanceof CreativeFluidCellInventory);
    }

    public long getTotalBytes() {
        return this.getCellInv().getTotalBytes();
    }

    public long getFreeBytes() {
        return this.getCellInv().getFreeBytes();
    }

    public long getUsedBytes() {
        return this.getCellInv().getUsedBytes();
    }

    public long getTotalTypes() {
        return this.getCellInv().getTotalFluidTypes();
    }

    public long getFreeTypes() {
        return this.getCellInv().getRemainingFluidTypes();
    }

    public long getUsedTypes() {
        return this.getCellInv().getStoredFluidTypes();
    }

    public int getCellStatus() {
        return this.getStatusForCell();
    }

    public ICellCacheRegistry.TYPE getCellType() {
        return ICellCacheRegistry.TYPE.FLUID;
    }
}

