/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import glowredman.amazingtrophies.AmazingTrophies;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.api.AchievementProperties;
import glowredman.amazingtrophies.api.AmazingTrophiesAPI;
import glowredman.amazingtrophies.api.ConditionHandler;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.AchievementPage;

public class AchievementHandler {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_CONDITION = "condition";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_PAGE = "page";
    public static final String PROPERTY_X = "x";
    public static final String PROPERTY_Y = "y";
    public static final String PROPERTY_PARENT = "parent";
    public static final String PROPERTY_IS_SPECIAL = "isSpecial";
    public static final String PROPERTY_ICON = "icon";
    private static final Collection<String> PAGES = new HashSet<String>();

    static void parseAchievement(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        String id = ConfigHandler.getStringProperty(json, PROPERTY_ID);
        try {
            String type;
            JsonObject conditionJson = json.getAsJsonObject(PROPERTY_CONDITION);
            ConditionHandler conditionHandler = null;
            if (conditionJson != null && !conditionJson.isJsonNull() && conditionJson.entrySet().size() > 0 && (conditionHandler = AmazingTrophiesAPI.getAchievementConditionHandler(type = ConfigHandler.getStringProperty(conditionJson, PROPERTY_TYPE))) == null) {
                throw new IllegalArgumentException("Referencing unknown condition type: \"" + type + "\"");
            }
            AchievementProperties props = new AchievementProperties.Builder(ConfigHandler.getIntegerProperty(json, PROPERTY_X), ConfigHandler.getIntegerProperty(json, PROPERTY_Y), ConfigHandler.getItemProperty(json, PROPERTY_ICON, 0)).setPage(ConfigHandler.getStringProperty(json, PROPERTY_PAGE, null)).setParent(ConfigHandler.getStringProperty(json, PROPERTY_PARENT, null)).setSpecial(ConfigHandler.getBooleanProperty(json, PROPERTY_IS_SPECIAL, false)).build();
            if (conditionHandler != null) {
                conditionHandler.parse(id, conditionJson);
            }
            PAGES.add(props.getPage());
            AmazingTrophiesAPI.registerAchievement(id, props);
        }
        catch (Exception e) {
            AmazingTrophies.LOGGER.error("Failed to parse achievement \"" + id + "\"!", (Throwable)e);
        }
    }

    static void registerMissingPages() {
        PAGES.remove(null);
        for (String name : PAGES) {
            try {
                AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage(name, new Achievement[0]));
            }
            catch (Exception exception) {}
        }
        PAGES.clear();
    }
}

