/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.Avaritia;
import fox.spiteful.avaritia.entity.EntityImmortalItem;
import fox.spiteful.avaritia.items.LudicrousItems;
import fox.spiteful.avaritia.items.tools.ToolHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemPickaxeInfinity
extends ItemPickaxe {
    private static final Item.ToolMaterial opPickaxe = EnumHelper.addToolMaterial((String)"INFINITY_PICKAXE", (int)32, (int)9999, (float)9999.0f, (float)6.0f, (int)200);
    private IIcon hammer;
    public static final Material[] MATERIALS = new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B};

    public ItemPickaxeInfinity() {
        super(opPickaxe);
        this.func_77655_b("infinity_pickaxe");
        this.func_77637_a(Avaritia.tab);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        ItemStack pick = new ItemStack((Item)this);
        pick.func_77966_a(Enchantment.field_77346_s, 10);
        list.add(pick);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return LudicrousItems.cosmic;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("hammer")) {
            return 5.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return this.field_77864_a;
        }
        return Math.max(this.func_150893_a(stack, block), 6.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("avaritia:infinity_pickaxe");
        this.hammer = ir.func_94245_a("avaritia:infinity_hammer");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null && tags.func_74767_n("hammer")) {
            return this.hammer;
        }
        return this.field_77791_bV;
    }

    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            NBTTagCompound tags = stack.func_77978_p();
            if (tags == null) {
                tags = new NBTTagCompound();
                stack.func_77982_d(tags);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack) < 10) {
                stack.func_77966_a(Enchantment.field_77346_s, 10);
            }
            tags.func_74757_a("hammer", !tags.func_74767_n("hammer"));
            player.func_71038_i();
        }
        return stack;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase victim, EntityLivingBase player) {
        if (!(stack.func_77978_p() == null || !stack.func_77978_p().func_74767_n("hammer") || victim instanceof EntityPlayer && LudicrousItems.isInfinite((EntityPlayer)victim))) {
            int i = 10;
            victim.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 2.0, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        MovingObjectPosition raycast;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("hammer") && (raycast = ToolHelper.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 10.0)) != null) {
            this.breakOtherBlock(player, stack, x, y, z, x, y, z, raycast.field_72310_e);
        }
        return false;
    }

    public void breakOtherBlock(EntityPlayer player, ItemStack stack, int x, int y, int z, int originX, int originY, int originZ, int side) {
        World world = player.field_70170_p;
        Material mat = world.func_147439_a(x, y, z).func_149688_o();
        if (!ToolHelper.isRightMaterial(mat, MATERIALS)) {
            return;
        }
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        boolean silk = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
        boolean doY = direction.offsetY == 0;
        int range = 8;
        ToolHelper.removeBlocksInIteration(player, stack, world, x, y, z, -range, doY ? -1 : -range, -range, range, doY ? range * 2 - 2 : range, range, null, MATERIALS, silk, fortune, false);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityImmortalItem(world, location, itemstack);
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }
}

