/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.string;

import com.creativemd.creativecore.common.utils.string.ConvertArray;
import com.creativemd.creativecore.common.utils.string.ConvertBlock;
import com.creativemd.creativecore.common.utils.string.ConvertByte;
import com.creativemd.creativecore.common.utils.string.ConvertDouble;
import com.creativemd.creativecore.common.utils.string.ConvertFloat;
import com.creativemd.creativecore.common.utils.string.ConvertInfo;
import com.creativemd.creativecore.common.utils.string.ConvertInteger;
import com.creativemd.creativecore.common.utils.string.ConvertItem;
import com.creativemd.creativecore.common.utils.string.ConvertItemStack;
import com.creativemd.creativecore.common.utils.string.ConvertLong;
import com.creativemd.creativecore.common.utils.string.ConvertNBTTagCompound;
import com.creativemd.creativecore.common.utils.string.ConvertNBTTagList;
import com.creativemd.creativecore.common.utils.string.ConvertShort;
import com.creativemd.creativecore.common.utils.string.ConvertString;
import com.creativemd.creativecore.common.utils.string.StringConverter;
import java.util.ArrayList;

public class StringUtils {
    public static String ObjectsToString(Object ... objects) {
        String result = "{";
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != null) {
                StringConverter converter = StringConverter.getConverter(objects[i].getClass());
                if (converter == null) continue;
                result = result + converter.UUID + ":" + converter.toString(objects[i]) + ";";
                continue;
            }
            result = result + "null:null;";
        }
        result = result + "}";
        return result;
    }

    public static Object[] StringToObjects(String input) {
        if (input.startsWith("{") && input.endsWith("}")) {
            int index = 0;
            int end = StringUtils.getBraceLength(index, input);
            ArrayList<Integer> breaks = new ArrayList<Integer>();
            ++index;
            while (index < end) {
                String currentChar = input.substring(index, index + 1);
                if (currentChar.equals("{")) {
                    index += StringUtils.getBraceLength(index, input) - 1;
                }
                if (currentChar.equals(";")) {
                    breaks.add(index);
                }
                ++index;
            }
            ArrayList<Object> objects = new ArrayList<Object>();
            for (int i = 0; i < breaks.size(); ++i) {
                int beforeIndex = 1;
                if (i > 0) {
                    beforeIndex = (Integer)breaks.get(i - 1) + 1;
                }
                String objectString = StringConverter.loadString(input.substring(beforeIndex, (Integer)breaks.get(i)));
                String UUID2 = objectString.substring(0, objectString.indexOf(":"));
                String objectInput = objectString.substring(objectString.indexOf(":") + 1);
                StringConverter converter = StringConverter.getConverter(UUID2);
                if (converter != null) {
                    Object object = converter.parseObject(objectInput);
                    if (object == null) continue;
                    objects.add(object);
                    continue;
                }
                if (!UUID2.equals("null")) continue;
                objects.add(null);
            }
            return objects.toArray();
        }
        System.out.println("[CraftingManagerAPI] Invalid string: '" + input + "'");
        return new Object[0];
    }

    protected static int getBraceLength(int StartIndex, String input) {
        int braces = 0;
        int index = StartIndex;
        if (input.substring(StartIndex, StartIndex + 1).equals("{")) {
            ++braces;
        }
        ++index;
        while (index < input.length() && braces > 0) {
            if (input.substring(index, index + 1).equals("{")) {
                ++braces;
            }
            if (input.substring(index, index + 1).equals("}")) {
                --braces;
            }
            ++index;
        }
        return index - StartIndex;
    }

    protected static String getBraceString(int StartIndex, String input) {
        return input.substring(StartIndex, StartIndex + StringUtils.getBraceLength(StartIndex, input));
    }

    static {
        StringConverter.splitters.add("{");
        StringConverter.splitters.add("}");
        StringConverter.splitters.add(":");
        StringConverter.splitters.add(";");
        StringConverter.registerConverter(new ConvertBlock());
        StringConverter.registerConverter(new ConvertByte());
        StringConverter.registerConverter(new ConvertDouble());
        StringConverter.registerConverter(new ConvertFloat());
        StringConverter.registerConverter(new ConvertInfo());
        StringConverter.registerConverter(new ConvertInteger());
        StringConverter.registerConverter(new ConvertItem());
        StringConverter.registerConverter(new ConvertItemStack());
        StringConverter.registerConverter(new ConvertLong());
        StringConverter.registerConverter(new ConvertNBTTagCompound());
        StringConverter.registerConverter(new ConvertNBTTagList());
        StringConverter.registerConverter(new ConvertShort());
        StringConverter.registerConverter(new ConvertString());
        StringConverter.registerConverter(new ConvertArray());
    }
}

