/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cofh.api.energy.IEnergyHandler;
import java.util.Iterator;
import net.minecraftforge.common.util.ForgeDirection;
import stevesaddons.helpers.StevesEnum;
import stevesaddons.tileentities.TileEntityRFNode;
import vswe.stevesfactory.blocks.TileEntityCluster;

public class TileEntityRFCluster
extends TileEntityCluster
implements IEnergyHandler {
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int toReceive = 0;
        for (TileEntityCluster.Pair i : this.getRegistrations(StevesEnum.RECEIVE_ENERGY)) {
            toReceive += ((TileEntityRFNode)i.te).receiveEnergy(from, maxReceive - toReceive, simulate);
        }
        return toReceive;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int toExtract = maxExtract;
        for (TileEntityCluster.Pair i : this.getRegistrations(StevesEnum.EXTRACT_ENERGY)) {
            toExtract -= ((TileEntityRFNode)i.te).extractEnergy(from, toExtract, simulate);
        }
        return maxExtract - toExtract;
    }

    public int getEnergyStored(ForgeDirection from) {
        Iterator iterator = this.getRegistrations(StevesEnum.CONNECT_ENERGY).iterator();
        if (iterator.hasNext()) {
            TileEntityCluster.Pair i = (TileEntityCluster.Pair)iterator.next();
            return ((TileEntityRFNode)i.te).getEnergyStored(from);
        }
        return -1;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        Iterator iterator = this.getRegistrations(StevesEnum.CONNECT_ENERGY).iterator();
        if (iterator.hasNext()) {
            TileEntityCluster.Pair i = (TileEntityCluster.Pair)iterator.next();
            return ((TileEntityRFNode)i.te).getMaxEnergyStored(from);
        }
        return -1;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        for (TileEntityCluster.Pair i : this.getRegistrations(StevesEnum.CONNECT_ENERGY)) {
            if (!((TileEntityRFNode)i.te).canConnectEnergy(from)) continue;
            return true;
        }
        return false;
    }
}

