/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.attacks.special;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.dragon.attacks.special.DragonSpecialAttackBase;
import chylex.hee.entity.boss.dragon.attacks.special.event.DamageTakenEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetPositionSetEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetSetEvent;
import chylex.hee.entity.fx.FXType;
import chylex.hee.entity.mob.EntityMobVampiricBat;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C20Effect;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;

public class DragonAttackBloodlust
extends DragonSpecialAttackBase {
    private byte timer;
    private byte counter;
    private boolean ended;

    public DragonAttackBloodlust(EntityBossDragon dragon, int attackId, int weight) {
        super(dragon, attackId, weight);
    }

    @Override
    public void init() {
        super.init();
        this.timer = (byte)40;
        this.counter = 0;
        this.ended = false;
        this.dragon.target = null;
        this.dragon.targetY = 86.0;
    }

    @Override
    public void update() {
        super.update();
        this.timer = (byte)(this.timer + 1);
        if (this.timer > 125 - this.getDifficulty() * 10) {
            this.timer = (byte)-10;
            for (EntityPlayer player : this.dragon.attacks.getViablePlayers()) {
                EntityEnderman enderman = (EntityEnderman)DragonUtil.getClosestEntity((Entity)player, this.dragon.field_70170_p.func_72872_a(EntityEnderman.class, player.field_70121_D.func_72314_b(18.0, 8.0, 18.0)));
                if (enderman == null) {
                    BlockPosM tmpPos = BlockPosM.tmp();
                    for (int attempt = 0; attempt < 40; ++attempt) {
                        float rad = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                        double len = 10.0 + this.rand.nextDouble() * 8.0;
                        tmpPos.x = (int)Math.round(player.field_70165_t + (double)MathHelper.func_76126_a((float)rad) * len);
                        tmpPos.y = (int)Math.round(player.field_70163_u - (this.rand.nextDouble() - 0.5) * 6.0);
                        tmpPos.z = (int)Math.round(player.field_70161_v + (double)MathHelper.func_76134_b((float)rad) * len);
                        if (tmpPos.isAir(this.dragon.field_70170_p)) break;
                    }
                    for (int a = 0; a < 2 + this.rand.nextInt(3) + (this.getDifficulty() >> 1); ++a) {
                        for (int attempt = 0; attempt < 6 && !tmpPos.move(this.rand.nextInt(3) - 1, this.rand.nextInt(3) - 1, this.rand.nextInt(3) - 1).isAir(this.dragon.field_70170_p); ++attempt) {
                        }
                        this.spawnBatAt(tmpPos.x, tmpPos.y, tmpPos.z, player);
                    }
                    continue;
                }
                for (int a = 0; a < 2 + this.rand.nextInt(3) + (this.getDifficulty() >> 1); ++a) {
                    this.spawnBatAt(enderman.field_70165_t + this.rand.nextDouble() - 0.5, enderman.field_70163_u + this.rand.nextDouble() * (double)enderman.field_70131_O, enderman.field_70161_v + this.rand.nextDouble() - 0.5, player);
                }
                enderman.func_70106_y();
                PacketPipeline.sendToAllAround((Entity)enderman, 64.0, (AbstractPacket)new C20Effect(FXType.Basic.ENDERMAN_BLOODLUST_TRANSFORMATION, (Entity)enderman));
            }
            this.counter = (byte)(this.counter + 1);
            if (this.counter > 2 + (this.getDifficulty() >> 1) + this.rand.nextInt(4)) {
                this.ended = true;
            }
        }
        if (this.dragon.field_70173_aa % 10 == 0 && MathUtil.distance(this.dragon.field_70165_t, this.dragon.field_70161_v) > 100.0) {
            this.dragon.targetX = (this.rand.nextDouble() - 0.5) * 60.0;
            this.dragon.targetZ = (this.rand.nextDouble() - 0.5) * 60.0;
        }
    }

    private void spawnBatAt(double x, double y, double z, EntityPlayer target) {
        EntityMobVampiricBat bat = new EntityMobVampiricBat(this.dragon.field_70170_p);
        bat.func_70107_b(x, y, z);
        bat.target = target;
        this.dragon.field_70170_p.func_72838_d((Entity)bat);
    }

    @Override
    public boolean canStart() {
        return this.dragon.attacks.getHealthPercentage() < 40;
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    @Override
    public int getNextAttackTimer() {
        return super.getNextAttackTimer() + 70;
    }

    @Override
    public float overrideMovementSpeed() {
        return 0.6f;
    }

    @Override
    public void onDamageTakenEvent(DamageTakenEvent event) {
        event.damage *= 0.2f;
    }

    @Override
    public void onTargetPositionSetEvent(TargetPositionSetEvent event) {
        event.newTargetY = 80.0 + this.rand.nextDouble() * 12.0;
    }

    @Override
    public void onTargetSetEvent(TargetSetEvent event) {
        event.newTarget = null;
    }
}

