/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.loader;

import com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement.PlatinumSludgeOverHaul;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import goodgenerator.items.MyMaterial;
import goodgenerator.main.GG_Config_Loader;
import goodgenerator.util.CrackRecipeAdder;
import goodgenerator.util.ItemRefer;
import goodgenerator.util.MyRecipeAdder;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.maps.AssemblerBackend;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.CombType;
import gregtech.common.items.GT_MetaGenerated_Item_01;
import gregtech.loaders.misc.GT_Bees;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.lib.CORE;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.reflect.FieldUtils;

public class NaquadahReworkRecipeLoader {
    public static void RecipeLoad() {
        if (!GG_Config_Loader.EnableNaquadahRework) {
            return;
        }
        if (Mods.GTPlusPlus.isModLoaded()) {
            try {
                CORE.RA.addQuantumTransformerRecipe(new ItemStack[]{MyMaterial.naquadahEarth.get(OrePrefixes.dust, 32), Materials.Sodium.getDust(64), Materials.Carbon.getDust(1), GT_Utility.copyAmount((int)0, (ItemStack)GenericChem.mSimpleNaquadahCatalyst)}, new FluidStack[]{Materials.Hydrogen.getGas(64000L), Materials.Fluorine.getGas(64000L), Materials.Oxygen.getGas(100L)}, new FluidStack[0], new ItemStack[]{MyMaterial.inertNaquadah.get(OrePrefixes.dust, 1), Materials.Titanium.getDust(64), Materials.Adamantium.getDust(64), Materials.Gallium.getDust(64)}, new int[]{2500, 2500, 2500, 2500}, 200, (int)GT_Values.VP[10], 2);
                CORE.RA.addQuantumTransformerRecipe(new ItemStack[]{MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 32), Materials.Zinc.getDust(64), Materials.Carbon.getDust(1), GT_Utility.copyAmount((int)0, (ItemStack)GenericChem.mSimpleNaquadahCatalyst)}, new FluidStack[]{Materials.SulfuricAcid.getFluid(16000L), Materials.Oxygen.getGas(100L)}, new FluidStack[]{MyMaterial.wasteLiquid.getFluidOrGas(32000)}, new ItemStack[]{MyMaterial.inertEnrichedNaquadah.get(OrePrefixes.dust, 1), Materials.Trinium.getDust(64)}, new int[]{3300, 3300, 3300}, 200, (int)GT_Values.VP[11], 2);
                CORE.RA.addQuantumTransformerRecipe(new ItemStack[]{MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 32), Materials.Magnesium.getDust(64), GT_Utility.copyAmount((int)0, (ItemStack)GenericChem.mAdvancedNaquadahCatalyst)}, new FluidStack[]{Materials.PhosphoricAcid.getFluid(16000L), Materials.SulfuricAcid.getFluid(16000L), Materials.Oxygen.getGas(100L)}, new FluidStack[0], new ItemStack[]{MyMaterial.inertNaquadria.get(OrePrefixes.dust, 1), Materials.Barium.getDust(64), Materials.Indium.getDust(64), ItemList.NaquadriaSupersolid.get(1L, new Object[0])}, new int[]{2500, 2500, 2500, 2500}, 100, (int)GT_Values.VP[12], 3);
                MyRecipeAdder.instance.addNeutronActivatorRecipe(new FluidStack[]{Materials.Nickel.getPlasma(2304L)}, new ItemStack[]{MyMaterial.inertNaquadah.get(OrePrefixes.dust, 64), MyMaterial.inertNaquadah.get(OrePrefixes.dust, 32)}, new FluidStack[]{Materials.Naquadah.getMolten(0x144000L)}, new ItemStack[]{Materials.Nickel.getDust(16)}, 2000, 600, 500);
                MyRecipeAdder.instance.addNeutronActivatorRecipe(new FluidStack[]{Materials.Titanium.getPlasma(2304L)}, new ItemStack[]{MyMaterial.inertEnrichedNaquadah.get(OrePrefixes.dust, 64), MyMaterial.inertEnrichedNaquadah.get(OrePrefixes.dust, 32)}, new FluidStack[]{Materials.NaquadahEnriched.getMolten(0x144000L)}, new ItemStack[]{Materials.Titanium.getDust(16)}, 2000, 900, 850);
                MyRecipeAdder.instance.addNeutronActivatorRecipe(new FluidStack[]{Materials.Americium.getPlasma(2304L)}, new ItemStack[]{MyMaterial.inertNaquadria.get(OrePrefixes.dust, 64), MyMaterial.inertNaquadria.get(OrePrefixes.dust, 32)}, new FluidStack[]{Materials.Naquadria.getMolten(0x144000L)}, new ItemStack[]{Materials.Americium.getDust(16)}, 2000, 1100, 1080);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.lowQualityNaquadriaSolution.get(OrePrefixes.cell, 1)}).itemOutputs(new ItemStack[]{Materials.Tin.getDust(2)}).duration(334).eut(4).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.naquadahEarth.get(OrePrefixes.dust, 2), GT_Utility.getIntegratedCircuit((int)1)}).fluidInputs(new FluidStack[]{MyMaterial.fluoroantimonicAcid.getFluidOrGas(3000)}).fluidOutputs(new FluidStack[]{MyMaterial.lowQualityNaquadahEmulsion.getFluidOrGas(2000)}).itemOutputs(new ItemStack[]{MyMaterial.titaniumTrifluoride.get(OrePrefixes.dust, 4)}).duration(100).eut(TierEU.RECIPE_HV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)3000).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.titaniumTrifluoride.get(OrePrefixes.dust, 4), GT_Utility.getIntegratedCircuit((int)1)}).fluidInputs(new FluidStack[]{Materials.Hydrogen.getGas(3000L)}).fluidOutputs(new FluidStack[]{Materials.HydrofluoricAcid.getFluid(3000L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)Materials.Titanium, (long)1L)}).duration(120).eut(TierEU.RECIPE_EV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)2000).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.copyAmount((int)0, (ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Copper, (long)1L)), Materials.Hydrogen.getCells(8)}).fluidInputs(new FluidStack[]{FluidRegistry.getFluidStack((String)"seedoil", (int)3000)}).itemOutputs(new ItemStack[]{ItemList.Cell_Empty.get(8L, new Object[0])}).fluidOutputs(new FluidStack[]{MyMaterial.towEthyl1Hexanol.getFluidOrGas(1000)}).duration(400).eut(TierEU.RECIPE_HV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Sodium, (long)2L)}).fluidInputs(new FluidStack[]{MyMaterial.towEthyl1Hexanol.getFluidOrGas(2000), Materials.PhosphoricAcid.getFluid(1000L), Materials.Ethanol.getFluid(2000L)}).fluidOutputs(new FluidStack[]{MyMaterial.P507.getFluidOrGas(1000)}).duration(1200).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.multiblockChemicalReactorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.lowQualityNaquadahSolution.get(OrePrefixes.cell, 36), MyMaterial.P507.get(OrePrefixes.cell, 4)}).itemOutputs(new ItemStack[]{MyMaterial.naquadahAdamantiumSolution.get(OrePrefixes.cell, 30), ItemList.Cell_Empty.get(10L, new Object[0])}).fluidOutputs(new FluidStack[]{MyMaterial.fluorineRichWasteLiquid.getFluidOrGas(10000)}).duration(4000).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.chemicalReactorRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{MyMaterial.P507.getFluidOrGas(4000), MyMaterial.lowQualityNaquadahSolution.getFluidOrGas(36000)}).fluidOutputs(new FluidStack[]{MyMaterial.fluorineRichWasteLiquid.getFluidOrGas(10000), MyMaterial.naquadahAdamantiumSolution.getFluidOrGas(30000)}).duration(4000).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.multiblockChemicalReactorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Quicklime, (long)40L)}).fluidInputs(new FluidStack[]{MyMaterial.fluorineRichWasteLiquid.getFluidOrGas(1500)}).fluidOutputs(new FluidStack[]{MyMaterial.wasteLiquid.getFluidOrGas(1000)}).itemOutputs(new ItemStack[]{WerkstoffLoader.Fluorspar.get(OrePrefixes.dust, 60)}).duration(1000).eut(TierEU.RECIPE_MV).addTo(GT_RecipeConstants.UniversalChemical);
        CrackRecipeAdder.addUniversalDistillationRecipe(MyMaterial.wasteLiquid.getFluidOrGas(10000), new FluidStack[]{Materials.SaltWater.getFluid(3000L), FluidRegistry.getFluidStack((String)"phenol", (int)2000), Materials.HydrochloricAcid.getFluid(5000L)}, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Chrome, (long)3L), 300, TierEU.RECIPE_HV);
        MyRecipeAdder.instance.addNeutronActivatorRecipe(new FluidStack[]{MyMaterial.naquadahAdamantiumSolution.getFluidOrGas(3000)}, null, new FluidStack[]{MyMaterial.naquadahRichSolution.getFluidOrGas(2000)}, new ItemStack[]{MyMaterial.adamantine.get(OrePrefixes.dust, 4), MyMaterial.naquadahEarth.get(OrePrefixes.dust, 2), MyMaterial.concentratedEnrichedNaquadahSludge.get(OrePrefixes.dust, 1)}, 100, 230, 200);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.SodiumHydroxide, (long)27L)}).fluidInputs(new FluidStack[]{MyMaterial.naquadahRichSolution.getFluidOrGas(5000)}).itemOutputs(new ItemStack[]{MyMaterial.naquadahine.get(OrePrefixes.dust, 30)}).fluidOutputs(new FluidStack[]{MyMaterial.P507.getFluidOrGas(1000)}).duration(1000).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.autoclaveRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.naquadahine.get(OrePrefixes.dust, 3), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Carbon, (long)1L)}).fluidOutputs(new FluidStack[]{Materials.CarbonDioxide.getGas(1000L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)Materials.Naquadah, (long)1L)}).duration(40).eut(TierEU.RECIPE_IV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)5000).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.SodiumHydroxide, (long)27L), GT_Utility.getIntegratedCircuit((int)1)}).fluidInputs(new FluidStack[]{MyMaterial.lowQualityNaquadahEmulsion.getFluidOrGas(10000)}).itemOutputs(new ItemStack[]{MyMaterial.galliumHydroxide.get(OrePrefixes.dust, 64), MyMaterial.galliumHydroxide.get(OrePrefixes.dust, 48), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Antimony, (long)15L)}).outputChances(new int[]{6250, 6250, 10000}).fluidOutputs(new FluidStack[]{MyMaterial.lowQualityNaquadahSolution.getFluidOrGas(9000)}).duration(1000).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 4)}).fluidInputs(new FluidStack[]{MyMaterial.P507.getFluidOrGas(1000), Materials.SulfuricAcid.getFluid(18000L)}).fluidOutputs(new FluidStack[]{MyMaterial.enrichedNaquadahRichSolution.getFluidOrGas(4000), MyMaterial.wasteLiquid.getFluidOrGas(1000)}).itemOutputs(new ItemStack[]{MyMaterial.naquadahEarth.get(OrePrefixes.dust, 1), MyMaterial.triniumSulphate.get(OrePrefixes.dust, 1)}).duration(400).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.multiblockChemicalReactorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{WerkstoffLoader.ZincSulfate.get(OrePrefixes.dust, 6)}).fluidInputs(new FluidStack[]{Materials.Hydrogen.getGas(2000L)}).fluidOutputs(new FluidStack[]{Materials.SulfuricAcid.getFluid(1000L)}).itemOutputs(new ItemStack[]{Materials.Zinc.getDust(1)}).duration(30).eut(TierEU.RECIPE_ULV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.SodiumHydroxide, (long)60L)}).fluidInputs(new FluidStack[]{MyMaterial.enrichedNaquadahRichSolution.getFluidOrGas(10000)}).itemOutputs(new ItemStack[]{MyMaterial.concentratedEnrichedNaquadahSludge.get(OrePrefixes.dust, 8)}).fluidOutputs(new FluidStack[]{MyMaterial.P507.getFluidOrGas(2500)}).duration(1000).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.autoclaveRecipes);
        MyRecipeAdder.instance.addNeutronActivatorRecipe(null, new ItemStack[]{MyMaterial.concentratedEnrichedNaquadahSludge.get(OrePrefixes.dust, 16)}, null, new ItemStack[]{MyMaterial.enrichedNaquadahSulphate.get(OrePrefixes.dust, 64), MyMaterial.enrichedNaquadahSulphate.get(OrePrefixes.dust, 64), MyMaterial.enrichedNaquadahSulphate.get(OrePrefixes.dust, 37), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 64), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 64), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 12), MyMaterial.lowQualityNaquadriaSulphate.get(OrePrefixes.dust, 2)}, 120, 480, 460);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.enrichedNaquadahSulphate.get(OrePrefixes.dust, 11), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Zinc, (long)2L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)Materials.NaquadahEnriched, (long)1L), WerkstoffLoader.ZincSulfate.get(OrePrefixes.dust, 12)}).duration(100).eut(TierEU.RECIPE_IV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)7500).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.triniumSulphate.get(OrePrefixes.dust, 6)}).fluidInputs(new FluidStack[]{Materials.Hydrogen.getGas(2000L)}).fluidOutputs(new FluidStack[]{Materials.SulfuricAcid.getFluid(1000L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Trinium, (long)1L)}).duration(120).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.multiblockChemicalReactorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 4)}).fluidInputs(new FluidStack[]{Materials.PhosphoricAcid.getFluid(4000L)}).itemOutputs(new ItemStack[]{MyMaterial.indiumPhosphate.get(OrePrefixes.dust, 6), MyMaterial.lowQualityNaquadriaPhosphate.get(OrePrefixes.dust, 4)}).outputChances(new int[]{2000, 10000}).duration(400).eut(TierEU.RECIPE_ZPM).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.galliumHydroxide.get(OrePrefixes.dust, 7), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Sodium, (long)3L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Gallium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.SodiumHydroxide, (long)9L)}).duration(40).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.indiumPhosphate.get(OrePrefixes.dust, 12), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Calcium, (long)3L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Indium, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.TricalciumPhosphate, (long)5L)}).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.lowQualityNaquadriaPhosphate.get(OrePrefixes.dust, 10), Materials.SulfuricAcid.getCells(30)}).fluidOutputs(new FluidStack[]{MyMaterial.naquadriaRichSolution.getFluidOrGas(9000)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Barite, (long)1L), ItemList.Cell_Empty.get(30L, new Object[0])}).duration(1000).eut(TierEU.RECIPE_IV).addTo(GT_RecipeConstants.UniversalChemical);
        MyRecipeAdder.instance.addNeutronActivatorRecipe(new FluidStack[]{MyMaterial.naquadriaRichSolution.getFluidOrGas(9000)}, null, null, new ItemStack[]{MyMaterial.naquadriaSulphate.get(OrePrefixes.dust, 44), MyMaterial.lowQualityNaquadriaSulphate.get(OrePrefixes.dust, 6)}, 100, 1100, 1050);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.lowQualityNaquadriaSulphate.get(OrePrefixes.dust, 3), Materials.Water.getCells(3)}).fluidInputs(new FluidStack[]{MyMaterial.P507.getFluidOrGas(500)}).fluidOutputs(new FluidStack[]{MyMaterial.lowQualityNaquadriaSolution.getFluidOrGas(3500)}).itemOutputs(new ItemStack[]{ItemList.Cell_Empty.get(3L, new Object[0])}).duration(500).eut(TierEU.RECIPE_EV).addTo(GT_RecipeConstants.UniversalChemical);
        CrackRecipeAdder.addUniversalDistillationRecipe(MyMaterial.lowQualityNaquadriaSolution.getFluidOrGas(7000), new FluidStack[]{MyMaterial.P507.getFluidOrGas(1000), MyMaterial.naquadriaRichSolution.getFluidOrGas(5400), Materials.DilutedSulfuricAcid.getFluid(12000L)}, MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 2), 500, TierEU.RECIPE_IV);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.naquadriaSulphate.get(OrePrefixes.dust, 11), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Magnesium, (long)2L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)Materials.Naquadria, (long)1L), MyMaterial.magnesiumSulphate.get(OrePrefixes.dust, 12)}).duration(100).eut(TierEU.RECIPE_ZPM).metadata(GT_RecipeConstants.COIL_HEAT, (Object)9100).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.indiumPhosphate.get(OrePrefixes.dust, 6), MyMaterial.galliumHydroxide.get(OrePrefixes.dust, 7), GT_Utility.getIntegratedCircuit((int)2)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.IndiumGalliumPhosphide, (long)3L)}).duration(15).eut(TierEU.RECIPE_ULV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Ball.get(0L, new Object[0])}).fluidInputs(new FluidStack[]{MyMaterial.naquadahGoo.getFluidOrGas(72)}).itemOutputs(new ItemStack[]{ItemRefer.Naquadah_Mass.get(1)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Ball.get(0L, new Object[0])}).fluidInputs(new FluidStack[]{MyMaterial.enrichedNaquadahGoo.getFluidOrGas(72)}).itemOutputs(new ItemStack[]{ItemRefer.Enriched_Naquadah_Mass.get(1)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Ball.get(0L, new Object[0])}).fluidInputs(new FluidStack[]{MyMaterial.naquadriaGoo.getFluidOrGas(72)}).itemOutputs(new ItemStack[]{ItemRefer.Naquadria_Mass.get(1)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemRefer.Naquadah_Mass.get(1)}).itemOutputs(new ItemStack[]{MyMaterial.naquadahEarth.get(OrePrefixes.dust, 1), MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1)}).outputChances(new int[]{10000, 100}).duration(100).eut(2).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemRefer.Enriched_Naquadah_Mass.get(1)}).itemOutputs(new ItemStack[]{MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1), MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1)}).outputChances(new int[]{10000, 100}).duration(100).eut(2).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemRefer.Naquadria_Mass.get(1)}).itemOutputs(new ItemStack[]{MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1), MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1)}).outputChances(new int[]{10000, 100}).duration(100).eut(2).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.block, (Object)Materials.SiliconSG, (long)16L), MyMaterial.naquadahine.get(OrePrefixes.dust, 3), ItemList.GalliumArsenideCrystal.get(1L, new Object[0])}).fluidInputs(new FluidStack[]{Materials.Argon.getGas(8000L)}).itemOutputs(new ItemStack[]{ItemList.Circuit_Silicon_Ingot3.get(1L, new Object[0])}).duration(1000).eut(TierEU.RECIPE_IV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)4484).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.naquadahine.get(OrePrefixes.dust, 3), Materials.Sodium.getDust(4)}).itemOutputs(new ItemStack[]{Materials.Naquadah.getDust(1), Materials.SodiumOxide.getDust(6)}).duration(100).eut(TierEU.RECIPE_EV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MyMaterial.naquadahEarth.get(OrePrefixes.dust, 2), GT_Utility.getIntegratedCircuit((int)2)}).fluidInputs(new FluidStack[]{Materials.Nitrogen.getGas(1000L)}).itemOutputs(new ItemStack[]{Materials.Naquadah.getNuggets(1)}).duration(2400).eut(TierEU.RECIPE_IV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)5000).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)24)}).fluidInputs(new FluidStack[]{Materials.Ethylene.getGas(1000L), FluidRegistry.getFluidStack((String)"steam", (int)2000)}).fluidOutputs(new FluidStack[]{Materials.Ethanol.getFluid(1000L)}).duration(400).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.multiblockChemicalReactorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Ethylene.getCells(1), GT_Utility.getIntegratedCircuit((int)24)}).fluidInputs(new FluidStack[]{FluidRegistry.getFluidStack((String)"steam", (int)2000)}).itemOutputs(new ItemStack[]{Materials.Ethanol.getCells(1)}).duration(400).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.chemicalReactorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)Materials.Naquadah, (long)1L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Naquadah, (long)1L)}).duration(320).eut(TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.vacuumFreezerRecipes);
    }

    public static void SmallRecipeChange() {
        GT_Recipe tRecipe2;
        GT_Recipe tRecipe = RecipeMaps.chemicalReactorRecipes.findRecipe(null, false, 0x40000000L, new FluidStack[]{Materials.SulfuricAcid.getFluid(500L)}, new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Platinum, (long)16L), ItemList.Empty_Board_Elite.get(2L, new Object[0])});
        if (tRecipe != null) {
            RecipeMaps.chemicalReactorRecipes.getBackend().removeRecipe(tRecipe);
            tRecipe2 = tRecipe.copy();
            tRecipe2.mInputs = new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Naquadah, (long)8L), ItemList.Empty_Board_Elite.get(2L, new Object[0])};
            RecipeMaps.chemicalReactorRecipes.add(tRecipe2);
            RecipeMaps.chemicalReactorRecipes.getBackend().reInit();
        }
        if ((tRecipe = RecipeMaps.multiblockChemicalReactorRecipes.findRecipe(null, false, 0x40000000L, new FluidStack[]{Materials.SulfuricAcid.getFluid(500L)}, new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Platinum, (long)16L), ItemList.Empty_Board_Elite.get(2L, new Object[0])})) != null) {
            RecipeMaps.multiblockChemicalReactorRecipes.getBackend().removeRecipe(tRecipe);
            tRecipe2 = tRecipe.copy();
            tRecipe2.mInputs = new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Naquadah, (long)8L), ItemList.Empty_Board_Elite.get(2L, new Object[0])};
            RecipeMaps.multiblockChemicalReactorRecipes.add(tRecipe2);
            RecipeMaps.multiblockChemicalReactorRecipes.getBackend().reInit();
        }
        if ((tRecipe = RecipeMaps.assemblerRecipes.findRecipe(null, false, 0x40000000L, new FluidStack[]{Materials.Polybenzimidazole.getMolten(36L)}, new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Polybenzimidazole, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.HSSS, (long)1L), GT_Utility.getIntegratedCircuit((int)1)})) != null) {
            ((AssemblerBackend)RecipeMaps.assemblerRecipes.getBackend()).removeRecipe(tRecipe);
            tRecipe2 = tRecipe.copy();
            tRecipe2.mInputs = new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Polybenzimidazole, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.NaquadahEnriched, (long)1L)};
            RecipeMaps.assemblerRecipes.add(tRecipe2);
            ((AssemblerBackend)RecipeMaps.assemblerRecipes.getBackend()).reInit();
        }
    }

    public static void Remover() {
        int i;
        int modified;
        int i2;
        boolean modified2;
        GT_Recipe tRecipe;
        int oreDictID2;
        int n;
        int n2;
        int[] oreDict;
        ItemStack input;
        if (!GG_Config_Loader.EnableNaquadahRework) {
            return;
        }
        GT_Log.out.print("GoodGenerator: Begin to remove pure Naquadah, Enriched Naquadah and Naquadria.\n");
        HashSet<GT_Recipe> remove = new HashSet<GT_Recipe>(5000);
        HashSet<GT_Recipe> reAdd = new HashSet<GT_Recipe>(5000);
        block0: for (GT_Recipe recipe : RecipeMaps.maceratorRecipes.getAllRecipes()) {
            input = recipe.mInputs[0];
            if (!GT_Utility.isStackValid((ItemStack)input)) continue;
            int[] nArray = oreDict = OreDictionary.getOreIDs((ItemStack)input);
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int oreDictID2 = nArray[n];
                if (!OreDictionary.getOreName((int)oreDictID2).startsWith("ore") && !OreDictionary.getOreName((int)oreDictID2).startsWith("crushed") || !OreDictionary.getOreName((int)oreDictID2).contains("Naq")) continue;
                GT_Recipe tRecipe2 = recipe.copy();
                boolean modified22 = false;
                for (int i3 = 0; i3 < tRecipe2.mOutputs.length; ++i3) {
                    if (!GT_Utility.isStackValid((ItemStack)tRecipe2.mOutputs[i3])) continue;
                    if (tRecipe2.mOutputs[i3].func_77969_a(Materials.Naquadah.getDust(1))) {
                        tRecipe2.mOutputs[i3] = GT_Utility.copyAmount((int)(tRecipe2.mOutputs[i3].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                        modified22 = true;
                        continue;
                    }
                    if (tRecipe2.mOutputs[i3].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                        tRecipe2.mOutputs[i3] = GT_Utility.copyAmount((int)(tRecipe2.mOutputs[i3].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                        modified22 = true;
                        continue;
                    }
                    if (!tRecipe2.mOutputs[i3].func_77969_a(Materials.Naquadria.getDust(1))) continue;
                    tRecipe2.mOutputs[i3] = GT_Utility.copyAmount((int)(tRecipe2.mOutputs[i3].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
                    modified22 = true;
                }
                if (!modified22) continue block0;
                reAdd.add(tRecipe2);
                remove.add(recipe);
                continue block0;
            }
        }
        RecipeMaps.maceratorRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(arg_0 -> ((RecipeMap)RecipeMaps.maceratorRecipes).add(arg_0));
        RecipeMaps.maceratorRecipes.getBackend().reInit();
        GT_Log.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Crusher done!\n");
        block3: for (GT_Recipe recipe : RecipeMaps.oreWasherRecipes.getAllRecipes()) {
            input = recipe.mInputs[0];
            if (!GT_Utility.isStackValid((ItemStack)input)) continue;
            int[] nArray = oreDict = OreDictionary.getOreIDs((ItemStack)input);
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                oreDictID2 = nArray[n];
                if (!OreDictionary.getOreName((int)oreDictID2).startsWith("crushed") || !OreDictionary.getOreName((int)oreDictID2).contains("Naq")) continue;
                tRecipe = recipe.copy();
                modified2 = false;
                for (i2 = 0; i2 < tRecipe.mOutputs.length; ++i2) {
                    if (!GT_Utility.isStackValid((ItemStack)tRecipe.mOutputs[i2])) continue;
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (!tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDust(1))) continue;
                    tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
                    modified2 = true;
                }
                if (!modified2) continue block3;
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block3;
            }
        }
        RecipeMaps.oreWasherRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(arg_0 -> ((RecipeMap)RecipeMaps.oreWasherRecipes).add(arg_0));
        RecipeMaps.oreWasherRecipes.getBackend().reInit();
        GT_Log.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Washer done!\n");
        block6: for (GT_Recipe recipe : RecipeMaps.thermalCentrifugeRecipes.getAllRecipes()) {
            input = recipe.mInputs[0];
            if (!GT_Utility.isStackValid((ItemStack)input)) continue;
            int[] nArray = oreDict = OreDictionary.getOreIDs((ItemStack)input);
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                oreDictID2 = nArray[n];
                if (!OreDictionary.getOreName((int)oreDictID2).startsWith("crushed") || !OreDictionary.getOreName((int)oreDictID2).contains("Naq")) continue;
                tRecipe = recipe.copy();
                modified2 = false;
                for (i2 = 0; i2 < tRecipe.mOutputs.length; ++i2) {
                    if (!GT_Utility.isStackValid((ItemStack)tRecipe.mOutputs[i2])) continue;
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (!tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDust(1))) continue;
                    tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
                    modified2 = true;
                }
                if (!modified2) continue block6;
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block6;
            }
        }
        RecipeMaps.thermalCentrifugeRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(arg_0 -> ((RecipeMap)RecipeMaps.thermalCentrifugeRecipes).add(arg_0));
        RecipeMaps.thermalCentrifugeRecipes.getBackend().reInit();
        GT_Log.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Thermal Centrifuge done!\n");
        block9: for (GT_Recipe recipe : RecipeMaps.centrifugeRecipes.getAllRecipes()) {
            input = null;
            if (recipe.mInputs.length > 0) {
                input = recipe.mInputs[0];
            }
            if (!GT_Utility.isStackValid((ItemStack)input)) continue;
            oreDict = OreDictionary.getOreIDs((ItemStack)input);
            if (input.func_77969_a(GT_Bees.combs.getStackForType(CombType.DOB))) {
                GT_Recipe gT_Recipe = recipe.copy();
                modified = 0;
                for (int i22 = 0; i22 < gT_Recipe.mOutputs.length; ++i22) {
                    if (!GT_Utility.isStackValid((ItemStack)gT_Recipe.mOutputs[i22]) || !gT_Recipe.mOutputs[i22].func_77969_a(Materials.Naquadah.getDustTiny(1))) continue;
                    gT_Recipe.mOutputs[i22] = GT_Utility.copyAmount((long)((long)gT_Recipe.mOutputs[i22].field_77994_a * 2L), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dustTiny, 1));
                    modified = 1;
                }
                if (modified == 0) continue;
                reAdd.add(gT_Recipe);
                remove.add(recipe);
                continue;
            }
            for (int oreDictID2 : oreDict) {
                if (!OreDictionary.getOreName((int)oreDictID2).startsWith("dustPureNaq") && !OreDictionary.getOreName((int)oreDictID2).startsWith("dustImpureNaq") && !OreDictionary.getOreName((int)oreDictID2).startsWith("dustSpace") && !OreDictionary.getOreName((int)oreDictID2).startsWith("dustNaq")) continue;
                tRecipe = recipe.copy();
                modified2 = false;
                for (i2 = 0; i2 < tRecipe.mOutputs.length; ++i2) {
                    if (!GT_Utility.isStackValid((ItemStack)tRecipe.mOutputs[i2])) continue;
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDustTiny(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dustTiny, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDustTiny(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dustTiny, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDustTiny(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dustTiny, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDustSmall(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dustSmall, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDustSmall(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dustSmall, 1));
                        modified2 = true;
                        continue;
                    }
                    if (!tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDustSmall(1))) continue;
                    tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dustSmall, 1));
                    modified2 = true;
                }
                if (!modified2) continue block9;
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block9;
            }
        }
        RecipeMaps.centrifugeRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(arg_0 -> ((RecipeMap)RecipeMaps.centrifugeRecipes).add(arg_0));
        RecipeMaps.centrifugeRecipes.getBackend().reInit();
        GT_Log.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Centrifuge done!\n");
        block13: for (GT_Recipe recipe : RecipeMaps.centrifugeNonCellRecipes.getAllRecipes()) {
            input = null;
            if (recipe.mInputs.length > 0) {
                input = recipe.mInputs[0];
            }
            if (!GT_Utility.isStackValid((ItemStack)input)) continue;
            oreDict = OreDictionary.getOreIDs((ItemStack)input);
            if (input.func_77969_a(GT_Bees.combs.getStackForType(CombType.DOB))) {
                GT_Recipe gT_Recipe = recipe.copy();
                modified = 0;
                for (int i3 = 0; i3 < gT_Recipe.mOutputs.length; ++i3) {
                    if (!GT_Utility.isStackValid((ItemStack)gT_Recipe.mOutputs[i3]) || !gT_Recipe.mOutputs[i3].func_77969_a(Materials.Naquadah.getDustTiny(1))) continue;
                    gT_Recipe.mOutputs[i3] = GT_Utility.copyAmount((long)((long)gT_Recipe.mOutputs[i3].field_77994_a * 2L), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dustTiny, 1));
                    modified = 1;
                }
                if (modified == 0) continue;
                reAdd.add(gT_Recipe);
                remove.add(recipe);
                continue;
            }
            int[] nArray = oreDict;
            modified = nArray.length;
            for (n = 0; n < modified; ++n) {
                oreDictID2 = nArray[n];
                if (!OreDictionary.getOreName((int)oreDictID2).startsWith("dustPureNaq") && !OreDictionary.getOreName((int)oreDictID2).startsWith("dustImpureNaq") && !OreDictionary.getOreName((int)oreDictID2).startsWith("dustSpace") && !OreDictionary.getOreName((int)oreDictID2).startsWith("dustNaq")) continue;
                tRecipe = recipe.copy();
                modified2 = false;
                for (i2 = 0; i2 < tRecipe.mOutputs.length; ++i2) {
                    if (!GT_Utility.isStackValid((ItemStack)tRecipe.mOutputs[i2])) continue;
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDustTiny(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dustTiny, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDustTiny(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dustTiny, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDustTiny(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dustTiny, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDustSmall(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dustSmall, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDustSmall(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dustSmall, 1));
                        modified2 = true;
                        continue;
                    }
                    if (!tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDustSmall(1))) continue;
                    tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dustSmall, 1));
                    modified2 = true;
                }
                if (!modified2) continue block13;
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block13;
            }
        }
        RecipeMaps.centrifugeNonCellRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(arg_0 -> ((RecipeMap)RecipeMaps.centrifugeNonCellRecipes).add(arg_0));
        RecipeMaps.centrifugeNonCellRecipes.getBackend().reInit();
        GT_Log.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Centrifuge (PA) done!\n");
        block17: for (GT_Recipe recipe : RecipeMaps.hammerRecipes.getAllRecipes()) {
            input = recipe.mInputs[0];
            if (!GT_Utility.isStackValid((ItemStack)input)) continue;
            int[] nArray = oreDict = OreDictionary.getOreIDs((ItemStack)input);
            modified = nArray.length;
            for (n = 0; n < modified; ++n) {
                oreDictID2 = nArray[n];
                if (!OreDictionary.getOreName((int)oreDictID2).startsWith("crushed") || !OreDictionary.getOreName((int)oreDictID2).contains("Naq")) continue;
                tRecipe = recipe.copy();
                modified2 = false;
                for (i2 = 0; i2 < tRecipe.mOutputs.length; ++i2) {
                    if (!GT_Utility.isStackValid((ItemStack)tRecipe.mOutputs[i2])) continue;
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                        continue;
                    }
                    if (!tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDust(1))) continue;
                    tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)(tRecipe.mOutputs[i2].field_77994_a * 2), (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
                    modified2 = true;
                }
                if (!modified2) continue block17;
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block17;
            }
        }
        RecipeMaps.hammerRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(arg_0 -> ((RecipeMap)RecipeMaps.hammerRecipes).add(arg_0));
        RecipeMaps.hammerRecipes.getBackend().reInit();
        GT_Log.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Hammer done!\n");
        for (GT_Recipe recipe : RecipeMaps.chemicalReactorRecipes.getAllRecipes()) {
            if (recipe.mFluidOutputs == null) continue;
            boolean isAny = false;
            for (int i4 = 0; i4 < recipe.mFluidOutputs.length; ++i4) {
                if (recipe.mFluidOutputs[i4] == null || !recipe.mFluidOutputs[i4].isFluidEqual(Materials.Naquadah.getMolten(1L)) && !recipe.mFluidOutputs[i4].isFluidEqual(Materials.NaquadahEnriched.getMolten(1L)) && !recipe.mFluidOutputs[i4].isFluidEqual(Materials.Naquadria.getMolten(1L))) continue;
                isAny = true;
                break;
            }
            if (!isAny) continue;
            GT_Recipe tRecipe3 = recipe.copy();
            boolean bl = false;
            for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                if (recipe.mFluidOutputs[i] == null) continue;
                if (recipe.mFluidOutputs[i].isFluidEqual(Materials.Naquadah.getMolten(1L))) {
                    tRecipe3.mFluidOutputs[i] = MyMaterial.naquadahGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                    bl = true;
                    continue;
                }
                if (recipe.mFluidOutputs[i].isFluidEqual(Materials.NaquadahEnriched.getMolten(1L))) {
                    tRecipe3.mFluidOutputs[i] = MyMaterial.enrichedNaquadahGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                    bl = true;
                    continue;
                }
                if (!recipe.mFluidOutputs[i].isFluidEqual(Materials.Naquadria.getMolten(1L))) continue;
                tRecipe3.mFluidOutputs[i] = MyMaterial.naquadriaGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                bl = true;
            }
            if (!bl) continue;
            reAdd.add(tRecipe3);
            remove.add(recipe);
        }
        RecipeMaps.chemicalReactorRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(arg_0 -> ((RecipeMap)RecipeMaps.chemicalReactorRecipes).add(arg_0));
        RecipeMaps.chemicalReactorRecipes.getBackend().reInit();
        GT_Log.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Chemical Reactor done!\n");
        for (GT_Recipe recipe : RecipeMaps.multiblockChemicalReactorRecipes.getAllRecipes()) {
            if (recipe.mFluidOutputs == null) continue;
            boolean isAny = false;
            for (int i5 = 0; i5 < recipe.mFluidOutputs.length; ++i5) {
                if (recipe.mFluidOutputs[i5] == null || !recipe.mFluidOutputs[i5].isFluidEqual(Materials.Naquadah.getMolten(1L)) && !recipe.mFluidOutputs[i5].isFluidEqual(Materials.NaquadahEnriched.getMolten(1L)) && !recipe.mFluidOutputs[i5].isFluidEqual(Materials.Naquadria.getMolten(1L))) continue;
                isAny = true;
                break;
            }
            if (!isAny) continue;
            GT_Recipe tRecipe4 = recipe.copy();
            boolean bl = false;
            for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                if (recipe.mFluidOutputs[i] == null) continue;
                if (recipe.mFluidOutputs[i].isFluidEqual(Materials.Naquadah.getMolten(1L))) {
                    tRecipe4.mFluidOutputs[i] = MyMaterial.naquadahGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                    bl = true;
                    continue;
                }
                if (recipe.mFluidOutputs[i].isFluidEqual(Materials.NaquadahEnriched.getMolten(1L))) {
                    tRecipe4.mFluidOutputs[i] = MyMaterial.enrichedNaquadahGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                    bl = true;
                    continue;
                }
                if (!recipe.mFluidOutputs[i].isFluidEqual(Materials.Naquadria.getMolten(1L))) continue;
                tRecipe4.mFluidOutputs[i] = MyMaterial.naquadriaGoo.getFluidOrGas(recipe.mFluidOutputs[i].amount * 2);
                bl = true;
            }
            if (!bl) continue;
            reAdd.add(tRecipe4);
            remove.add(recipe);
        }
        RecipeMaps.multiblockChemicalReactorRecipes.getBackend().removeRecipes(remove);
        reAdd.forEach(arg_0 -> ((RecipeMap)RecipeMaps.multiblockChemicalReactorRecipes).add(arg_0));
        RecipeMaps.multiblockChemicalReactorRecipes.getBackend().reInit();
        GT_Log.out.print("GoodGenerator: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Multi Chemical Reactor done!\n");
        if (Mods.GTPlusPlus.isModLoaded()) {
            block26: for (GT_Recipe recipe : GTPPRecipeMaps.simpleWasherRecipes.getAllRecipes()) {
                int[] oreDict2;
                ItemStack input2 = recipe.mInputs[0];
                if (!GT_Utility.isStackValid((ItemStack)input2)) continue;
                for (int oreDictID2 : oreDict2 = OreDictionary.getOreIDs((ItemStack)input2)) {
                    if (!OreDictionary.getOreName((int)oreDictID2).startsWith("dustImpureNaq") && !OreDictionary.getOreName((int)oreDictID2).startsWith("dustPureNaq")) continue;
                    tRecipe = recipe.copy();
                    modified2 = false;
                    for (i2 = 0; i2 < tRecipe.mOutputs.length; ++i2) {
                        if (!GT_Utility.isStackValid((ItemStack)tRecipe.mOutputs[i2])) continue;
                        if (tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadah.getDust(1))) {
                            tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)tRecipe.mOutputs[i2].field_77994_a, (ItemStack)MyMaterial.naquadahEarth.get(OrePrefixes.dust, 1));
                            modified2 = true;
                            continue;
                        }
                        if (tRecipe.mOutputs[i2].func_77969_a(Materials.NaquadahEnriched.getDust(1))) {
                            tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)tRecipe.mOutputs[i2].field_77994_a, (ItemStack)MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 1));
                            modified2 = true;
                            continue;
                        }
                        if (!tRecipe.mOutputs[i2].func_77969_a(Materials.Naquadria.getDust(1))) continue;
                        tRecipe.mOutputs[i2] = GT_Utility.copyAmount((int)tRecipe.mOutputs[i2].field_77994_a, (ItemStack)MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 1));
                        modified2 = true;
                    }
                    if (!modified2) continue block26;
                    reAdd.add(tRecipe);
                    remove.add(recipe);
                    continue block26;
                }
            }
            GTPPRecipeMaps.simpleWasherRecipes.getBackend().removeRecipes(remove);
            reAdd.forEach(arg_0 -> ((RecipeMap)GTPPRecipeMaps.simpleWasherRecipes).add(arg_0));
            GTPPRecipeMaps.simpleWasherRecipes.getBackend().reInit();
            GT_Log.out.print("GoodGenerator: Replace " + remove.size() + "! ");
            remove.clear();
            reAdd.clear();
            GT_Log.out.print("Simple Washer done!\n");
        }
        GT_MetaGenerated_Item_01.registerCauldronCleaningFor((Materials)Materials.Naquadah, (Materials)MyMaterial.naquadahEarth.getBridgeMaterial());
        GT_MetaGenerated_Item_01.registerCauldronCleaningFor((Materials)Materials.NaquadahEnriched, (Materials)MyMaterial.enrichedNaquadahEarth.getBridgeMaterial());
        GT_MetaGenerated_Item_01.registerCauldronCleaningFor((Materials)Materials.Naquadria, (Materials)MyMaterial.naquadriaEarth.getBridgeMaterial());
        GT_Log.out.print("GoodGenerator: Replace 3! ");
        GT_Log.out.print("Cauldron Wash done!\n");
        CraftingManager.func_77594_a().func_77592_b().forEach(NaquadahReworkRecipeLoader::replaceInCraftTable);
        GT_Log.out.print("GoodGenerator: Replace Unknown! ");
        GT_Log.out.print("Crafting Table done!\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceInCraftTable(Object obj) {
        boolean isOk;
        Object input;
        Field in;
        Field out;
        ItemStack result;
        IRecipe recipe;
        Method recipeCheck;
        PlatinumSludgeOverHaul BartObj;
        block42: {
            Constructor cs = null;
            BartObj = null;
            try {
                cs = PlatinumSludgeOverHaul.class.getDeclaredConstructor(new Class[0]);
                cs.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            if (cs == null) {
                return;
            }
            try {
                BartObj = (PlatinumSludgeOverHaul)cs.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
            recipeCheck = null;
            try {
                recipeCheck = PlatinumSludgeOverHaul.class.getDeclaredMethod("checkRecipe", Object.class, Materials.class);
                recipeCheck.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String inputName = "output";
            String inputItemName = "input";
            if (!(obj instanceof ShapedOreRecipe) && !(obj instanceof ShapelessOreRecipe) && (obj instanceof ShapedRecipes || obj instanceof ShapelessRecipes)) {
                inputName = "recipeOutput";
                inputItemName = "recipeItems";
            }
            recipe = (IRecipe)obj;
            result = recipe.func_77571_b();
            out = FieldUtils.getDeclaredField(recipe.getClass(), (String)inputName, (boolean)true);
            if (out == null) {
                out = FieldUtils.getField(recipe.getClass(), (String)inputName, (boolean)true);
            }
            if ((in = FieldUtils.getDeclaredField(recipe.getClass(), (String)inputItemName, (boolean)true)) == null) {
                in = FieldUtils.getField(recipe.getClass(), (String)inputItemName, (boolean)true);
            }
            if (in == null) {
                return;
            }
            try {
                boolean doForceAccess;
                if (!Modifier.isFinal(in.getModifiers())) break block42;
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                boolean bl = doForceAccess = !modifiersField.isAccessible();
                if (doForceAccess) {
                    modifiersField.setAccessible(true);
                }
                try {
                    modifiersField.setInt(in, in.getModifiers() & 0xFFFFFFEF);
                }
                finally {
                    if (doForceAccess) {
                        modifiersField.setAccessible(false);
                    }
                }
            }
            catch (NoSuchFieldException modifiersField) {
            }
            catch (IllegalAccessException modifiersField) {
                // empty catch block
            }
        }
        try {
            input = in.get(obj);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        if (out == null || recipeCheck == null) {
            return;
        }
        if (GT_Utility.areStacksEqual((ItemStack)result, (ItemStack)Materials.Naquadah.getDust(1), (boolean)true)) {
            recipeCheck.setAccessible(true);
            isOk = true;
            try {
                isOk = (Boolean)recipeCheck.invoke((Object)BartObj, input, Materials.Naquadah);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            if (isOk) {
                return;
            }
            try {
                out.set(recipe, MyMaterial.naquadahEarth.get(OrePrefixes.dust, 2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (GT_Utility.areStacksEqual((ItemStack)result, (ItemStack)Materials.NaquadahEnriched.getDust(1), (boolean)true)) {
            recipeCheck.setAccessible(true);
            isOk = true;
            try {
                isOk = (Boolean)recipeCheck.invoke((Object)BartObj, input, Materials.NaquadahEnriched);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                // empty catch block
            }
            if (isOk) {
                return;
            }
            try {
                out.set(recipe, MyMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (GT_Utility.areStacksEqual((ItemStack)result, (ItemStack)Materials.Naquadria.getDust(1), (boolean)true)) {
            recipeCheck.setAccessible(true);
            isOk = true;
            try {
                isOk = (Boolean)recipeCheck.invoke((Object)BartObj, input, Materials.Naquadria);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                // empty catch block
            }
            if (isOk) {
                return;
            }
            try {
                out.set(recipe, MyMaterial.naquadriaEarth.get(OrePrefixes.dust, 2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

